//----------------------------------------------------------------------------
//
// Module:      RequestDialog.java      
//
// Description: Request dialog box for 1 string for FesiFTP
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

class RequestDialog extends Dialog {
    
    String request = null;
    String reply = null;
    TextField tfReply = null;
    

    /**
     * Create a parameter request dialog
     *
     * @param   parent  The parent frame
     * @param   center  Where to put the window
     * @param   requestTitle  The title of the window
     * @param   requestText  The label to request information
     * @param   defaultAnswer  A default value or ""
     */
    RequestDialog (Frame parent, 
                    Point center, 
                    String requestTitle, 
                    String requestText,
                    String defaultAnswer) {
        super(parent, requestTitle, true);
        Label lblTmp;
        GridBagConstraints gbc;
        
        if (defaultAnswer== null) defaultAnswer = "";
        
        // Specify a LayoutManager for it
        this.setLayout(new BorderLayout(10, 10));
        
        // Entry fiels
        Panel pnlEntry = new Panel ();
        GridBagLayout gbTemp  = new GridBagLayout ();
        pnlEntry.setLayout (gbTemp);

        lblTmp = new Label(requestText, Label.RIGHT);
        gbc        = new GridBagConstraints ();
        gbc.anchor = GridBagConstraints.EAST;
        gbc.insets = new Insets (5, 3, 0, 0);
        gbTemp.setConstraints (lblTmp, gbc);
        pnlEntry.add(lblTmp);

        tfReply = new TextField(defaultAnswer,40);
        gbc           = new GridBagConstraints ();
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.insets    = new Insets (5, 0, 0, 3);
        gbTemp.setConstraints (tfReply, gbc);
        pnlEntry.add(tfReply);

        
        this.add("Center", pnlEntry);


        Panel pnlButtons = new Panel ();
        pnlButtons.setLayout (new FlowLayout());
        
        Button bCancel = new Button("Cancel");
        bCancel.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                reply = null;  // To mark cancelled rather than default
                RequestDialog.this.dispose();
            }
        });
        pnlButtons.add(bCancel);

        Button bOk = new Button("   OK   "); // Poor man's centering
        bOk.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                reply = tfReply.getText();
                RequestDialog.this.dispose();
            }
        });
        pnlButtons.add(bOk);
        
        this.add("South", pnlButtons);

        this.pack();
        setLocation (center.x - (getSize ().width / 2), center.y - (getSize ().height / 2));

        tfReply.requestFocus ();
    }
}