package FesiForm;

import org.xml.sax.*;


public class JFrameDocumentHandler extends DefaultDocumentHandler implements DocumentHandler {

    public JFrameDocumentHandler(GuiContext guiContext, boolean trace) {
        super(guiContext, trace);
    }
  
     // Receive notification of character data. 
     public void characters(char[] ch, int start, int length) throws SAXException {
         if (trace) System.out.println("CHARACTERS: [[" + new String(ch) + "]]");
         System.err.println("Unexpected CHARACTERS ignored");
     }
      
     
     // Receive notification of the end of an element. 
     public void endElement(java.lang.String name) throws SAXException {
         if (trace) System.out.println("END_ELEMENT: </" + name + ">");
         System.err.println("Unexpected END_ELEMENT ignored");
     }
      
     // Receive notification of ignorable whitespace in element content. 
     public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
         if (trace) System.out.println("IGNORABLE_WHITESPACE: " + length);
     }
      
     // Receive notification of a processing instruction. 
     public void processingInstruction(java.lang.String target, java.lang.String data) throws SAXException {
         if (trace) System.out.println("PROCESSING_INSTRUCTIONS: '" + data + "'");
         System.err.println("Unexpected PROCESSING_INSTRUCTIONS ignored");
     }
      
      
     // Receive an object for locating the origin of SAX document events. 
     public void setDocumentLocator(Locator locator) {
         if (trace) System.out.println("SET_DOCUMENT_LOCATOR: " + locator);
         System.err.println("Unexpected SET_DOCUMENT_LOCATOR ignored");
     }
      
      
     // Receive notification of the beginning of an element.
     public void startElement(java.lang.String name, AttributeList atts) throws SAXException {
         if (trace) System.out.println("START_ELEMENT: <" + name + ">, " + 
                                         atts.getLength() + " attribute(s)");
         System.err.println("Unexpected START_ELEMENT ignored");
     }
     
     
 
 }