/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyGlobal;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.EOFError;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.util.RubyInputStream;

public class RubyIO
extends RubyObject {
    protected RubyInputStream inStream = null;
    protected OutputStream outStream = null;
    protected boolean sync = false;
    protected boolean readable = false;
    protected boolean writeable = false;
    protected boolean append = false;
    protected int lineNumber = 0;
    protected String path;
    static /* synthetic */ Class class$org$jruby$RubyIO;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;
    static /* synthetic */ Class class$org$jruby$RubyBoolean;

    public RubyIO(Ruby ruby) {
        super(ruby, ruby.getClasses().getIoClass());
    }

    public RubyIO(Ruby ruby, RubyClass type) {
        super(ruby, type);
    }

    public static RubyClass createIOClass(Ruby ruby) {
        RubyClass ioClass = ruby.defineClass("IO", ruby.getClasses().getObjectClass());
        ioClass.includeModule(ruby.getClasses().getEnumerableModule());
        ioClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "newInstance"));
        ioClass.defineSingletonMethod("foreach", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "foreach", class$java$lang$String == null ? (class$java$lang$String = RubyIO.class$("java.lang.String")) : class$java$lang$String));
        ioClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "initialize"));
        ioClass.defineMethod("write", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "write", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyIO.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        ioClass.defineMethod("<<", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "addString", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyIO.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        ioClass.defineMethod("each", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "each_line"));
        ioClass.defineMethod("each_line", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "each_line"));
        ioClass.defineMethod("each_byte", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "each_byte"));
        ioClass.defineMethod("getc", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "getc"));
        ioClass.defineMethod("readchar", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "readchar"));
        ioClass.defineMethod("gets", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "gets"));
        ioClass.defineMethod("readline", CallbackFactory.getOptMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "readline"));
        ioClass.defineMethod("lineno", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "lineno"));
        ioClass.defineMethod("lineno=", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "lineno_set", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyIO.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        ioClass.defineMethod("sync", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "sync"));
        ioClass.defineMethod("sync=", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "sync_set", class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyIO.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean));
        ioClass.defineMethod("close", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "close"));
        ioClass.defineMethod("eof?", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "eof"));
        ioClass.defineMethod("flush", CallbackFactory.getMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "flush"));
        ioClass.defineMethod("print", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "print"));
        ioClass.defineMethod("printf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "printf"));
        ioClass.defineMethod("puts", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyIO == null ? (class$org$jruby$RubyIO = RubyIO.class$("org.jruby.RubyIO")) : class$org$jruby$RubyIO, "puts"));
        return ioClass;
    }

    public static RubyObject stdin(Ruby ruby, RubyClass rubyClass) {
        RubyIO io = new RubyIO(ruby, rubyClass);
        io.inStream = new RubyInputStream(ruby.getRuntime().getInputStream());
        io.readable = true;
        return io;
    }

    public static RubyObject stdout(Ruby ruby, RubyClass rubyClass) {
        RubyIO io = new RubyIO(ruby, rubyClass);
        io.outStream = ruby.getRuntime().getOutputStream();
        io.writeable = true;
        return io;
    }

    public static RubyObject stderr(Ruby ruby, RubyClass rubyClass) {
        RubyIO io = new RubyIO(ruby, rubyClass);
        io.outStream = ruby.getRuntime().getErrorStream();
        io.writeable = true;
        return io;
    }

    protected void checkWriteable() {
        if (!this.writeable || this.outStream == null) {
            throw new IOError(this.getRuby(), "not opened for writing");
        }
    }

    protected void checkReadable() {
        if (!this.readable || this.inStream == null) {
            throw new IOError(this.getRuby(), "not opened for reading");
        }
    }

    protected boolean isReadable() {
        return this.readable;
    }

    protected boolean isWriteable() {
        return this.writeable;
    }

    protected void closeStreams() {
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException ioExcptn) {
                // empty catch block
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inStream = null;
        this.outStream = null;
    }

    public RubyObject callWrite(RubyObject anObject) {
        return this.funcall("write", anObject);
    }

    protected void setMode(String mode) {
        this.readable = false;
        this.writeable = false;
        this.append = false;
        if (mode.length() == 0) {
            throw new RubyArgumentException(this.getRuby(), "illegal access mode");
        }
        switch (mode.charAt(0)) {
            case 'r': {
                this.readable = true;
                break;
            }
            case 'a': {
                this.append = true;
            }
            case 'w': {
                this.writeable = true;
                break;
            }
            default: {
                throw new RubyArgumentException(this.getRuby(), "illegal access mode " + mode);
            }
        }
        if (mode.length() > 1) {
            int i;
            int n = i = mode.charAt(1) == 'b' ? 2 : 1;
            if (mode.length() > i) {
                if (mode.charAt(i) == '+') {
                    this.readable = true;
                    this.writeable = true;
                } else {
                    throw new RubyArgumentException(this.getRuby(), "illegal access mode " + mode);
                }
            }
        }
    }

    protected void fdOpen(int fd) {
        switch (fd) {
            case 0: {
                this.inStream = new RubyInputStream(this.getRuby().getRuntime().getInputStream());
                break;
            }
            case 1: {
                this.outStream = this.getRuby().getRuntime().getOutputStream();
                break;
            }
            case 2: {
                this.outStream = this.getRuby().getRuntime().getErrorStream();
                break;
            }
            default: {
                throw new IOError(this.getRuby(), "Bad file descriptor");
            }
        }
    }

    public RubyString internalGets(RubyObject[] args) {
        String separator;
        this.checkReadable();
        RubyObject sepVal = this.getRuby().getGlobalEntry("$/").get();
        if (args.length > 0) {
            sepVal = args[0];
        }
        String string = separator = sepVal.isNil() ? null : ((RubyString)sepVal).getValue();
        if (separator != null && separator.length() == 0) {
            separator = "\n\n";
        }
        try {
            String newLine = this.inStream.gets(separator);
            if (newLine != null) {
                ++this.lineNumber;
                RubyString result = RubyString.newString(this.getRuby(), newLine);
                result.taint();
                return result;
            }
        }
        catch (IOException ioExcptn) {
            // empty catch block
        }
        return RubyString.nilString(this.getRuby());
    }

    public void initIO(RubyInputStream inStream, OutputStream outStream, String path) {
        this.readable = inStream != null;
        this.writeable = outStream != null;
        this.inStream = inStream;
        this.outStream = outStream;
        this.path = path;
    }

    public static RubyObject newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyIO newObject = new RubyIO(ruby, (RubyClass)recv);
        newObject.callInit(args);
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyObject foreach(Ruby ruby, RubyObject recv, RubyString filename, RubyObject[] args) {
        filename.checkSafeString();
        RubyIO io = (RubyIO)RubyGlobal.open(ruby, recv, new RubyObject[]{filename});
        if (!io.isNil()) {
            try {
                io.funcall("each", args);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                io.funcall("close");
                throw throwable;
            }
            io.funcall("close");
            {
            }
        }
        return ruby.getNil();
    }

    public RubyObject initialize(RubyObject[] args) {
        this.closeStreams();
        String mode = "r";
        if (args.length > 1) {
            mode = ((RubyString)args[1]).getValue();
        }
        this.setMode(mode);
        this.fdOpen(RubyFixnum.fix2int(args[0]));
        return this;
    }

    public RubyObject write(RubyObject obj) {
        this.getRuby().secure(4);
        RubyString str = obj.to_s();
        if (str.getValue().length() == 0) {
            return RubyFixnum.zero(this.getRuby());
        }
        this.checkWriteable();
        try {
            this.outStream.write(str.getValue().getBytes());
            if (this.sync) {
                this.outStream.flush();
            }
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.getRuby(), ioExcptn.getMessage());
        }
        return str.length();
    }

    public RubyObject addString(RubyObject anObject) {
        this.callWrite(anObject);
        return this;
    }

    public RubyFixnum lineno() {
        return RubyFixnum.newFixnum(this.getRuby(), this.lineNumber);
    }

    public RubyObject lineno_set(RubyFixnum newLineNumber) {
        this.lineNumber = RubyFixnum.fix2int(newLineNumber);
        return this;
    }

    public RubyBoolean sync() {
        return RubyBoolean.newBoolean(this.getRuby(), this.sync);
    }

    public RubyObject sync_set(RubyBoolean newSync) {
        this.sync = newSync.isTrue();
        return this;
    }

    public RubyBoolean eof() {
        this.checkReadable();
        try {
            int c = this.inStream.read();
            if (c == -1) {
                return this.ruby.getTrue();
            }
            this.inStream.unread(c);
            return this.ruby.getFalse();
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.ruby, ioExcptn.getMessage());
        }
    }

    public RubyObject close() {
        this.closeStreams();
        return this;
    }

    public RubyIO flush() {
        this.checkWriteable();
        try {
            this.outStream.flush();
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.ruby, ioExcptn.getMessage());
        }
        return this;
    }

    public RubyString gets(RubyObject[] args) {
        RubyString result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuby().getParserHelper().setLastline(result);
        }
        return result;
    }

    public RubyString readline(RubyObject[] args) {
        RubyString line = this.gets(args);
        if (line.isNil()) {
            throw new EOFError(this.ruby);
        }
        return line;
    }

    public RubyObject getc() {
        this.checkReadable();
        try {
            int c = this.inStream.read();
            return c != -1 ? RubyFixnum.newFixnum(this.ruby, c & 0xFF) : this.ruby.getNil();
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.ruby, ioExcptn.getMessage());
        }
    }

    public RubyObject readchar() {
        RubyObject obj = this.getc();
        if (obj.isNil()) {
            throw new EOFError(this.ruby);
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    public RubyObject each_byte() {
        this.checkReadable();
        try {
            int c;
            while ((c = this.inStream.read()) != -1) {
                void var1_1;
                this.ruby.yield(RubyFixnum.newFixnum(this.ruby, var1_1 & 0xFF));
            }
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.ruby, ioExcptn.getMessage());
        }
        return this.ruby.getNil();
    }

    public RubyIO each_line(RubyObject[] args) {
        RubyString nextLine = this.internalGets(args);
        while (!nextLine.isNil()) {
            this.getRuby().yield(nextLine);
            nextLine = this.internalGets(args);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public static RubyObject puts(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length == 0) {
            recv.funcall("write", RubyString.newString(ruby, "\n"));
            return ruby.getNil();
        }
        i = 0;
        while (i < args.length) {
            block5: {
                line = null;
                if (!args[i].isNil()) break block5;
                line = "nil";
                ** GOTO lbl17
            }
            if (args[i] instanceof RubyArray) {
                RubyIO.puts(ruby, recv, ((RubyArray)args[i]).toJavaArray());
            } else {
                line = args[i].toString();
lbl17:
                // 2 sources

                recv.funcall("write", RubyString.newString(ruby, line));
                if (!line.endsWith("\n")) {
                    recv.funcall("write", RubyString.newString(ruby, "\n"));
                }
            }
            ++i;
        }
        return ruby.getNil();
    }

    public static RubyObject print(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length == 0) {
            args = new RubyObject[]{ruby.getParserHelper().getLastline()};
        }
        RubyObject fs = ruby.getGlobalVar("$,");
        RubyObject rs = ruby.getGlobalVar("$\\");
        int i = 0;
        while (i < args.length) {
            if (i > 0 && !fs.isNil()) {
                recv.funcall("write", fs);
            }
            if (args[i].isNil()) {
                recv.funcall("write", RubyString.newString(ruby, "nil"));
            } else {
                recv.funcall("write", args[i]);
            }
            ++i;
        }
        if (!rs.isNil()) {
            recv.funcall("write", rs);
        }
        return ruby.getNil();
    }

    public static RubyObject printf(Ruby ruby, RubyObject recv, RubyObject[] args) {
        recv.funcall("write", RubyGlobal.sprintf(ruby, recv, args));
        return ruby.getNil();
    }

    public void setAsRubyOutputStream() {
        this.ruby.getRuntime().setOutputStream(new PrintStream(this.outStream));
    }

    public void setAsRubyErrorStream() {
        this.ruby.getRuntime().setErrorStream(new PrintStream(this.outStream));
    }

    public void setAsRubyInputStream() {
        this.ruby.getRuntime().setInputStream(this.inStream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

