/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyJavaObject;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;

public class RubyJavaInterface
extends RubyJavaObject {
    public RubyJavaInterface(Ruby ruby, Object proxyObject) {
        super(ruby, ruby.getClasses().getJavaInterfaceClass());
        this.setValue(proxyObject);
    }

    public static RubyClass createJavaInterfaceClass(Ruby ruby) {
        RubyClass javaInterfaceClass = ruby.defineClass("JavaInterface", ruby.getClasses().getJavaObjectClass());
        return javaInterfaceClass;
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Method interfaceMethod, final RubyProc proc) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{interfaceMethod.getDeclaringClass()}, new InvocationHandler(){

            public Object invoke(Object recv, Method imethod, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, proc.call(JavaUtil.convertJavaToRuby(ruby, args)));
            }
        }));
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Method interfaceMethod, final RubyMethod method) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{interfaceMethod.getDeclaringClass()}, new InvocationHandler(){

            public Object invoke(Object recv, Method imethod, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, method.call(JavaUtil.convertJavaToRuby(ruby, args)));
            }
        }));
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Method interfaceMethod, final RubyObject receiver, final RubyString method) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{interfaceMethod.getDeclaringClass()}, new InvocationHandler(){

            public Object invoke(Object recv, Method imethod, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, receiver.send(method, JavaUtil.convertJavaToRuby(ruby, args)), imethod.getReturnType());
            }
        }));
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Class javaInterface, final RubyObject receiver) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{javaInterface}, new InvocationHandler(){

            public Object invoke(Object recv, Method method, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, receiver.send(RubyString.newString(ruby, method.getName()), JavaUtil.convertJavaToRuby(ruby, args)), method.getReturnType());
            }
        }));
    }
}

