/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.ReflectionCallbackMethod;

public class RubyTime
extends RubyObject {
    private Calendar cal;
    static /* synthetic */ Class class$org$jruby$RubyTime;

    public RubyTime(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createTimeClass(Ruby ruby) {
        RubyClass timeClass = ruby.defineClass("Time", ruby.getClasses().getObjectClass());
        ReflectionCallbackMethod s_new = new ReflectionCallbackMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "s_new", false, true);
        timeClass.defineSingletonMethod("new", s_new);
        timeClass.defineSingletonMethod("now", s_new);
        return timeClass;
    }

    public static RubyTime s_new(Ruby ruby, RubyObject rubyClass) {
        RubyObject[] args = new RubyObject[]{new RubyFixnum(ruby, new Date().getTime())};
        return RubyTime.s_at(ruby, rubyClass, args);
    }

    public static RubyTime s_at(Ruby ruby, RubyObject rubyClass, RubyObject[] args) {
        long secs = RubyNumeric.num2long(args[0]);
        RubyTime time = new RubyTime(ruby, rubyClass.getRubyClass());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(secs));
        time.setJavaCalendar(cal);
        return time;
    }

    public RubyTime gmtime(Ruby ruby) {
        this.cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this;
    }

    public RubyString zone(Ruby ruby) {
        return RubyString.newString(ruby, this.cal.getTimeZone().getID());
    }

    public void setJavaCalendar(Calendar cal) {
        this.cal = cal;
    }

    public Date getJavaDate() {
        return this.cal.getTime();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

