/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.bsf;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import java.util.Vector;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.RubyGlobalEntry;

public class JRubyEngine
extends BSFEngineImpl {
    private Ruby ruby;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jruby$regexp$GNURegexpAdapter;

    public Object apply(String file, int line, int col, Object funcBody, Vector paramNames, Vector args) {
        String oldFile = this.ruby.getSourceFile();
        int oldLine = this.ruby.getSourceLine();
        this.ruby.setSourceFile(file);
        this.ruby.setSourceLine(line);
        StringBuffer sb = new StringBuffer(((String)funcBody).length() + 100);
        sb.append("def __jruby_bsf_anonymous (");
        int paramLength = paramNames.size();
        int i = 0;
        while (i < paramLength) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paramNames.elementAt(i));
            ++i;
        }
        sb.append(") \n");
        sb.append(funcBody);
        sb.append("\nend\n");
        this.ruby.evalScript(sb.toString(), null);
        RubyObject[] rubyArgs = new RubyObject[args.size()];
        int i2 = args.size();
        while (i2 >= 0) {
            rubyArgs[i2] = JavaUtil.convertJavaToRuby(this.ruby, args.elementAt(i2), args.elementAt(i2).getClass());
            --i2;
        }
        Object result = JavaUtil.convertRubyToJava(this.ruby, this.ruby.getRubyTopSelf().funcall("__jruby_bsf_anonymous", rubyArgs));
        this.ruby.setSourceFile(oldFile);
        this.ruby.setSourceLine(oldLine);
        return result;
    }

    public Object eval(String file, int line, int col, Object expr) throws BSFException {
        String oldFile = this.ruby.getSourceFile();
        int oldLine = this.ruby.getSourceLine();
        this.ruby.setSourceFile(file);
        this.ruby.setSourceLine(line);
        try {
            Object result = this.ruby.evalScript((String)expr, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
            this.ruby.setSourceFile(oldFile);
            this.ruby.setSourceLine(oldLine);
            return result;
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file, int line, int col, Object expr) throws BSFException {
        try {
            String oldFile = this.ruby.getSourceFile();
            int oldLine = this.ruby.getSourceLine();
            this.ruby.setSourceFile(file);
            this.ruby.setSourceLine(line);
            this.ruby.evalScript((String)expr, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
            this.ruby.setSourceFile(oldFile);
            this.ruby.setSourceLine(oldLine);
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv, String method, Object[] args) throws BSFException {
        try {
            RubyObject rubyRecv = JavaUtil.convertJavaToRuby(this.ruby, recv, recv.getClass());
            RubyObject[] rubyArgs = new RubyObject[args.length];
            int i = args.length;
            while (i >= 0) {
                rubyArgs[i] = JavaUtil.convertJavaToRuby(this.ruby, args[i], args[i].getClass());
                --i;
            }
            RubyObject result = rubyRecv.funcall(method, rubyArgs);
            return JavaUtil.convertRubyToJava(this.ruby, result, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.ruby = Ruby.getDefaultInstance(class$org$jruby$regexp$GNURegexpAdapter == null ? (class$org$jruby$regexp$GNURegexpAdapter = JRubyEngine.class$("org.jruby.regexp.GNURegexpAdapter")) : class$org$jruby$regexp$GNURegexpAdapter);
        int size = declaredBeans.size();
        int i = 0;
        while (i < size) {
            BSFDeclaredBean bean = (BSFDeclaredBean)declaredBeans.elementAt(i);
            BeanAccessor accessor = new BeanAccessor(this.ruby, bean);
            this.ruby.defineVirtualVariable(bean.name, accessor, accessor);
            ++i;
        }
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        BeanAccessor accessor = new BeanAccessor(this.ruby, bean);
        this.ruby.defineVirtualVariable(bean.name, accessor, accessor);
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.ruby.getGlobalEntry(bean.name).undefine();
    }

    public void handleException(BSFException bsfExcptn) {
        this.ruby.printException((Exception)bsfExcptn.getTargetException());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BeanAccessor
    implements RubyGlobalEntry.GetterMethod,
    RubyGlobalEntry.SetterMethod {
        private Ruby ruby;
        private BSFDeclaredBean bean;

        protected BeanAccessor(Ruby ruby, BSFDeclaredBean bean) {
            this.ruby = ruby;
            this.bean = bean;
        }

        public RubyObject get(String id, RubyObject value, RubyGlobalEntry entry) {
            return JavaUtil.convertJavaToRuby(this.ruby, this.bean.bean, this.bean.type);
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            this.bean.bean = JavaUtil.convertRubyToJava(this.ruby, value, this.bean.type);
        }
    }
}

