/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;

public class DefsNode
extends Node {
    public DefsNode(Node recvNode, String mId, Node defnNode) {
        super(76, (Object)recvNode, (Object)mId, (Object)defnNode);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        if (this.getDefnNode() != null) {
            RubyObject recv = this.getRecvNode().eval(ruby, self);
            if (ruby.getSafeLevel() >= 4 && !recv.isTaint()) {
                throw new RubySecurityException(ruby, "Insecure; can't define singleton method");
            }
            if (recv.isFrozen()) {
                throw new RubyFrozenException(ruby, "object");
            }
            RubyClass rubyClass = recv.getSingletonClass();
            Node body = (Node)rubyClass.getMethods().get(this.getMId());
            if (body != null && ruby.getSafeLevel() >= 4) {
                throw new RubySecurityException(ruby, "redefining method prohibited");
            }
            Node defn = this.getDefnNode().copyNodeScope(ruby.getCRef());
            defn.setRefValue(ruby.getCRef());
            ruby.getMethodCache().clearByName(this.getMId());
            rubyClass.addMethod(this.getMId(), defn, 0 | (body != null ? body.getNoex() & 1 : 0));
            recv.funcall("singleton_method_added", RubySymbol.newSymbol(ruby, this.getMId()));
        }
        return ruby.getNil();
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitDefsNode(this);
    }
}

