/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;

public class RubyScope {
    public static final int SCOPE_ALLOCA = 0;
    public static final int SCOPE_MALLOC = 1;
    public static final int SCOPE_NOSTACK = 2;
    public static final int SCOPE_DONT_RECYCLE = 4;
    private RubyObject superObject = null;
    private int flags = 0;
    private List localNames = null;
    private List localValues = null;
    private int oldActMethodScope = 2;
    private Ruby ruby = null;
    private RubyScope old = null;

    public RubyScope(Ruby ruby) {
        this.ruby = ruby;
    }

    public RubyScope(RubyScope scope, Ruby ruby) {
        this.superObject = scope.superObject;
        this.localNames = scope.localNames;
        this.localValues = scope.localValues;
        this.flags = scope.flags;
        this.old = scope.old;
        this.ruby = ruby;
    }

    public void push() {
        this.oldActMethodScope = this.ruby.getActMethodScope();
        this.ruby.setActMethodScope(0);
        this.old = new RubyScope(this, this.ruby);
        this.localNames = null;
        this.localValues = null;
        this.flags = 0;
    }

    public void pop() {
        this.ruby.setActMethodScope(this.oldActMethodScope);
        this.superObject = this.old.superObject;
        this.localNames = this.old.localNames;
        this.localValues = this.old.localValues;
        this.flags = this.old.flags;
        this.old = this.old.old;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public RubyObject getSuperObject() {
        return this.superObject;
    }

    public void setSuperObject(RubyObject superObject) {
        this.superObject = superObject;
    }

    public List getLocalNames() {
        return this.localNames;
    }

    public void setLocalNames(List localName) {
        this.localNames = localName;
    }

    public List getLocalValues() {
        return this.localValues;
    }

    public void setLocalValues(List localValue) {
        this.localValues = localValue;
    }

    public RubyObject getValue(int count) {
        return (RubyObject)this.localValues.get(count);
    }

    public void setValue(int count, RubyObject value) {
        this.localValues.set(count, value);
    }

    static {
        SCOPE_ALLOCA = 0;
        SCOPE_MALLOC = 1;
        SCOPE_NOSTACK = 2;
        SCOPE_DONT_RECYCLE = 4;
    }
}

