/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.jruby.scanner.IRubyScanner;
import org.jruby.scanner.IScannerListener;
import org.jruby.scanner.IToken;
import org.jruby.scanner.Token;
import org.jruby.scanner.TokenTypes;

public class RubyScanner
implements TokenTypes,
IRubyScanner {
    public static final int YYEOF = -1;
    private static final int YY_BUFFERSIZE = 16384;
    public static final int EXPR_CMDARG = 3;
    public static final int EXPR_MID = 3;
    public static final int HEREDOC = 2;
    public static final int EXPR_ARG = 4;
    public static final int STRING = 2;
    public static final int EXPR_FNAME = 3;
    public static final int EXPR_CLASS = 2;
    public static final int EXPR_DOT = 3;
    public static final int EXPR_ENDARG = 3;
    public static final int MLCOMMENT = 1;
    public static final int YYINITIAL = 0;
    public static final int EXPR_END = 3;
    private static final String yycmap_packed = "\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u000e\u0001\u0000\u0001\u0004\u0006\u0000\u0001\u000f\u0011\u0000\u0001\u0010\u0001\u0005\u0001\r#\u0000\u0001\u0006\u0001\u0000\u0001\u000b\u0001\u0007\u0001\u0000\u0001\b\u0001\u0000\u0001\t\u0004\u0000\u0001\n\u000f\u0000\u0001\f\uff81\u0000";
    private static final char[] yycmap;
    private static final int[] yy_rowMap;
    private static final String yy_packed0 = "\u0001\u0000\u0001\u0006\u0002\u0007\u0001\b\u0001\t\u0007\u0000\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0002\u000f\u0002\u000e\u0001\u0010\u000b\u000e\u0016\u0000\u0001\u0011\u0007\u0000\u0001\n\u0001\u000b\u0001\f\u0001\r\u0005\u0000\u0001\u0011\u0007\u0000\u0001\n\u0001\u000b\u0001\u0012\u0001\r\u0002\u0000\u0001\u0007\u000e\u0000\u0001\b\u0001\u0013\u0001\u0014\u000e\b\u0005\u0000\u0001\u0015\u0001\u0016\u0005\u0000\u0001\u0017\u0001\u0018\b\u0000\u0001\u0019\u0007\u0000\u0001\u001a\b\u0000\u0001\u001b\u0006\u0000\u0001\u001c\t\u0000\u0001\u001d\t\u0000\u0001\u001e\u0006\u0000\u0001\u001f\n\u0000\u0001 \u0001\u000e\u0001!\u0001\"\u0015\u000e\u0001#\t\u000e\u0005\u0000\u0001\u0015\u0006\u0000\u0001\u0017\u0001\u0018\u0005\u0000\u0001\u0014\u0013\u0000\u0001$\u0012\u0000\u0001%\u000e\u0000\u0001&\u0010\u0000\u0001'\u0018\u0000\u0001(\b\u0000\u0001)\r\u0000\u0001\"\u000e\u0000\n\u000e\u0001*\u0006\u000e\b\u0000\u0001+\b\u0000\u000b\u000e\u0001,\u0005\u000e\t\u0000\u0001-\u0007\u0000\u0001\u000e\u0001.\u0002/\r\u000e\n\u0000\u00010\b\u0000\u0001/\u000f\u0000\u00011\u00012\u00013\r\u0000\u00013\u00014\u00012\u000f3\u00014\u00015\u000e3\u0002\u0000\u00015\u000e\u0000";
    private static final int[] yytrans;
    private static final int YY_UNKNOWN_ERROR = 0;
    private static final int YY_ILLEGAL_STATE = 1;
    private static final int YY_NO_MATCH = 2;
    private static final int YY_PUSHBACK_2BIG = 3;
    private static final String[] YY_ERROR_MSG;
    private static final byte[] YY_ATTRIBUTE;
    private Reader yy_reader;
    private int yy_state;
    private int yy_lexical_state = 0;
    private char[] yy_buffer = new char[16384];
    private int yy_markedPos;
    private int yy_pushbackPos;
    private int yy_currentPos;
    private int yy_startRead;
    private int yy_endRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean yy_atBOL = true;
    private boolean yy_atEOF;
    private transient StringBuffer mlCommentText = null;
    private transient ArrayList scannerListener = new ArrayList();

    private IToken createToken(int type) {
        return new Token(type, this.yyline + 1, this.yycolumn + 1, null);
    }

    private IToken createToken(int type, Object data) {
        return new Token(type, this.yyline + 1, this.yycolumn + 1, data);
    }

    private void warn(String message) {
        Iterator iter = this.scannerListener.iterator();
        while (iter.hasNext()) {
            ((IScannerListener)iter.next()).scannerWarning(this.yyline + 1, this.yycolumn + 1, message);
        }
    }

    private void error(String message) {
        Iterator iter = this.scannerListener.iterator();
        while (iter.hasNext()) {
            ((IScannerListener)iter.next()).scannerError(this.yyline + 1, this.yycolumn + 1, message);
        }
    }

    public void addScannerListener(IScannerListener listener) {
        this.scannerListener.add(listener);
    }

    public void removeScannerListener(IScannerListener listener) {
        this.scannerListener.remove(listener);
    }

    public static void main(String[] args) throws IOException {
        RubyScanner scanner = new RubyScanner(System.in);
        IToken next = scanner.getNextToken();
        while (next != null) {
            System.out.println(next);
            next = scanner.getNextToken();
        }
    }

    public RubyScanner(Reader in) {
        this.yy_reader = in;
    }

    public RubyScanner(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static int[] yy_unpack() {
        int[] trans = new int[578];
        int offset = 0;
        offset = RubyScanner.yy_unpack(yy_packed0, offset, trans);
        return trans;
    }

    private static int yy_unpack(String packed, int offset, int[] trans) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                trans[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static char[] yy_unpack_cmap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 62) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean yy_refill() throws IOException {
        int numRead;
        if (this.yy_startRead > 0) {
            System.arraycopy(this.yy_buffer, this.yy_startRead, this.yy_buffer, 0, this.yy_endRead - this.yy_startRead);
            this.yy_endRead -= this.yy_startRead;
            this.yy_currentPos -= this.yy_startRead;
            this.yy_markedPos -= this.yy_startRead;
            this.yy_pushbackPos -= this.yy_startRead;
            this.yy_startRead = 0;
        }
        if (this.yy_currentPos >= this.yy_buffer.length) {
            char[] newBuffer = new char[this.yy_currentPos * 2];
            System.arraycopy(this.yy_buffer, 0, newBuffer, 0, this.yy_buffer.length);
            this.yy_buffer = newBuffer;
        }
        if ((numRead = this.yy_reader.read(this.yy_buffer, this.yy_endRead, this.yy_buffer.length - this.yy_endRead)) < 0) {
            return true;
        }
        this.yy_endRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.yy_atEOF = true;
        this.yy_endRead = this.yy_startRead;
        if (this.yy_reader != null) {
            this.yy_reader.close();
        }
    }

    public final void yyreset(Reader reader) throws IOException {
        this.yyclose();
        this.yy_reader = reader;
        this.yy_atBOL = true;
        this.yy_atEOF = false;
        this.yy_startRead = 0;
        this.yy_endRead = 0;
        this.yy_pushbackPos = 0;
        this.yy_markedPos = 0;
        this.yy_currentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.yy_lexical_state = 0;
    }

    public final int yystate() {
        return this.yy_lexical_state;
    }

    public final void yybegin(int newState) {
        this.yy_lexical_state = newState;
    }

    public final String yytext() {
        return new String(this.yy_buffer, this.yy_startRead, this.yy_markedPos - this.yy_startRead);
    }

    public final char yycharat(int pos) {
        return this.yy_buffer[this.yy_startRead + pos];
    }

    public final int yylength() {
        return this.yy_markedPos - this.yy_startRead;
    }

    private void yy_ScanError(int errorCode) {
        String message;
        try {
            message = YY_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = YY_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    private void yypushback(int number) {
        if (number > this.yylength()) {
            this.yy_ScanError(3);
        }
        this.yy_markedPos -= number;
    }

    public IToken getNextToken() throws IOException {
        int yy_endRead_l = this.yy_endRead;
        char[] yy_buffer_l = this.yy_buffer;
        char[] yycmap_l = yycmap;
        int[] yytrans_l = yytrans;
        int[] yy_rowMap_l = yy_rowMap;
        byte[] yy_attr_l = YY_ATTRIBUTE;
        block60: while (true) {
            int yy_input;
            int yy_markedPos_l = this.yy_markedPos;
            boolean yy_r = false;
            int yy_currentPos_l = this.yy_startRead;
            while (yy_currentPos_l < yy_markedPos_l) {
                switch (yy_buffer_l[yy_currentPos_l]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        yy_r = false;
                        break;
                    }
                    case '\r': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        yy_r = true;
                        break;
                    }
                    case '\n': {
                        if (yy_r) {
                            yy_r = false;
                            break;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        break;
                    }
                    default: {
                        yy_r = false;
                        ++this.yycolumn;
                    }
                }
                ++yy_currentPos_l;
            }
            if (yy_r) {
                boolean yy_peek;
                if (yy_markedPos_l < yy_endRead_l) {
                    yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
                } else if (this.yy_atEOF) {
                    yy_peek = false;
                } else {
                    boolean eof = this.yy_refill();
                    yy_markedPos_l = this.yy_markedPos;
                    yy_buffer_l = this.yy_buffer;
                    if (eof) {
                        yy_peek = false;
                    } else {
                        boolean bl = yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
                    }
                }
                if (yy_peek) {
                    --this.yyline;
                }
            }
            int yy_action = -1;
            this.yy_currentPos = this.yy_startRead = yy_markedPos_l;
            yy_currentPos_l = this.yy_startRead;
            int yy_startRead_l = this.yy_startRead;
            this.yy_state = this.yy_lexical_state;
            while (true) {
                if (yy_currentPos_l < yy_endRead_l) {
                    yy_input = yy_buffer_l[yy_currentPos_l++];
                } else {
                    if (this.yy_atEOF) {
                        yy_input = -1;
                        break;
                    }
                    this.yy_currentPos = yy_currentPos_l;
                    this.yy_markedPos = yy_markedPos_l;
                    boolean eof = this.yy_refill();
                    yy_currentPos_l = this.yy_currentPos;
                    yy_markedPos_l = this.yy_markedPos;
                    yy_buffer_l = this.yy_buffer;
                    yy_endRead_l = this.yy_endRead;
                    if (eof) {
                        yy_input = -1;
                        break;
                    }
                    yy_input = yy_buffer_l[yy_currentPos_l++];
                }
                int yy_next = yytrans_l[yy_rowMap_l[this.yy_state] + yycmap_l[yy_input]];
                if (yy_next == -1) break;
                this.yy_state = yy_next;
                byte yy_attributes = yy_attr_l[this.yy_state];
                if ((yy_attributes & 1) != 1) continue;
                yy_action = this.yy_state;
                yy_markedPos_l = yy_currentPos_l;
                if ((yy_attributes & 8) == 8) break;
            }
            this.yy_markedPos = yy_markedPos_l;
            switch (yy_action) {
                case 28: {
                    this.yybegin(0);
                    return this.createToken(4096, "*");
                }
                case 54: {
                    continue block60;
                }
                case 45: 
                case 46: {
                    this.yybegin(0);
                    this.mlCommentText.append(this.yytext());
                    return this.createToken(11, this.mlCommentText.toString());
                }
                case 55: {
                    continue block60;
                }
                case 18: 
                case 19: {
                    return this.createToken(10, this.yytext());
                }
                case 56: {
                    continue block60;
                }
                case 48: 
                case 49: 
                case 51: 
                case 52: {
                    this.yybegin(1);
                    this.mlCommentText = new StringBuffer(this.yytext());
                }
                case 57: {
                    continue block60;
                }
                case 39: {
                    this.yybegin(0);
                    return this.createToken(4098);
                }
                case 58: {
                    continue block60;
                }
                case 35: {
                    this.yybegin(0);
                    return this.createToken(4100);
                }
                case 59: {
                    continue block60;
                }
                case 30: {
                    this.yybegin(0);
                    return this.createToken(4103);
                }
                case 60: {
                    continue block60;
                }
                case 29: {
                    this.yybegin(0);
                    return this.createToken(4111);
                }
                case 61: {
                    continue block60;
                }
                case 11: {
                    this.yybegin(0);
                    return this.createToken(4113);
                }
                case 62: {
                    continue block60;
                }
                case 10: {
                    this.yybegin(0);
                    return this.createToken(4110);
                }
                case 63: {
                    continue block60;
                }
                case 20: {
                    this.yybegin(0);
                    return this.createToken(4099);
                }
                case 64: {
                    continue block60;
                }
                case 24: {
                    this.yybegin(0);
                    return this.createToken(4101);
                }
                case 65: {
                    continue block60;
                }
                case 26: {
                    this.yybegin(0);
                    return this.createToken(4108);
                }
                case 66: {
                    continue block60;
                }
                case 40: {
                    this.yybegin(0);
                    return this.createToken(4096, "<<");
                }
                case 67: {
                    continue block60;
                }
                case 38: {
                    this.yybegin(0);
                    return this.createToken(4096, "**");
                }
                case 68: {
                    continue block60;
                }
                case 37: {
                    this.yybegin(0);
                    return this.createToken(4096, ">>");
                }
                case 69: {
                    continue block60;
                }
                case 31: {
                    this.yybegin(0);
                    return this.createToken(4105);
                }
                case 70: {
                    continue block60;
                }
                case 17: {
                    this.yybegin(0);
                    this.warn("'*' interpreted as argument prefix");
                    return this.createToken(4113);
                }
                case 71: {
                    continue block60;
                }
                case 22: {
                    this.yybegin(0);
                    return this.createToken(4106);
                }
                case 72: {
                    continue block60;
                }
                case 23: {
                    this.yybegin(0);
                    return this.createToken(4097);
                }
                case 73: {
                    continue block60;
                }
                case 25: {
                    this.yybegin(0);
                    return this.createToken(4112);
                }
                case 74: {
                    continue block60;
                }
                case 14: 
                case 32: 
                case 33: {
                    this.mlCommentText.append(this.yytext());
                }
                case 75: {
                    continue block60;
                }
                case 12: {
                    this.yybegin(0);
                    return this.createToken(4104);
                }
                case 76: {
                    continue block60;
                }
                case 9: {
                    this.yybegin(0);
                    return this.createToken(4102);
                }
                case 77: {
                    continue block60;
                }
                case 8: 
                case 16: {
                    this.yybegin(0);
                    return this.createToken(4096);
                }
                case 78: {
                    continue block60;
                }
                case 27: {
                    this.yybegin(0);
                    return this.createToken(4109);
                }
                case 79: {
                    continue block60;
                }
                case 5: 
                case 6: 
                case 80: {
                    continue block60;
                }
            }
            if (yy_input == -1 && this.yy_startRead == this.yy_currentPos) {
                this.yy_atEOF = true;
                return null;
            }
            this.yy_ScanError(2);
        }
    }

    static {
        YYEOF = -1;
        YY_BUFFERSIZE = 16384;
        EXPR_CMDARG = 3;
        EXPR_MID = 3;
        HEREDOC = 2;
        EXPR_ARG = 4;
        STRING = 2;
        EXPR_FNAME = 3;
        EXPR_CLASS = 2;
        EXPR_DOT = 3;
        EXPR_ENDARG = 3;
        MLCOMMENT = 1;
        YYINITIAL = 0;
        EXPR_END = 3;
        yycmap_packed = yycmap_packed;
        yycmap = RubyScanner.yy_unpack_cmap(yycmap_packed);
        yy_rowMap = new int[]{0, 17, 34, 51, 68, 85, 34, 102, 119, 136, 153, 170, 187, 204, 204, 221, 238, 170, 255, 34, 272, 289, 34, 34, 34, 306, 34, 34, 34, 323, 340, 357, 374, 34, 391, 34, 408, 34, 34, 34, 34, 425, 442, 459, 476, 493, 34, 510, 527, 544, 544, 561, 34};
        yy_packed0 = yy_packed0;
        yytrans = RubyScanner.yy_unpack();
        YY_UNKNOWN_ERROR = 0;
        YY_ILLEGAL_STATE = 1;
        YY_NO_MATCH = 2;
        YY_PUSHBACK_2BIG = 3;
        YY_ERROR_MSG = new String[]{"Unkown internal scanner error", "Internal error: unknown state", "Error: could not match input", "Error: pushback value was too large"};
        YY_ATTRIBUTE = new byte[]{0, 0, 8, 0, 0, 1, 9, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 9, 1, 0, 9, 9, 9, 1, 9, 9, 9, 1, 1, 1, 1, 9, 0, 9, 0, 9, 9, 9, 9, 0, 0, 0, 0, 1, 9, 0, 1, 1, 0, 1, 9};
    }
}

