/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyTime;

public class TestRubyTime
extends TestCase {
    private Ruby ruby;
    private RubyClass rubyTime;
    private RubyTime nineTeenSeventy;

    public TestRubyTime(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = new Ruby();
        this.ruby.init();
        this.rubyTime = this.ruby.getClasses().getTimeClass();
        RubyObject[] args = new RubyObject[]{new RubyFixnum(this.ruby, 18000000L)};
        this.nineTeenSeventy = RubyTime.s_at(this.ruby, RubyTime.s_new(this.ruby, this.rubyTime), args);
    }

    public void testTimeCreated() {
        Assert.assertTrue((this.rubyTime != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.rubyTime.getClassname().getValue(), (Object)"Time");
    }

    public void testTimeNow() {
        RubyTime myTime = RubyTime.s_new(this.ruby, this.rubyTime);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Unexpected InterruptedException");
        }
        Date now = new Date();
        Assert.assertTrue((boolean)now.after(myTime.getJavaDate()));
    }

    public void testTimeAt() {
        Date myDate = new Date(18000000L);
        Assert.assertEquals((Object)myDate, (Object)this.nineTeenSeventy.getJavaDate());
    }

    public void testGmtimeAndZone() {
        Date myDate = new Date(18000000L);
        Assert.assertEquals((Object)"GMT", (Object)this.nineTeenSeventy.gmtime(this.ruby).zone(this.ruby).getValue());
    }
}

