/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;

public class RubyDir
extends RubyObject {
    protected String path;
    protected File dir;
    private String[] snapshot;
    private int pos;
    static /* synthetic */ Class class$org$jruby$RubyDir;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$RubyInteger;

    public RubyDir(Ruby ruby, RubyClass type) {
        super(ruby, type);
    }

    public static RubyClass createDirClass(Ruby ruby) {
        RubyClass dirClass = ruby.defineClass("Dir", ruby.getClasses().getObjectClass());
        dirClass.includeModule(ruby.getRubyModule("Enumerable"));
        dirClass.defineSingletonMethod("glob", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "glob", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("[]", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "glob", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("chdir", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "chdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("chroot", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "chroot", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("delete", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "delete", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("entries", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "entries", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("foreach", CallbackFactory.getBlockMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "foreach"));
        dirClass.defineSingletonMethod("getwd", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "getwd", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("pwd", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "getwd", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("mkdir", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "mkdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("open", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "open", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("rmdir", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rmdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("unlink", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rmdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineSingletonMethod("delete", CallbackFactory.getSingletonMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rmdir", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyDir.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        dirClass.defineMethod("close", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "close"));
        dirClass.defineMethod("each", CallbackFactory.getOptMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "each"));
        dirClass.defineMethod("tell", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "tell"));
        dirClass.defineAlias("pos", "tell");
        dirClass.defineMethod("seek", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "seek", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyDir.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        dirClass.defineAlias("pos=", "seek");
        dirClass.defineMethod("read", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "read"));
        dirClass.defineMethod("rewind", CallbackFactory.getMethod(class$org$jruby$RubyDir == null ? (class$org$jruby$RubyDir = RubyDir.class$("org.jruby.RubyDir")) : class$org$jruby$RubyDir, "rewind"));
        return dirClass;
    }

    public static RubyObject newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyDir result = new RubyDir(ruby, (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public RubyObject initialize(RubyObject[] args) {
        if (args.length != 1) {
            throw new ArgumentError(this.getRuby(), "wrong number of arguments(0 for 1)");
        }
        args[0].checkSafeString();
        this.path = args[0].toString();
        this.dir = new File(this.path);
        if (!this.dir.isDirectory()) {
            this.path = null;
            this.dir = null;
            throw new IOError(this.getRuby(), this.path + " is not a directory");
        }
        return this;
    }

    public static RubyArray glob(Ruby ruby, RubyObject recv, RubyString pat) {
        String pattern = pat.toString();
        if (pattern.indexOf("**") != -1 || pattern.indexOf("?") != -1) {
            throw new NotImplementedError();
        }
        final File patternFile = new File(pattern);
        Object[] files = patternFile.getParentFile().list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String patternName = patternFile.getName();
                return name.startsWith(patternName.substring(0, patternName.indexOf(42))) && name.endsWith(patternName.substring(patternName.indexOf(42) + 1));
            }
        });
        return RubyArray.newArray(ruby, JavaUtil.convertJavaArrayToRuby(ruby, files));
    }

    public static RubyObject chdir(Ruby ruby, RubyObject recv, RubyString path) {
        System.setProperty("user.dir", RubyDir.getDir(ruby, path.toString()).toString());
        return new RubyFixnum(ruby, 0L);
    }

    public static RubyObject chroot(Ruby ruby, RubyObject recv, RubyString path) {
        throw new NotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    public static RubyObject rmdir(Ruby ruby, RubyObject recv, RubyString path) {
        new File(path.toString()).delete();
        return new RubyFixnum(ruby, 0L);
    }

    public static RubyArray entries(Ruby ruby, RubyObject recv, RubyString path) {
        return new RubyArray(ruby, RubyDir.getContents(RubyDir.getDir(ruby, path.toString()), ruby));
    }

    public static RubyObject foreach(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length != 1) {
            throw new ArgumentError(ruby, "wrong number of arguments(0 for 1)");
        }
        args[0].checkSafeString();
        String path = args[0].toString();
        List contents = RubyDir.getContents(RubyDir.getDir(ruby, path));
        Iterator i = contents.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            ruby.yield(new RubyString(ruby, name));
        }
        return ruby.getNil();
    }

    public static RubyString getwd(Ruby ruby, RubyObject recv) {
        return new RubyString(ruby, System.getProperty("user.dir"));
    }

    public static RubyObject mkdir(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length < 1) {
            throw new ArgumentError(ruby, "wrong number of arguments(0 for 1)");
        }
        args[0].checkSafeString();
        String path = args[0].toString();
        File newDir = RubyDir.getDir(ruby, path);
        if (newDir.exists()) {
            throw new IOError(ruby, path + " already exists");
        }
        return new RubyBoolean(ruby, newDir.mkdir());
    }

    public static RubyObject open(Ruby ruby, RubyObject recv, RubyString path) {
        throw new NotImplementedError();
    }

    public RubyObject close() {
        return this;
    }

    public RubyObject each() {
        String[] contents = this.snapshot;
        int i = 0;
        while (i < contents.length) {
            this.getRuby().yield(new RubyString(this.getRuby(), contents[i]));
            ++i;
        }
        return this;
    }

    public RubyInteger tell() {
        return new RubyFixnum(this.getRuby(), this.pos);
    }

    public RubyObject seek(RubyFixnum pos) {
        this.pos = (int)pos.getLongValue();
        return pos;
    }

    public RubyString read() {
        return new RubyString(this.getRuby(), this.snapshot[this.pos++]);
    }

    public RubyObject rewind() {
        this.pos = 0;
        return new RubyFixnum(this.getRuby(), this.pos);
    }

    protected static File getDir(Ruby ruby, String path) {
        File result = new File(path);
        if (!result.isDirectory()) {
            throw new IOError(ruby, path + " is not a directory");
        }
        return result;
    }

    protected static List getContents(File directory) {
        ArrayList<String> result = new ArrayList<String>();
        String[] contents = directory.list();
        int i = 0;
        while (i < contents.length) {
            result.add(contents[i]);
            ++i;
        }
        return result;
    }

    protected static List getContents(File directory, Ruby ruby) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        int i = 0;
        while (i < contents.length) {
            result.add(new RubyString(ruby, contents[i]));
            ++i;
        }
        return result;
    }

    public boolean matches(String str, String pattern) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

