/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.marshal.MarshalStream;
import org.jruby.marshal.UnmarshalStream;
import org.jruby.runtime.CallbackFactory;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyMapMethod;

public class RubyHash
extends RubyObject {
    private RubyMap valueMap;
    private RubyObject defaultValue;
    static /* synthetic */ Class class$org$jruby$RubyHash;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyHash(Ruby ruby) {
        this(ruby, ruby.getNil());
    }

    public RubyHash(Ruby ruby, RubyObject defaultValue) {
        this(ruby, new RubyHashMap(), defaultValue);
    }

    public RubyHash(Ruby ruby, Map valueMap, RubyObject defaultValue) {
        super(ruby, ruby.getRubyClass("Hash"));
        this.valueMap = new RubyHashMap(valueMap);
        this.defaultValue = defaultValue;
    }

    public static RubyHash nilHash(Ruby ruby) {
        return new RubyHash(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public RubyObject getDefaultValue() {
        return this.defaultValue == null ? this.getRuby().getNil() : this.defaultValue;
    }

    public void setDefaultValue(RubyObject defaultValue) {
        this.defaultValue = defaultValue;
    }

    public RubyMap getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(RubyMap valueMap) {
        this.valueMap = valueMap;
    }

    private Iterator keyIterator() {
        return new ArrayList(this.valueMap.keySet()).iterator();
    }

    private Iterator modifiableKeyIterator() {
        return this.valueMap.keySet().iterator();
    }

    private Iterator valueIterator() {
        return new ArrayList(this.valueMap.values()).iterator();
    }

    private Iterator modifiableEntryIterator() {
        return this.valueMap.entrySet().iterator();
    }

    private Iterator entryIterator() {
        return new ArrayList(this.valueMap.entrySet()).iterator();
    }

    public static RubyClass createHashClass(Ruby ruby) {
        RubyClass hashClass = ruby.defineClass("Hash", ruby.getClasses().getObjectClass());
        hashClass.includeModule(ruby.getClasses().getEnumerableModule());
        hashClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "newInstance"));
        hashClass.defineSingletonMethod("[]", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "create"));
        hashClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "initialize"));
        hashClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "rbClone"));
        hashClass.defineMethod("to_hash", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "to_hash"));
        hashClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "to_a"));
        hashClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "to_s"));
        hashClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "inspect"));
        hashClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("[]", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "aref", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("[]=", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "aset", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("store", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "aset", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("default", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "getDefaultValue"));
        hashClass.defineMethod("default=", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "setDefaultValue", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("indexes", CallbackFactory.getOptMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "indexes"));
        hashClass.defineMethod("indices", CallbackFactory.getOptMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "indexes"));
        hashClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "size"));
        hashClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "size"));
        hashClass.defineMethod("empty?", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "empty_p"));
        hashClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "each"));
        hashClass.defineMethod("each_pair", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "each"));
        hashClass.defineMethod("each_value", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "each_value"));
        hashClass.defineMethod("each_key", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "each_key"));
        hashClass.defineMethod("sort", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "sort"));
        hashClass.defineMethod("keys", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "keys"));
        hashClass.defineMethod("values", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "values"));
        hashClass.defineMethod("shift", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "shift"));
        hashClass.defineMethod("delete", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "delete", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("delete_if", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "delete_if"));
        hashClass.defineMethod("reject", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "reject"));
        hashClass.defineMethod("reject!", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "reject_bang"));
        hashClass.defineMethod("clear", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "clear"));
        hashClass.defineMethod("invert", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "invert"));
        hashClass.defineMethod("update", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "update", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("replace", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "replace", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("include?", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "has_key", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("member?", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "has_key", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("has_key?", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "has_key", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("has_value?", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "has_value", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("key?", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "has_key", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        hashClass.defineMethod("value?", CallbackFactory.getMethod(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "has_value", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyHash.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        return hashClass;
    }

    public void modify() {
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "Hash");
        }
        if (this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't modify hash");
        }
    }

    public int length() {
        return this.valueMap.size();
    }

    public static RubyHash newHash(Ruby ruby) {
        return RubyHash.newInstance(ruby, ruby.getRubyClass("Hash"), new RubyObject[0]);
    }

    public static RubyHash newHash(Ruby ruby, Map valueMap, RubyObject defaultValue) {
        return new RubyHash(ruby, valueMap, defaultValue);
    }

    public static RubyHash newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyHash hash = new RubyHash(ruby);
        hash.setRubyClass((RubyClass)recv);
        hash.callInit(args);
        return hash;
    }

    public static RubyHash create(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyHash hsh = new RubyHash(ruby);
        if (args.length == 1) {
            hsh.setValueMap(new RubyHashMap((Map)((RubyHash)args[0]).getValueMap()));
        } else {
            if (args.length % 2 != 0) {
                throw new ArgumentError(ruby, "odd number of args for Hash");
            }
            int i = 0;
            while (i < args.length) {
                hsh.aset(args[i], args[i + 1]);
                i += 2;
            }
        }
        return hsh;
    }

    public RubyObject initialize(RubyObject[] args) {
        if (args.length > 0) {
            this.modify();
            this.setDefaultValue(args[0]);
        }
        return this;
    }

    public RubyString inspect() {
        String sep = ", ";
        String arrow = "=>";
        final StringBuffer sb = new StringBuffer("{");
        this.valueMap.foreach(new RubyMapMethod(){
            boolean firstEntry = true;

            public int execute(Object key, Object value, Object arg) {
                if (!this.firstEntry) {
                    sb.append(", ");
                }
                sb.append(((RubyObject)key).funcall("inspect"));
                sb.append("=>");
                sb.append(((RubyObject)value).funcall("inspect"));
                this.firstEntry = false;
                return 0;
            }
        }, null);
        sb.append("}");
        return RubyString.newString(this.ruby, sb.toString());
    }

    public RubyFixnum size() {
        return RubyFixnum.newFixnum(this.getRuby(), this.length());
    }

    public RubyBoolean empty_p() {
        return this.length() == 0 ? this.getRuby().getTrue() : this.getRuby().getFalse();
    }

    public RubyArray to_a() {
        RubyArray result = RubyArray.newArray(this.getRuby(), this.length());
        this.valueMap.foreach(new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                RubyArray ary = RubyArray.arrayValue((RubyObject)arg);
                ary.push(RubyArray.newArray(RubyHash.this.getRuby(), (RubyObject)key, (RubyObject)value));
                return 0;
            }
        }, result);
        return result;
    }

    public RubyString to_s() {
        return this.to_a().to_s();
    }

    public RubyObject rbClone() {
        RubyHash result = RubyHash.newHash(this.ruby, this.getValueMap(), this.getDefaultValue());
        result.setupClone(this);
        return result;
    }

    public RubyHash to_hash() {
        return this;
    }

    public RubyObject aset(RubyObject key, RubyObject value) {
        this.modify();
        if (!(key instanceof RubyString) || this.valueMap.get(key) != null) {
            this.valueMap.put(key, value);
        } else {
            RubyObject realKey = ((RubyString)key).dup();
            realKey.setFrozen(true);
            this.valueMap.put(realKey, value);
        }
        return this;
    }

    public RubyObject aref(RubyObject key) {
        RubyObject value = (RubyObject)this.valueMap.get(key);
        return value != null ? value : this.getDefaultValue();
    }

    public RubyBoolean has_key(RubyObject key) {
        return RubyBoolean.newBoolean(this.ruby, this.valueMap.containsKey(key));
    }

    public RubyBoolean has_value(RubyObject value) {
        return RubyBoolean.newBoolean(this.ruby, this.valueMap.containsValue(value));
    }

    public RubyHash each() {
        Iterator iter = this.entryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.ruby.yield(RubyArray.newArray(this.ruby, (RubyObject)entry.getKey(), (RubyObject)entry.getValue()));
        }
        return this;
    }

    public RubyHash each_value() {
        Iterator iter = this.valueIterator();
        while (iter.hasNext()) {
            RubyObject value = (RubyObject)iter.next();
            this.ruby.yield(value);
        }
        return this;
    }

    public RubyHash each_key() {
        Iterator iter = this.keyIterator();
        while (iter.hasNext()) {
            RubyObject key = (RubyObject)iter.next();
            this.ruby.yield(key);
        }
        return this;
    }

    public RubyArray sort() {
        RubyArray result = this.to_a();
        result.sort_bang();
        return result;
    }

    public RubyArray indexes(RubyObject[] indices) {
        ArrayList<RubyObject> values = new ArrayList<RubyObject>(indices.length);
        int i = 0;
        while (i < indices.length) {
            values.add(this.aref(indices[i]));
            ++i;
        }
        return RubyArray.newArray(this.ruby, values);
    }

    public RubyArray keys() {
        return RubyArray.newArray(this.ruby, new ArrayList(this.valueMap.keySet()));
    }

    public RubyArray values() {
        return RubyArray.newArray(this.ruby, new ArrayList(this.valueMap.values()));
    }

    public RubyBoolean equal(RubyObject other) {
        if (this == other) {
            return this.ruby.getTrue();
        }
        if (!(other instanceof RubyHash)) {
            return this.ruby.getFalse();
        }
        if (this.length() != ((RubyHash)other).length()) {
            return this.ruby.getFalse();
        }
        Iterator iter = this.modifiableEntryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object value = ((RubyHash)other).valueMap.get(entry.getKey());
            if (value != null && entry.getValue().equals(value)) continue;
            return this.ruby.getFalse();
        }
        return this.ruby.getTrue();
    }

    public RubyArray shift() {
        this.modify();
        Iterator iter = this.modifiableEntryIterator();
        Map.Entry entry = (Map.Entry)iter.next();
        iter.remove();
        return RubyArray.newArray(this.ruby, (RubyObject)entry.getKey(), (RubyObject)entry.getValue());
    }

    public RubyObject delete(RubyObject key) {
        this.modify();
        RubyObject result = (RubyObject)this.valueMap.remove(key);
        if (result != null) {
            return result;
        }
        if (this.ruby.isBlockGiven()) {
            return this.ruby.yield(key);
        }
        return this.getDefaultValue();
    }

    public RubyHash delete_if() {
        this.reject_bang();
        return this;
    }

    public RubyHash reject() {
        RubyHash result = (RubyHash)this.dup();
        result.reject_bang();
        return result;
    }

    public RubyHash reject_bang() {
        this.modify();
        boolean isModified = false;
        Iterator iter = this.keyIterator();
        while (iter.hasNext()) {
            RubyObject value;
            RubyObject key = (RubyObject)iter.next();
            RubyObject shouldDelete = this.ruby.yield(RubyArray.newArray(this.ruby, key, value = (RubyObject)this.valueMap.get(key)));
            if (!shouldDelete.isTrue()) continue;
            this.valueMap.remove(key);
            isModified = true;
        }
        if (isModified) {
            return this;
        }
        return RubyHash.nilHash(this.ruby);
    }

    public RubyHash clear() {
        this.modify();
        this.valueMap.clear();
        return this;
    }

    public RubyHash invert() {
        RubyHash result = RubyHash.newHash(this.ruby);
        Iterator iter = this.modifiableEntryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            RubyObject key = (RubyObject)entry.getKey();
            RubyObject value = (RubyObject)entry.getValue();
            result.aset(value, key);
        }
        return result;
    }

    public RubyHash update(RubyObject freshElements) {
        this.modify();
        RubyHash freshElementsHash = (RubyHash)freshElements.convertType(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "Hash", "to_hash");
        this.valueMap.putAll(freshElementsHash.valueMap);
        return this;
    }

    public RubyHash replace(RubyObject replacement) {
        this.modify();
        RubyHash replacementHash = (RubyHash)replacement.convertType(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "Hash", "to_hash");
        this.valueMap.clear();
        this.valueMap.putAll(replacementHash.valueMap);
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(123);
        output.dumpInt(this.getValueMap().size());
        Iterator iter = this.entryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            RubyObject key = (RubyObject)entry.getKey();
            RubyObject value = (RubyObject)entry.getValue();
            output.dumpObject(key);
            output.dumpObject(value);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyHash result = RubyHash.newHash(input.getRuby());
        int size = input.unmarshalInt();
        int i = 0;
        while (i < size) {
            RubyObject key = input.unmarshalObject();
            RubyObject value = input.unmarshalObject();
            result.aset(key, value);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

