/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RangeError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;

public abstract class RubyInteger
extends RubyNumeric {
    static /* synthetic */ Class class$org$jruby$RubyInteger;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyNumeric;

    public RubyInteger(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createIntegerClass(Ruby ruby) {
        RubyClass integerClass = ruby.defineClass("Integer", ruby.getClasses().getNumericClass());
        integerClass.defineSingletonMethod("induced_from", CallbackFactory.getSingletonMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "induced_from", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyInteger.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        integerClass.defineMethod("chr", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "chr"));
        integerClass.defineMethod("integer?", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "int_p"));
        integerClass.defineMethod("to_i", CallbackFactory.getSelfMethod());
        integerClass.defineMethod("to_int", CallbackFactory.getSelfMethod());
        integerClass.defineMethod("ceil", CallbackFactory.getSelfMethod());
        integerClass.defineMethod("floor", CallbackFactory.getSelfMethod());
        integerClass.defineMethod("round", CallbackFactory.getSelfMethod());
        integerClass.defineMethod("truncate", CallbackFactory.getSelfMethod());
        integerClass.defineMethod("next", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "succ"));
        integerClass.defineMethod("succ", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "succ"));
        integerClass.defineMethod("downto", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "downto", class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric));
        integerClass.defineMethod("step", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "step", class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric));
        integerClass.defineMethod("times", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "times"));
        integerClass.defineMethod("upto", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "upto", class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric));
        return integerClass;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.ruby, this.getDoubleValue());
    }

    public static RubyInteger induced_from(Ruby ruby, RubyObject recv, RubyObject number) {
        if (number instanceof RubyNumeric) {
            return (RubyInteger)number.funcall("to_i");
        }
        throw new TypeError(ruby, "failed to convert " + number.getRubyClass() + " into Integer");
    }

    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw new RangeError(this.getRuby(), this.toString() + " out of char range");
        }
        return RubyString.newString(this.getRuby(), new String(new char[]{(char)this.getLongValue()}));
    }

    public RubyObject downto(RubyNumeric to) {
        RubyNumeric i = this;
        while (!((RubyBoolean)i.funcall("<", to)).isTrue()) {
            this.getRuby().yield(i);
            i = (RubyNumeric)i.funcall("-", RubyFixnum.one(this.getRuby()));
        }
        return this;
    }

    public RubyBoolean int_p() {
        return this.getRuby().getTrue();
    }

    public RubyObject step(RubyNumeric to, RubyNumeric step) {
        RubyNumeric i = this;
        if (step.getLongValue() == 0L) {
            throw new ArgumentError(this.getRuby(), "step cannot be 0");
        }
        String cmp = "<";
        if (((RubyBoolean)step.funcall("<", RubyFixnum.newFixnum(this.getRuby(), 0L))).isFalse()) {
            cmp = ">";
        }
        while (!((RubyBoolean)i.funcall(cmp, to)).isTrue()) {
            this.getRuby().yield(i);
            i = (RubyNumeric)i.funcall("+", step);
        }
        return this;
    }

    public RubyObject times() {
        RubyNumeric i = RubyFixnum.zero(this.getRuby());
        while (!i.funcall("<", this).isFalse()) {
            this.getRuby().yield(i);
            i = (RubyNumeric)i.funcall("+", RubyFixnum.one(this.getRuby()));
        }
        return this;
    }

    public RubyObject succ() {
        return this.funcall("+", RubyFixnum.one(this.getRuby()));
    }

    public RubyObject upto(RubyNumeric to) {
        RubyNumeric i = this;
        while (!i.funcall(">", to).isTrue()) {
            this.getRuby().yield(i);
            i = (RubyNumeric)i.funcall("+", RubyFixnum.one(this.getRuby()));
        }
        return this;
    }

    public RubyInteger to_i() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

