/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.EOFError;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThrowJump;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.RubyVarmap;

public class RubyKernel {
    static /* synthetic */ Class class$org$jruby$RubyKernel;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyString;

    public static RubyModule createKernelModule(Ruby ruby) {
        RubyModule kernelModule = ruby.defineModule("Kernel");
        kernelModule.defineMethod("open", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "open"));
        kernelModule.defineMethod("format", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sprintf"));
        kernelModule.defineMethod("gets", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "gets"));
        kernelModule.defineMethod("p", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "p"));
        kernelModule.defineMethod("print", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "print"));
        kernelModule.defineMethod("printf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "printf"));
        kernelModule.defineMethod("puts", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "puts"));
        kernelModule.defineMethod("readline", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "readline"));
        kernelModule.defineMethod("readlines", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "readlines"));
        kernelModule.defineMethod("sprintf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sprintf"));
        kernelModule.defineMethod("gsub!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "gsub_bang"));
        kernelModule.defineMethod("gsub", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "gsub"));
        kernelModule.defineMethod("sub!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sub_bang"));
        kernelModule.defineMethod("sub", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sub"));
        kernelModule.defineMethod("chop!", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chop_bang"));
        kernelModule.defineMethod("chop", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chop"));
        kernelModule.defineMethod("chomp!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chomp_bang"));
        kernelModule.defineMethod("chomp", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chomp"));
        kernelModule.defineMethod("split", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "split"));
        kernelModule.defineMethod("scan", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "scan", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyKernel.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        kernelModule.defineMethod("load", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "load", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineMethod("raise", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "raise"));
        kernelModule.defineMethod("require", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "require", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineMethod("global_variables", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "global_variables"));
        kernelModule.defineMethod("local_variables", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "local_variables"));
        kernelModule.defineMethod("block_given?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "block_given"));
        kernelModule.defineMethod("iterator?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "block_given"));
        kernelModule.defineMethod("proc", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "proc"));
        kernelModule.defineMethod("loop", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "loop"));
        kernelModule.defineMethod("eval", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "eval", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineMethod("caller", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "caller"));
        kernelModule.defineMethod("catch", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "rbCatch", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyKernel.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        kernelModule.defineMethod("throw", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "rbThrow", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyKernel.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        kernelModule.defineMethod("singleton_method_added", CallbackFactory.getNilMethod());
        kernelModule.defineMethod("set_trace_func", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "set_trace_func", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyKernel.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        kernelModule.defineMethod("`", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "backquote", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineMethod("exit", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "exit"));
        kernelModule.defineMethod("srand", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "srand", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyKernel.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        kernelModule.defineMethod("rand", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "rand"));
        kernelModule.defineAlias("lambda", "proc");
        return kernelModule;
    }

    public static RubyObject open(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args[0].toString().startsWith("|")) {
            return ruby.getNil();
        }
        return RubyFile.open(ruby, ruby.getClasses().getFileClass(), args);
    }

    public static RubyString gets(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)ruby.getGlobalVar("$<");
        RubyString line = argsFile.internalGets(args);
        ruby.setLastline(line);
        return line;
    }

    public static RubyObject p(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyObject defout = ruby.getGlobalVar("$>");
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                defout.funcall("write", args[i].funcall("inspect"));
                defout.funcall("write", RubyString.newString(ruby, "\n"));
            }
            ++i;
        }
        return ruby.getNil();
    }

    public static RubyObject puts(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyObject defout = ruby.getGlobalVar("$>");
        RubyIO.puts(ruby, defout, args);
        return ruby.getNil();
    }

    public static RubyObject print(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyObject defout = ruby.getGlobalVar("$>");
        RubyIO.print(ruby, defout, args);
        return ruby.getNil();
    }

    public static RubyObject printf(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length != 0) {
            RubyObject defout = ruby.getGlobalVar("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                RubyObject[] newArgs = new RubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                args = newArgs;
            }
            RubyIO.printf(ruby, defout, args);
        }
        return ruby.getNil();
    }

    public static RubyString readline(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString line = RubyKernel.gets(ruby, recv, args);
        if (line.isNil()) {
            throw new EOFError(ruby);
        }
        return line;
    }

    public static RubyArray readlines(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)ruby.getGlobalVar("$<");
        RubyArray lines = RubyArray.newArray(ruby);
        RubyString line = argsFile.internalGets(args);
        while (!line.isNil()) {
            lines.push(line);
            line = argsFile.internalGets(args);
        }
        return lines;
    }

    private static RubyString getLastlineString(Ruby ruby) {
        RubyObject line = ruby.getLastline();
        if (line.isNil()) {
            throw new TypeError(ruby, "$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw new TypeError(ruby, "$_ value need to be String (" + line.getRubyClass().toName() + " given).");
        }
        return (RubyString)line;
    }

    public static RubyObject sub_bang(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyKernel.getLastlineString(ruby).sub_bang(args);
    }

    public static RubyObject sub(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(ruby).dup();
        if (!str.sub_bang(args).isNil()) {
            ruby.setLastline(str);
        }
        return str;
    }

    public static RubyObject gsub_bang(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyKernel.getLastlineString(ruby).gsub_bang(args);
    }

    public static RubyObject gsub(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(ruby).dup();
        if (!str.gsub_bang(args).isNil()) {
            ruby.setLastline(str);
        }
        return str;
    }

    public static RubyObject chop_bang(Ruby ruby, RubyObject recv) {
        return RubyKernel.getLastlineString(ruby).chop_bang();
    }

    public static RubyObject chop(Ruby ruby, RubyObject recv) {
        RubyString str = RubyKernel.getLastlineString(ruby);
        if (str.getValue().length() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            ruby.setLastline(str);
        }
        return str;
    }

    public static RubyObject chomp_bang(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyKernel.getLastlineString(ruby).chomp_bang(args);
    }

    public static RubyObject chomp(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString str = RubyKernel.getLastlineString(ruby);
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        ruby.setLastline(dup);
        return str;
    }

    public static RubyObject split(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyKernel.getLastlineString(ruby).split(args);
    }

    public static RubyObject scan(Ruby ruby, RubyObject recv, RubyObject pattern) {
        return RubyKernel.getLastlineString(ruby).scan(pattern);
    }

    public static RubyObject exit(Ruby ruby, RubyObject recv, RubyObject[] args) {
        int status = 0;
        if (args.length > 0) {
            status = RubyNumeric.fix2int(args[0]);
        }
        System.exit(status);
        return ruby.getNil();
    }

    public static RubyArray global_variables(Ruby ruby, RubyObject recv) {
        RubyArray globalVariables = RubyArray.newArray(ruby);
        Iterator iter = ruby.globalVariableNames();
        while (iter.hasNext()) {
            String globalVariableName = (String)iter.next();
            globalVariables.push(RubyString.newString(ruby, globalVariableName));
        }
        return globalVariables;
    }

    public static RubyArray local_variables(Ruby ruby, RubyObject recv) {
        RubyArray localVariables = RubyArray.newArray(ruby);
        if (ruby.getScope().getLocalNames() != null) {
            int i = 2;
            while (i < ruby.getScope().getLocalNames().size()) {
                if (ruby.getScope().getLocalNames().get(i) != null) {
                    localVariables.push(RubyString.newString(ruby, (String)ruby.getScope().getLocalNames().get(i)));
                }
                ++i;
            }
        }
        RubyVarmap dynamicVars = ruby.getDynamicVars();
        while (dynamicVars != null) {
            if (dynamicVars.getName() != null) {
                localVariables.push(RubyString.newString(ruby, dynamicVars.getName()));
            }
            dynamicVars = dynamicVars.getNext();
        }
        return localVariables;
    }

    public static RubyBoolean block_given(Ruby ruby, RubyObject recv) {
        return RubyBoolean.newBoolean(ruby, ruby.isFBlockGiven());
    }

    public static RubyObject sprintf(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(ruby, "sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = RubyArray.create(ruby, null, args);
        newArgs.shift();
        return str.format(newArgs);
    }

    public static RubyObject raise(Ruby ruby, RubyObject recv, RubyObject[] args) {
        switch (args.length) {
            case 0: 
            case 1: {
                throw new RaiseException(RubyException.newInstance(ruby, ruby.getExceptions().getRuntimeError(), args));
            }
            case 2: {
                RubyException excptn = (RubyException)args[0].funcall("exception", args[1]);
                throw new RaiseException(excptn);
            }
        }
        throw new ArgumentError(ruby, "wrong # of arguments");
    }

    public static RubyObject require(Ruby ruby, RubyObject recv, RubyString i2Load) {
        RubyArray lFeatures = (RubyArray)ruby.getGlobalVar("$\"");
        if (lFeatures.index(i2Load).isNil()) {
            RubyKernel.load(ruby, recv, i2Load);
            lFeatures.push(i2Load);
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    public static RubyObject load(Ruby ruby, RubyObject recv, RubyString i2Load) {
        if (i2Load.getValue().endsWith(".jar")) {
            File jarFile = ruby.findFile(ruby, new File(i2Load.getValue()));
            if (!jarFile.exists()) {
                ruby.getRuntime().getErrorStream().println("[Error] Jarfile + \"" + jarFile.getAbsolutePath() + "\"not found.");
            }
        } else {
            if (!i2Load.getValue().endsWith(".rb")) {
                i2Load = RubyString.newString(ruby, i2Load.getValue() + ".rb");
            }
            File rbFile = ruby.findFile(ruby, new File(i2Load.getValue()));
            ruby.getRuntime().loadFile(rbFile, false);
        }
        return ruby.getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyObject eval(Ruby ruby, RubyObject recv, RubyString src, RubyObject[] args) {
        RubyObject scope = args.length > 0 ? args[0] : ruby.getNil();
        String file = "(eval)";
        int line = 1;
        if (args.length > 1) {
            file = args[1].toString();
        }
        if (args.length > 2) {
            line = RubyFixnum.fix2int(args[2]);
        }
        src.checkSafeString();
        if (scope.isNil() && ruby.getFrameStack().getPrevious() != null) {
            RubyObject rubyObject;
            try {
                ruby.getFrameStack().push(ruby.getFrameStack().getPrevious());
                rubyObject = recv.eval(src, scope, file, line);
                Object var9_8 = null;
                ruby.getFrameStack().pop();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ruby.getFrameStack().pop();
                throw throwable;
            }
            return rubyObject;
        }
        return recv.eval(src, scope, file, line);
    }

    public static RubyObject caller(Ruby ruby, RubyObject recv, RubyObject[] args) {
        int level;
        int n = level = args.length > 0 ? RubyFixnum.fix2int(args[0]) : 1;
        if (level < 0) {
            throw new ArgumentError(ruby, "negative level(" + level + ')');
        }
        return RaiseException.createBacktrace(ruby, level);
    }

    public static RubyObject rbCatch(Ruby ruby, RubyObject recv, RubyObject tag) {
        try {
            return ruby.yield(tag);
        }
        catch (ThrowJump throwJump) {
            if (throwJump.getTag().equals(tag.toId())) {
                return throwJump.getValue();
            }
            throw throwJump;
        }
    }

    public static RubyObject rbThrow(Ruby ruby, RubyObject recv, RubyObject tag, RubyObject[] args) {
        throw new ThrowJump(tag.toId(), args.length > 0 ? args[0] : ruby.getNil());
    }

    public static RubyObject set_trace_func(Ruby ruby, RubyObject recv, RubyObject trace_func) {
        if (trace_func.isNil()) {
            ruby.getRuntime().setTraceFunction(null);
        } else if (!(trace_func instanceof RubyProc)) {
            throw new TypeError(ruby, "trace_func needs to be Proc.");
        }
        ruby.getRuntime().setTraceFunction((RubyProc)trace_func);
        return trace_func;
    }

    public static RubyProc proc(Ruby ruby, RubyObject recv) {
        return RubyProc.newProc(ruby, ruby.getClasses().getProcClass());
    }

    public static RubyObject loop(Ruby ruby, RubyObject recv) {
        while (true) {
            ruby.yield(ruby.getNil());
            Thread.yield();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static RubyObject backquote(Ruby ruby, RubyObject recv, RubyString aString) {
        try {
            String line;
            Process aProcess;
            String lShellProp = System.getProperty("jruby.shell");
            String lCommand = aString.toString();
            String lSwitch = "-c";
            if (lShellProp != null) {
                if (!lShellProp.endsWith("sh")) {
                    lSwitch = "/c";
                }
                aProcess = Runtime.getRuntime().exec(new String[]{lShellProp, lSwitch, lCommand});
            } else {
                aProcess = Runtime.getRuntime().exec(lCommand);
            }
            StringBuffer sb = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
            while ((line = reader.readLine()) != null) {
                void var9_10;
                sb.append((String)var9_10).append('\n');
            }
            aProcess.waitFor();
            return RubyString.newString(ruby, sb.toString());
        }
        catch (Exception excptn) {
            excptn.printStackTrace();
            return RubyString.newString(ruby, "");
        }
    }

    public static RubyInteger srand(Ruby ruby, RubyObject recv, RubyObject arg) {
        long oldRandomSeed = ruby.randomSeed;
        RubyInteger integerSeed = (RubyInteger)arg.convertToType("Integer", "to_int", true);
        ruby.randomSeed = integerSeed.getLongValue();
        ruby.random.setSeed(ruby.randomSeed);
        return RubyFixnum.newFixnum(ruby, oldRandomSeed);
    }

    public static RubyNumeric rand(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length == 0) {
            double result = ruby.random.nextDouble();
            return RubyFloat.newFloat(ruby, result);
        }
        if (args.length == 1) {
            RubyInteger integerCeil = (RubyInteger)args[0].convertToType("Integer", "to_int", true);
            long ceil = integerCeil.getLongValue();
            if (ceil > Integer.MAX_VALUE) {
                throw new NotImplementedError("Random values larger than Integer.MAX_VALUE not supported");
            }
            return RubyFixnum.newFixnum(ruby, ruby.random.nextInt((int)ceil));
        }
        throw new ArgumentError(ruby, "wrong # of arguments(" + args.length + " for 1)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

