/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIncludedClass;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.AttrSetNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RubyBugException;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.CacheEntry;
import org.jruby.internal.runtime.methods.CallbackMethod;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.marshal.MarshalStream;
import org.jruby.marshal.UnmarshalStream;
import org.jruby.runtime.Callback;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.ReflectionCallbackMethod;
import org.jruby.runtime.methods.IMethod;
import org.jruby.util.IdUtil;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyMapMethod;
import org.jruby.util.RubyPointer;

public class RubyModule
extends RubyObject {
    private RubyClass superClass;
    private String classId;
    private RubyString classPath;
    private RubyMap methods = new RubyHashMap();
    static /* synthetic */ Class class$org$jruby$RubyModule;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyModule(Ruby ruby) {
        this(ruby, null);
    }

    public RubyModule(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, null);
    }

    public RubyModule(Ruby ruby, RubyClass rubyClass, RubyClass superClass) {
        super(ruby, rubyClass);
        this.superClass = superClass;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
    }

    public RubyMap getMethods() {
        return this.methods;
    }

    public void setMethods(RubyMap methods) {
        this.methods = methods;
    }

    public boolean isModule() {
        return true;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public static void createModuleClass(RubyClass moduleClass) {
        Callback op_eqq = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_eqq", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback op_cmp = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback op_lt = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_lt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback op_le = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_le", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback op_gt = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_gt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback op_ge = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_ge", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback clone = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbClone");
        Callback dup = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "dup");
        Callback to_s = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "to_s");
        Callback included_modules = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "included_modules");
        Callback name = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "name");
        Callback ancestors = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "ancestors");
        Callback attr = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback attr_reader = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_reader");
        Callback attr_writer = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_writer");
        Callback attr_accessor = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_accessor");
        Callback newModule = CallbackFactory.getSingletonMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "newModule");
        Callback initialize = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "initialize");
        Callback instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "instance_methods");
        Callback public_instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "instance_methods");
        Callback protected_instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "protected_instance_methods");
        Callback private_instance_methods = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "private_instance_methods");
        Callback constants = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "constants");
        Callback const_get = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_get", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod const_set = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_set", new Class[]{class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject});
        Callback const_defined = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_defined", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback class_variables = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "class_variables");
        Callback remove_class_variable = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "remove_class_variable", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback append_features = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "append_features", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule);
        Callback extend_object = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "extend_object", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback include = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "include");
        Callback rbPublic = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbPublic");
        Callback rbProtected = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbProtected");
        Callback rbPrivate = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbPrivate");
        Callback module_function = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "module_function");
        Callback method_defined = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "method_defined", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback public_class_method = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "public_class_method");
        Callback private_class_method = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "private_class_method");
        Callback module_eval = CallbackFactory.getOptMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "module_eval");
        Callback remove_method = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "remove_method", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        Callback undef_method = CallbackFactory.getMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "undef_method", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod alias_method = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "alias_method", new Class[]{class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject});
        moduleClass.defineMethod("===", op_eqq);
        moduleClass.defineMethod("<=>", op_cmp);
        moduleClass.defineMethod("<", op_lt);
        moduleClass.defineMethod("<=", op_le);
        moduleClass.defineMethod(">", op_gt);
        moduleClass.defineMethod(">=", op_ge);
        moduleClass.defineMethod("clone", clone);
        moduleClass.defineMethod("dup", dup);
        moduleClass.defineMethod("to_s", to_s);
        moduleClass.defineMethod("included_modules", included_modules);
        moduleClass.defineMethod("name", name);
        moduleClass.defineMethod("ancestors", ancestors);
        moduleClass.definePrivateMethod("attr", attr);
        moduleClass.definePrivateMethod("attr_reader", attr_reader);
        moduleClass.definePrivateMethod("attr_writer", attr_writer);
        moduleClass.definePrivateMethod("attr_accessor", attr_accessor);
        moduleClass.defineSingletonMethod("new", newModule);
        moduleClass.defineMethod("initialize", initialize);
        moduleClass.defineMethod("instance_methods", instance_methods);
        moduleClass.defineMethod("public_instance_methods", public_instance_methods);
        moduleClass.defineMethod("protected_instance_methods", protected_instance_methods);
        moduleClass.defineMethod("private_instance_methods", private_instance_methods);
        moduleClass.defineMethod("constants", constants);
        moduleClass.defineMethod("const_get", const_get);
        moduleClass.defineMethod("const_set", const_set);
        moduleClass.defineMethod("const_defined?", const_defined);
        moduleClass.definePrivateMethod("method_added", CallbackFactory.getNilMethod());
        moduleClass.defineMethod("class_variables", class_variables);
        moduleClass.definePrivateMethod("remove_class_variable", remove_class_variable);
        moduleClass.definePrivateMethod("append_features", append_features);
        moduleClass.definePrivateMethod("extend_object", extend_object);
        moduleClass.definePrivateMethod("include", include);
        moduleClass.definePrivateMethod("public", rbPublic);
        moduleClass.definePrivateMethod("protected", rbProtected);
        moduleClass.definePrivateMethod("private", rbPrivate);
        moduleClass.definePrivateMethod("module_function", module_function);
        moduleClass.defineMethod("method_defined?", method_defined);
        moduleClass.defineMethod("public_class_method", public_class_method);
        moduleClass.defineMethod("private_class_method", private_class_method);
        moduleClass.defineMethod("module_eval", module_eval);
        moduleClass.defineMethod("class_eval", module_eval);
        moduleClass.defineMethod("remove_method", remove_method);
        moduleClass.defineMethod("undef_method", undef_method);
        moduleClass.defineMethod("alias_method", alias_method);
        moduleClass.defineSingletonMethod("nesting", CallbackFactory.getSingletonMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "nesting"));
    }

    public RubyString getClassname() {
        RubyString path = null;
        RubyModule module = this;
        while (module.isIncluded() || module.isSingleton()) {
            module = module.getSuperClass();
        }
        if (module == null) {
            module = this.getRuby().getClasses().getObjectClass();
        }
        if ((path = this.classPath) == null && this.classId != null) {
            this.classPath = path = RubyString.newString(this.getRuby(), this.classId);
            this.classId = null;
        }
        if (path == null) {
            return module.findClassPath();
        }
        return path;
    }

    public RubyString findClassPath() {
        FindClassPathResult arg = new FindClassPathResult();
        arg.klass = this;
        arg.track = this.getRuby().getClasses().getObjectClass();
        arg.prev = null;
        if (this.getRuby().getClasses().getObjectClass().getInstanceVariables() != null) {
            this.getRuby().getClasses().getObjectClass().getInstanceVariables().foreach(new FindClassPathMapMethod(), arg);
        }
        if (arg.name == null) {
            this.getRuby().getClasses().getClassMap().foreach(new FindClassPathMapMethod(), arg);
        }
        if (arg.name != null) {
            this.classPath = arg.path;
            return arg.path;
        }
        return RubyString.nilString(this.getRuby());
    }

    public RubyIncludedClass newIncludeClass(RubyClass superClass) {
        return new RubyIncludedClass(this.getRuby(), superClass, this);
    }

    public void setName(String name) {
        this.classId = name;
    }

    public void setClassPath(RubyModule under, String name) {
        RubyString value = null;
        if (under == this.getRuby().getClasses().getObjectClass()) {
            value = RubyString.newString(this.getRuby(), name);
        } else {
            value = (RubyString)under.getClassPath().dup();
            value.cat("::");
            value.cat(name);
        }
        this.classPath = value;
    }

    public RubyString getClassPath() {
        RubyString path = this.getClassname();
        if (path != null) {
            return path;
        }
        String s = "Module";
        if (this.isClass()) {
            s = "Class";
        }
        return RubyString.newString(this.getRuby(), "<" + s + " 01x" + Integer.toHexString(System.identityHashCode(this)) + ">");
    }

    public RubyModule getClassVarSingleton() {
        return this;
    }

    public void setClassVar(String name, RubyObject value) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                if (tmp.isTaint() && this.getRuby().getSafeLevel() >= 4) {
                    throw new RubySecurityException(this.getRuby(), "Insecure: can't modify class variable");
                }
                tmp.getInstanceVariables().put(name, value);
                return;
            }
            tmp = tmp.getSuperClass();
        }
        throw new NameError(this.getRuby(), "uninitialized class variable " + name + " in " + this.toName());
    }

    public void declareClassVar(String name, RubyObject value) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                if (tmp.isTaint() && this.getRuby().getSafeLevel() >= 4) {
                    throw new RubySecurityException(this.getRuby(), "Insecure: can't modify class variable");
                }
                tmp.getInstanceVariables().put(name, value);
            }
            tmp = tmp.getSuperClass();
        }
        this.setAv(name, value, false);
    }

    public RubyObject getClassVar(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                return (RubyObject)tmp.getInstanceVariables().get(name);
            }
            tmp = tmp.getSuperClass();
        }
        throw new NameError(this.getRuby(), "uninitialized class variable " + name + " in " + this.toName());
    }

    public boolean isClassVarDefined(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                return true;
            }
            tmp = tmp.getSuperClass();
        }
        return false;
    }

    public void setConstant(String name, RubyObject value) {
        this.setAv(name, value, true);
    }

    public RubyObject getConstant(String name) {
        boolean mod_retry = false;
        RubyModule tmp = this;
        while (true) {
            if (tmp != null) {
                if (!tmp.getInstanceVar(name).isNil()) {
                    return tmp.getInstanceVar(name);
                }
                if (tmp == this.getRuby().getClasses().getObjectClass() && this.getRuby().getTopConstant(name) != null) {
                    return this.getRuby().getTopConstant(name);
                }
                tmp = tmp.getSuperClass();
                continue;
            }
            if (mod_retry || !this.isModule()) break;
            mod_retry = true;
            tmp = this.getRuby().getClasses().getObjectClass();
        }
        String javaClassName = (String)this.getRuby().getJavaSupport().getRenamedJavaClasses().get(name);
        if (javaClassName == null) {
            javaClassName = name;
        }
        try {
            Class javaClass = this.getRuby().getJavaSupport().loadJavaClass(RubyString.newString(this.getRuby(), javaClassName));
            return this.getRuby().getJavaSupport().loadClass(javaClass, null);
        }
        catch (NameError excptn) {
            if (this != this.getRuby().getClasses().getObjectClass()) {
                throw new NameError(this.getRuby(), "uninitialized constant " + name + " at " + this.getClassPath().getValue());
            }
            throw new NameError(this.getRuby(), "uninitialized constant " + name);
        }
    }

    public void includeModule(RubyObject arg) {
        this.testFrozen();
        if (!this.isTaint()) {
            this.ruby.secure(4);
        }
        if (arg == null || arg == this) {
            return;
        }
        if (!(arg instanceof RubyModule)) {
            throw new TypeError(this.ruby, "Wrong argument type " + arg.getRubyClass().toName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg;
        boolean changed = false;
        RubyModule type = this;
        block0: while (module != null) {
            if (this.getMethods() == module.getMethods()) {
                throw new ArgumentError(this.ruby, "Cyclic include detected.");
            }
            RubyClass p = this.getSuperClass();
            while (p != null) {
                if (p.isIncluded() && p.getMethods() == module.getMethods()) {
                    type = p;
                    module = module.getSuperClass();
                    continue block0;
                }
                p = p.getSuperClass();
            }
            type.setSuperClass(module.newIncludeClass(type.getSuperClass()));
            type = type.getSuperClass();
            changed = true;
            module = module.getSuperClass();
        }
        if (changed) {
            this.ruby.getMethodCache().clear();
        }
    }

    protected void setAv(String name, RubyObject value, boolean constant) {
        String dest;
        String string = dest = constant ? "constant" : "class variable";
        if (!this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't set " + dest);
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        if (!constant || !this.getInstanceVar(name).isNil()) {
            // empty if block
        }
        this.setInstanceVar(name, value);
    }

    public void addMethod(String name, IMethod method, int noex) {
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't define method");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        this.ruby.getMethodCache().clearByName(name);
        this.getMethods().put(name, method);
    }

    public void defineMethod(String name, Callback method) {
        int noex = name.equals("initialize") ? 2 : 0;
        this.addMethod(name, new CallbackMethod(method), noex | 1);
    }

    public void defineProtectedMethod(String name, Callback method) {
        this.addMethod(name, new CallbackMethod(method), 5);
    }

    public void definePrivateMethod(String name, Callback method) {
        this.addMethod(name, new CallbackMethod(method), 3);
    }

    public void undefMethod(String name) {
        this.addMethod(name, null, 1);
    }

    protected void testFrozen() {
        String desc = "something(?!)";
        if (this.isFrozen()) {
            if (this.isSingleton()) {
                desc = "object";
            } else if (this.isIncluded() || this.isModule()) {
                desc = "module";
            } else if (this.isClass()) {
                desc = "class";
            }
            throw new RubyFrozenException(this.getRuby(), desc);
        }
    }

    public void undef(String name) {
        IMethod method;
        Ruby ruby = this.getRuby();
        if (this == ruby.getClasses().getObjectClass()) {
            ruby.secure(4);
        }
        if (ruby.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen();
        if (name.equals("__id__") || name.equals("__send__")) {
            // empty if block
        }
        if ((method = this.searchMethod(name)) == null) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                RubyObject obj = this.getInstanceVar("__attached__");
                if (obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw new NameError(ruby, "Undefined method " + name + " for" + s0 + " '" + c.toName() + "'");
        }
        this.addMethod(name, null, 0);
    }

    public void defineModuleFunction(String name, Callback method) {
        this.definePrivateMethod(name, method);
        this.defineSingletonMethod(name, method);
    }

    public void defineAlias(String newName, String oldName) {
        this.aliasMethod(newName, oldName);
    }

    public void defineAttribute(String name, boolean read, boolean write) {
        this.addAttribute(name, read, write, true);
    }

    public boolean isConstantDefined(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (!tmp.getInstanceVar(name).isNil()) {
                return true;
            }
            tmp = tmp.getSuperClass();
        }
        if (this.isModule()) {
            return this.getRuby().getClasses().getObjectClass().isConstantDefined(name);
        }
        if (this.getRuby().isClassDefined(name)) {
            return true;
        }
        return this.getRuby().isAutoloadDefined(name);
    }

    public boolean isConstantDefinedAt(String name) {
        if (!this.getInstanceVar(name).isNil()) {
            return true;
        }
        if (this == this.ruby.getClasses().getObjectClass()) {
            return this.isConstantDefined(name);
        }
        return false;
    }

    public IMethod searchMethod(String name) {
        IMethod method = (IMethod)this.getMethods().get(name);
        if (method == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().searchMethod(name);
            }
            return null;
        }
        method.setImplementationClass(this);
        return method;
    }

    public GetMethodBodyResult getMethodBody(String name, int noex) {
        GetMethodBodyResult result = new GetMethodBodyResult(this, name, noex);
        IMethod method = this.searchMethod(name);
        if (method == null) {
            this.getRuby().getMethodCache().saveUndefinedEntry(this, name);
            return null;
        }
        CacheEntry ent = new CacheEntry(this, method.getNoex());
        if (method instanceof AliasMethod) {
            ent.setName(name);
            ent.setOrigin(((AliasMethod)method).getOrigin());
            ent.setOriginalName(((AliasMethod)method).getOldName());
            ent.setMethod(((AliasMethod)method).getOldMethod());
            result.setRecvClass(((AliasMethod)method).getOrigin());
            result.setId(((AliasMethod)method).getOldName());
            method = ((AliasMethod)method).getOldMethod();
        } else {
            ent.setName(name);
            ent.setOriginalName(name);
            ent.setOrigin(method.getImplementationClass());
            ent.setMethod(method);
            result.setRecvClass(method.getImplementationClass());
        }
        this.getRuby().getMethodCache().saveEntry(this, name, ent);
        result.setNoex(ent.getNoex());
        result.setMethod(method);
        return result;
    }

    public RubyObject call(RubyObject recv, String name, RubyPointer args, int scope) {
        IMethod method;
        CacheEntry ent = this.getRuby().getMethodCache().getEntry(this, name);
        RubyModule klass = this;
        if (ent != null) {
            if (ent.getMethod() == null) {
                RubyPointer newArgs = new RubyPointer();
                newArgs.add(RubySymbol.newSymbol(this.getRuby(), name));
                if (args != null) {
                    newArgs.addAll(args);
                }
                return recv.funcall("method_missing", newArgs);
            }
            klass = ent.getOrigin();
            name = ent.getOriginalName();
            int noex = ent.getNoex();
            method = ent.getMethod();
        } else {
            GetMethodBodyResult gmbr = this.getMethodBody(name, 0);
            if (gmbr == null || gmbr.getMethod() == null) {
                if (scope == 3) {
                    throw new NameError(this.getRuby(), "super: no superclass method '" + name + "'");
                }
                RubyPointer newArgs = new RubyPointer();
                newArgs.add(RubySymbol.newSymbol(this.getRuby(), name));
                if (args != null) {
                    newArgs.addAll(args);
                }
                return recv.funcall("method_missing", newArgs);
            }
            klass = gmbr.getRecvClass();
            name = gmbr.getId();
            int noex = gmbr.getNoex();
            method = gmbr.getMethod();
        }
        return klass.call0(recv, name, args, method, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject call0(RubyObject recv, String name, RubyPointer args, IMethod method, boolean noSuper) {
        RubyObject rubyObject;
        Ruby ruby = this.getRuby();
        if (ruby.getActIter().isPre()) {
            ruby.getIterStack().push(Iter.ITER_CUR);
        } else {
            ruby.getIterStack().push(Iter.ITER_NOT);
        }
        ruby.getFrameStack().push();
        ruby.getActFrame().setLastFunc(name);
        ruby.getActFrame().setLastClass(noSuper ? null : this);
        ruby.getActFrame().setSelf(recv);
        ruby.getActFrame().setArgs(args);
        try {
            rubyObject = method.execute(ruby, recv, name, args != null ? args.toRubyArray() : new RubyObject[]{}, noSuper);
            Object var9_8 = null;
            ruby.getFrameStack().pop();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ruby.getFrameStack().pop();
            ruby.getIterStack().pop();
            throw throwable;
        }
        ruby.getIterStack().pop();
        return rubyObject;
    }

    public void aliasMethod(String name, String oldName) {
        this.testFrozen();
        if (oldName.equals(name)) {
            return;
        }
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        IMethod method = this.searchMethod(oldName);
        RubyModule origin = null;
        if (method == null) {
            if (this.isModule()) {
                method = this.getRuby().getClasses().getObjectClass().searchMethod(oldName);
            }
            if (method == null) {
                throw new NameError(this.ruby, "undefined method '" + name + "' for " + (this.isModule() ? "module" : "class") + " '" + this.toName() + "'");
            }
        }
        origin = method.getImplementationClass();
        if (method instanceof AliasMethod) {
            oldName = ((AliasMethod)method).getOldName();
            origin = ((AliasMethod)method).getOrigin();
            method = ((AliasMethod)method).getOldMethod();
        }
        this.getRuby().getMethodCache().clearByName(name);
        this.getMethods().put(name, new AliasMethod(method, oldName, origin, method.getNoex()));
    }

    public void removeMethod(String name) {
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't remove method");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        if (this.getMethods().remove(name) == null) {
            throw new NameError(this.getRuby(), "method '" + name + "' not defined in " + this.toName());
        }
        this.getRuby().getMethodCache().clearByName(name);
    }

    public RubyClass defineClassUnder(String name, RubyClass superClass) {
        if (this.isConstantDefinedAt(name)) {
            RubyObject type = this.getConstant(name);
            if (!(type instanceof RubyClass)) {
                throw new TypeError(this.ruby, name + " is not a class.");
            }
            if (((RubyClass)type).getSuperClass().getRealClass() != superClass) {
                throw new NameError(this.ruby, name + " is already defined.");
            }
            return (RubyClass)type;
        }
        RubyClass newClass = this.getRuby().defineClass(name, superClass);
        newClass.setClassPath(this, name);
        newClass.inheritedBy(superClass);
        this.setConstant(name, newClass);
        return newClass;
    }

    public RubyModule defineModuleUnder(String name) {
        if (this.isConstantDefinedAt(name)) {
            RubyObject module = this.getConstant(name);
            if (!(module instanceof RubyModule)) {
                throw new TypeError(this.ruby, this.toName() + "::" + module.getRubyClass().toName() + " is not a module.");
            }
            return (RubyModule)module;
        }
        RubyModule newModule = this.getRuby().defineModule(name);
        this.setConstant(name, newModule);
        newModule.setClassPath(this, name);
        return newModule;
    }

    public String toName() {
        if (this == this.getRuby().getClasses().getNilClass()) {
            return "NilClass";
        }
        if (this == this.getRuby().getClasses().getTrueClass()) {
            return "TrueClass";
        }
        if (this == this.getRuby().getClasses().getFalseClass()) {
            return "FalseClass";
        }
        return this.getClassPath().getValue();
    }

    public void defineConstant(String name, RubyObject value) {
        if (this == this.getRuby().getClasses().getClassClass()) {
            this.getRuby().secure(4);
        }
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "bad constant name " + name);
        }
        this.setConstant(name, value);
    }

    public RubyObject removeCvar(RubyObject name) {
        if (!IdUtil.isClassVariable(name.toId())) {
            throw new NameError(this.getRuby(), "wrong class variable name " + name.toId());
        }
        if (!this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't remove class variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        RubyObject value = (RubyObject)this.getInstanceVariables().remove(name.toId());
        if (value != null) {
            return value;
        }
        if (this.isClassVarDefined(name.toId())) {
            throw new NameError(this.getRuby(), "cannot remove " + name.toId() + " for " + this.toName());
        }
        throw new NameError(this.getRuby(), "class variable " + name.toId() + " not defined for " + this.toName());
    }

    public void defineClassVariable(String name, RubyObject value) {
        if (!IdUtil.isClassVariable(name)) {
            throw new NameError(this.getRuby(), "wrong class variable name " + name);
        }
        this.declareClassVar(name, value);
    }

    public void addAttribute(String name, boolean read, boolean write, boolean ex) {
        int noex = 0;
        if (ex) {
            noex = this.getRuby().getActMethodScope() == 1 ? 2 : (this.getRuby().getActMethodScope() == 2 ? 4 : 0);
        }
        String attrIV = "@" + name;
        if (read) {
            this.addMethod(name, new EvaluateMethod(new InstVarNode(this.getRuby().getPosition(), attrIV)), noex);
            this.funcall("method_added", RubySymbol.newSymbol(this.getRuby(), name));
        }
        if (write) {
            name = name + "=";
            this.addMethod(name, new EvaluateMethod(new AttrSetNode(this.getRuby().getPosition(), attrIV)), noex);
            this.funcall("method_added", RubySymbol.newSymbol(this.getRuby(), name));
        }
    }

    public RubyArray methodList(boolean option, RubyMapMethod method) {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyModule klass = this;
        while (klass != null) {
            klass.getMethods().foreach(method, ary);
            if (!option) break;
            klass = klass.getSuperClass();
        }
        Iterator iter = ary.getList().iterator();
        while (iter.hasNext()) {
            if (this.getRuby().getNil() != iter.next()) continue;
            iter.remove();
            iter.next();
        }
        return ary;
    }

    public void setMethodVisibility(RubyObject[] methods, int noex) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        int i = 0;
        while (i < methods.length) {
            this.exportMethod(methods[i].toId(), noex);
            ++i;
        }
    }

    public void exportMethod(String name, int noex) {
        IMethod method;
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        if ((method = this.searchMethod(name)) == null && this.isModule()) {
            method = this.getRuby().getClasses().getObjectClass().searchMethod(name);
        }
        if (method == null) {
            throw new NameError(this.ruby, "undefined method '" + name + "' for " + (this.isModule() ? "module" : "class") + " '" + this.toName() + "'");
        }
        if (method.getNoex() != noex) {
            if (this == method.getImplementationClass()) {
                method.setNoex(noex);
            } else {
                this.addMethod(name, new EvaluateMethod(new ZSuperNode(this.getRuby().getPosition())), noex);
            }
        }
    }

    public boolean isMethodBound(String name, int ex) {
        CacheEntry entry = this.getRuby().getMethodCache().getEntry(this, name);
        if (entry != null) {
            if (ex != 0 && (entry.getNoex() & 2) != 0) {
                return false;
            }
            return entry.getMethod() != null;
        }
        GetMethodBodyResult gmbr = this.getMethodBody(name, ex);
        if (gmbr != null) {
            return ex == 0 || (gmbr.getNoex() & 2) == 0;
        }
        return false;
    }

    public boolean isMethodDefined(String name) {
        return this.isMethodBound(name, 1);
    }

    /*
     * Unable to fully structure code
     */
    public RubyObject newMethod(RubyObject recv, String name, RubyClass methodClass) {
        originalClass = (RubyClass)this;
        originalName = name;
        gmbr = this.getMethodBody(name, 0);
        if (gmbr != null) ** GOTO lbl8
        return this.getRuby().getNil();
lbl-1000:
        // 1 sources

        {
            if ((gmbr = gmbr.getRecvClass().getSuperClass().getMethodBody(gmbr.getId(), 0)) != null) continue;
            return this.getRuby().getNil();
lbl8:
            // 2 sources

            ** while (gmbr.getMethod() instanceof EvaluateMethod && ((EvaluateMethod)gmbr.getMethod()).getNode() instanceof ZSuperNode)
        }
lbl9:
        // 1 sources

        newMethod = new RubyMethod(this.getRuby(), methodClass);
        newMethod.setReceiverClass((RubyClass)gmbr.getRecvClass());
        newMethod.setReceiver(recv);
        newMethod.setMethodId(gmbr.getId());
        newMethod.setMethod(gmbr.getMethod());
        newMethod.setOriginalClass(originalClass);
        newMethod.setOriginalId(originalName);
        return newMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject executeUnder(Callback method, RubyObject[] args) {
        RubyObject rubyObject;
        this.ruby.pushClass(this);
        Frame frame = this.ruby.getActFrame();
        this.ruby.getFrameStack().push();
        this.ruby.getActFrame().setLastFunc(frame.getLastFunc());
        this.ruby.getActFrame().setLastClass(frame.getLastClass());
        this.ruby.getActFrame().setArgs(frame.getArgs());
        if (this.ruby.getCBase() != this) {
            this.ruby.getActFrame().setNamespace(new Namespace(this, this.ruby.getActFrame().getNamespace()));
        }
        this.ruby.setNamespace(new Namespace(this, this.ruby.getNamespace()));
        try {
            rubyObject = method.execute(this, args, this.getRuby());
            Object var6_5 = null;
            this.ruby.setNamespace(this.ruby.getNamespace().getParent());
            this.ruby.getFrameStack().pop();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.ruby.setNamespace(this.ruby.getNamespace().getParent());
            this.ruby.getFrameStack().pop();
            this.ruby.popClass();
            throw throwable;
        }
        this.ruby.popClass();
        return rubyObject;
    }

    public static RubyModule newModule(Ruby ruby) {
        RubyModule newModule = new RubyModule(ruby, ruby.getClasses().getModuleClass());
        return newModule;
    }

    public RubyString name() {
        RubyString path = this.getClassname();
        if (path != null) {
            return (RubyString)path.dup();
        }
        return RubyString.newString(this.getRuby(), "");
    }

    public RubyArray class_variables() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyModule rbModule = this;
        while (rbModule != null) {
            if (rbModule.getInstanceVariables() != null) {
                Iterator iter = rbModule.getInstanceVariables().keySet().iterator();
                while (iter.hasNext()) {
                    RubyString kval;
                    String id = (String)iter.next();
                    if (!IdUtil.isClassVariable(id) || !ary.includes(kval = RubyString.newString(this.getRuby(), id)).isFalse()) continue;
                    ary.push(kval);
                }
            }
            rbModule = rbModule.getSuperClass();
        }
        return ary;
    }

    public RubyObject rbClone() {
        RubyModule clone = (RubyModule)super.rbClone();
        if (this.getMethods() != null) {
            this.getMethods().foreach(new RubyMapMethod(){

                public int execute(Object key, Object value, Object arg) {
                    IMethod method = (IMethod)value;
                    ((RubyMap)arg).put(key, method);
                    return 0;
                }
            }, clone.getMethods());
        }
        return clone;
    }

    public RubyObject dup() {
        RubyModule dup = (RubyModule)this.rbClone();
        dup.setRubyClass(this.getRubyClass());
        return dup;
    }

    public RubyArray included_modules() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyClass p = this.getSuperClass();
        while (p != null) {
            if (p.isIncluded()) {
                ary.push(((RubyIncludedClass)p).getDelegate());
            }
            p = p.getSuperClass();
        }
        return ary;
    }

    public RubyArray ancestors() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyModule p = this;
        while (p != null) {
            if (!p.isSingleton()) {
                if (p.isIncluded()) {
                    ary.push(((RubyIncludedClass)p).getDelegate());
                } else {
                    ary.push(p);
                }
            }
            p = p.getSuperClass();
        }
        return ary;
    }

    public RubyString to_s() {
        return (RubyString)this.getClassPath().dup();
    }

    public RubyBoolean op_eqq(RubyObject obj) {
        return obj.kind_of(this);
    }

    public RubyBoolean op_le(RubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuby(), "compared with non class/module");
        }
        RubyModule mod = this;
        while (mod != null) {
            if (mod.getMethods() == ((RubyModule)obj).getMethods()) {
                return this.getRuby().getTrue();
            }
            mod = mod.getSuperClass();
        }
        return this.getRuby().getFalse();
    }

    public RubyBoolean op_lt(RubyObject obj) {
        if (obj == this) {
            return this.getRuby().getFalse();
        }
        return this.op_le(obj);
    }

    public RubyBoolean op_ge(RubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuby(), "compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    public RubyBoolean op_gt(RubyObject obj) {
        if (this == obj) {
            return this.getRuby().getFalse();
        }
        return this.op_ge(obj);
    }

    public RubyFixnum op_cmp(RubyObject obj) {
        if (this == obj) {
            return RubyFixnum.newFixnum(this.getRuby(), 0L);
        }
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuby(), "<=> requires Class or Module (" + this.getRubyClass().toName() + " given)");
        }
        if (this.op_le(obj).isTrue()) {
            return RubyFixnum.newFixnum(this.getRuby(), -1L);
        }
        return RubyFixnum.newFixnum(this.getRuby(), 1L);
    }

    public RubyObject initialize(RubyObject[] args) {
        return this.getRuby().getNil();
    }

    public static RubyModule newModule(Ruby ruby, RubyObject recv) {
        RubyModule mod = RubyModule.newModule(ruby);
        mod.setRubyClass((RubyClass)recv);
        ruby.getClasses().getModuleClass().callInit(null);
        return mod;
    }

    public static RubyArray nesting(Ruby ruby, RubyObject recv) {
        Namespace ns = ruby.getActFrame().getNamespace();
        RubyArray ary = RubyArray.newArray(ruby);
        while (ns != null && ns.getParent() != null) {
            if (!ns.getNamespaceModule().isNil()) {
                ary.push(ns.getNamespaceModule());
            }
            ns = ns.getParent();
        }
        return ary;
    }

    public RubyObject attr(RubyObject symbol, RubyObject[] args) {
        boolean writeable = false;
        if (args.length > 0) {
            writeable = args[0].isTrue();
        }
        this.addAttribute(symbol.toId(), true, writeable, true);
        return this.getRuby().getNil();
    }

    public RubyObject attr_reader(RubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), true, false, true);
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject attr_writer(RubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), false, true, true);
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject attr_accessor(RubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), true, true, true);
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject const_get(RubyObject symbol) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "wrong constant name " + name);
        }
        return this.getConstant(name);
    }

    public RubyObject const_set(RubyObject symbol, RubyObject value) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "wrong constant name " + name);
        }
        this.setConstant(name, value);
        return value;
    }

    public RubyBoolean const_defined(RubyObject symbol) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "wrong constant name " + name);
        }
        return RubyBoolean.newBoolean(this.getRuby(), this.isConstantDefined(name));
    }

    public RubyArray instance_methods(RubyObject[] args) {
        boolean includeSuper = false;
        if (args.length > 0) {
            includeSuper = args[0].isTrue();
        }
        return this.methodList(includeSuper, new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                String id = (String)key;
                IMethod method = (IMethod)value;
                RubyArray ary = (RubyArray)arg;
                if ((method.getNoex() & 6) == 0) {
                    RubyString name = RubyString.newString(RubyModule.this.getRuby(), id);
                    if (ary.includes(name).isFalse()) {
                        if (method == null) {
                            ary.push(RubyModule.this.getRuby().getNil());
                        }
                        ary.push(name);
                    }
                } else if (method instanceof EvaluateMethod && ((EvaluateMethod)method).getNode() instanceof ZSuperNode) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                }
                return 0;
            }
        });
    }

    public RubyArray protected_instance_methods(RubyObject[] args) {
        boolean includeSuper = false;
        if (args.length > 0) {
            includeSuper = args[0].isTrue();
        }
        return this.methodList(includeSuper, new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                String id = (String)key;
                IMethod method = (IMethod)value;
                RubyArray ary = (RubyArray)arg;
                if (method == null) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                } else if ((method.getNoex() & 4) != 0) {
                    RubyString name = RubyString.newString(RubyModule.this.getRuby(), id);
                    if (ary.includes(name).isFalse()) {
                        ary.push(name);
                    }
                } else if (method instanceof EvaluateMethod && ((EvaluateMethod)method).getNode() instanceof ZSuperNode) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                }
                return 0;
            }
        });
    }

    public RubyArray private_instance_methods(RubyObject[] args) {
        boolean includeSuper = false;
        if (args.length > 0) {
            includeSuper = args[0].isTrue();
        }
        return this.methodList(includeSuper, new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                String id = (String)key;
                IMethod method = (IMethod)value;
                RubyArray ary = (RubyArray)arg;
                if (method == null) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                } else if ((method.getNoex() & 2) != 0) {
                    RubyString name = RubyString.newString(RubyModule.this.getRuby(), id);
                    if (ary.includes(name).isFalse()) {
                        ary.push(name);
                    }
                } else if (method instanceof EvaluateMethod && ((EvaluateMethod)method).getNode() instanceof ZSuperNode) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                }
                return 0;
            }
        });
    }

    public RubyArray constants() {
        ArrayList<RubyString> constantNames = new ArrayList<RubyString>();
        Iterator iter = this.getRuby().getClasses().nameIterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!IdUtil.isConstant(name)) continue;
            constantNames.add(RubyString.newString(this.getRuby(), name));
        }
        return RubyArray.newArray(this.getRuby(), constantNames);
    }

    public RubyObject remove_class_variable(RubyObject name) {
        Object value;
        String id = name.toId();
        if (!IdUtil.isClassVariable(id)) {
            throw new NameError(this.getRuby(), "wrong class variable name " + id);
        }
        if (!this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't remove class variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        if (this.getInstanceVariables() != null && (value = this.getInstanceVariables().remove(id)) != null) {
            return (RubyObject)value;
        }
        if (this.isClassVarDefined(id)) {
            throw new NameError(this.getRuby(), "cannot remove " + id + " for " + this.toName());
        }
        throw new NameError(this.getRuby(), "class variable " + id + " not defined for " + this.toName());
    }

    public RubyModule append_features(RubyModule module) {
        module.includeModule(this);
        return this;
    }

    public RubyObject extend_object(RubyObject obj) {
        obj.extendObject(this);
        return obj;
    }

    public RubyModule include(RubyObject[] modules) {
        int i = 0;
        while (i < modules.length) {
            modules[i].funcall("append_features", this);
            ++i;
        }
        return this;
    }

    public RubyModule rbPublic(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(0);
        } else {
            this.setMethodVisibility(args, 0);
        }
        return this;
    }

    public RubyModule rbProtected(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(2);
        } else {
            this.setMethodVisibility(args, 4);
        }
        return this;
    }

    public RubyModule rbPrivate(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(1);
        } else {
            this.setMethodVisibility(args, 2);
        }
        return this;
    }

    public RubyModule module_function(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(5);
        } else {
            this.setMethodVisibility(args, 2);
            int i = 0;
            while (i < args.length) {
                String name = args[i].toId();
                IMethod method = this.searchMethod(name);
                if (method == null) {
                    throw new RubyBugException("undefined method '" + name + "'; can't happen");
                }
                this.getSingletonClass().addMethod(name, method, 0);
                this.funcall("singleton_method_added", RubySymbol.newSymbol(this.getRuby(), name));
                ++i;
            }
        }
        return this;
    }

    public RubyBoolean method_defined(RubyObject symbol) {
        return this.isMethodBound(symbol.toId(), 1) ? this.getRuby().getTrue() : this.getRuby().getFalse();
    }

    public RubyModule public_class_method(RubyObject[] args) {
        this.getRubyClass().setMethodVisibility(args, 0);
        return this;
    }

    public RubyModule private_class_method(RubyObject[] args) {
        this.getRubyClass().setMethodVisibility(args, 2);
        return this;
    }

    public RubyModule alias_method(RubyObject newId, RubyObject oldId) {
        this.aliasMethod(newId.toId(), oldId.toId());
        return this;
    }

    public RubyModule undef_method(RubyObject name) {
        this.undef(name.toId());
        return this;
    }

    public RubyObject module_eval(RubyObject[] args) {
        return this.specificEval(this, args);
    }

    public RubyModule remove_method(RubyObject name) {
        this.removeMethod(name.toId());
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(109);
        output.dumpString(this.name().toString());
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name = input.unmarshalString();
        Ruby ruby = input.getRuby();
        RubyModule result = ruby.getClasses().getClass(name);
        if (result == null) {
            throw new NameError(ruby, "uninitialized constant " + name);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GetMethodBodyResult {
        private IMethod method;
        private RubyModule recvClass;
        private String id;
        private int noex;

        public GetMethodBodyResult(RubyModule recvClass, String id, int noex) {
            this.recvClass = recvClass;
            this.id = id;
            this.noex = noex;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public RubyModule getRecvClass() {
            return this.recvClass;
        }

        public void setRecvClass(RubyModule recvClass) {
            this.recvClass = recvClass;
        }

        public int getNoex() {
            return this.noex;
        }

        public void setNoex(int noex) {
            this.noex = noex;
        }

        public IMethod getMethod() {
            return this.method;
        }

        public void setMethod(IMethod method) {
            this.method = method;
        }
    }

    private class FindClassPathMapMethod
    implements RubyMapMethod {
        private FindClassPathMapMethod() {
        }

        public int execute(Object _key, Object _value, Object _res) {
            String key = (String)_key;
            if (_value instanceof String || _value == null) {
                return 0;
            }
            RubyObject value = (RubyObject)_value;
            FindClassPathResult res = (FindClassPathResult)_res;
            RubyString path = null;
            if (!IdUtil.isConstant(key)) {
                return 0;
            }
            if (res.path != null) {
                path = (RubyString)res.path.dup();
                path.cat("::");
                path.cat(key);
            } else {
                path = RubyString.newString(RubyModule.this.getRuby(), key);
            }
            if (value == res.klass) {
                res.name = key;
                res.path = path;
                return 1;
            }
            if (value.kind_of(RubyModule.this.getRuby().getClasses().getModuleClass()).isTrue()) {
                if (value.getInstanceVariables() == null) {
                    return 0;
                }
                FindClassPathResult list = res;
                while (list != null) {
                    if (list.track == value) {
                        return 0;
                    }
                    list = list.prev;
                }
                FindClassPathResult arg = new FindClassPathResult();
                arg.name = null;
                arg.path = path;
                arg.klass = res.klass;
                arg.track = value;
                arg.prev = res;
                value.getInstanceVariables().foreach(this, arg);
                if (arg.name != null) {
                    res.name = arg.name;
                    res.path = arg.path;
                    return 1;
                }
            }
            return 0;
        }
    }

    private static class FindClassPathResult {
        public String name;
        public RubyModule klass;
        public RubyString path;
        public RubyObject track;
        public FindClassPathResult prev;

        private FindClassPathResult() {
        }
    }
}

