/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;

public abstract class RubyNumeric
extends RubyObject {
    static /* synthetic */ Class class$org$jruby$RubyNumeric;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyNumeric(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public abstract double getDoubleValue();

    public abstract long getLongValue();

    public long getTruncatedLongValue() {
        return this.getLongValue();
    }

    public static RubyClass createNumericClass(Ruby ruby) {
        RubyClass numericClass = ruby.defineClass("Numeric", ruby.getClasses().getObjectClass());
        numericClass.includeModule(ruby.getClasses().getComparableModule());
        numericClass.defineMethod("coerce", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "coerce", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyNumeric.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        numericClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "rbClone"));
        numericClass.defineMethod("+@", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "op_uplus"));
        numericClass.defineMethod("-@", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "op_uminus"));
        numericClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyNumeric.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        numericClass.defineMethod("eql?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "eql", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyNumeric.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        numericClass.defineMethod("divmod", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "divmod", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyNumeric.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        numericClass.defineMethod("modulo", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "modulo", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyNumeric.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        numericClass.defineMethod("remainder", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "remainder", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyNumeric.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        numericClass.defineMethod("abs", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "abs"));
        numericClass.defineMethod("integer?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "int_p"));
        numericClass.defineMethod("zero?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "zero_p"));
        numericClass.defineMethod("nonzero?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "nonzero_p"));
        numericClass.defineMethod("floor", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "floor"));
        numericClass.defineMethod("ceil", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "ceil"));
        numericClass.defineMethod("round", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "round"));
        numericClass.defineMethod("truncate", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "truncate"));
        return numericClass;
    }

    public static long num2long(RubyObject arg) {
        if (arg instanceof RubyNumeric) {
            return ((RubyNumeric)arg).getLongValue();
        }
        throw new TypeError(arg.getRuby(), "argument is not numeric");
    }

    public static long fix2long(RubyObject arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).getLongValue();
        }
        throw new TypeError(arg.getRuby(), "argument is not a Fixnum");
    }

    public static int fix2int(RubyObject arg) {
        long val = RubyNumeric.fix2long(arg);
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            throw new TypeError(arg.getRuby(), "argument value is too big to convert to int");
        }
        return (int)val;
    }

    public static RubyNumeric numericValue(RubyObject arg) {
        if (!(arg instanceof RubyNumeric)) {
            throw new TypeError(arg.getRuby(), "argument not numeric");
        }
        return (RubyNumeric)arg;
    }

    public static RubyInteger str2inum(Ruby ruby, RubyString str, int base) {
        StringBuffer sbuf = new StringBuffer(str.getValue().trim());
        if (sbuf.length() == 0) {
            return RubyFixnum.zero(ruby);
        }
        int pos = 0;
        int radix = base != 0 ? base : 10;
        boolean digitsFound = false;
        if (sbuf.charAt(pos) == '-') {
            ++pos;
        } else if (sbuf.charAt(pos) == '+') {
            sbuf.deleteCharAt(pos);
        }
        if (pos == sbuf.length()) {
            return RubyFixnum.zero(ruby);
        }
        if (sbuf.charAt(pos) == '0') {
            sbuf.deleteCharAt(pos);
            if (pos == sbuf.length()) {
                return RubyFixnum.zero(ruby);
            }
            if (sbuf.charAt(pos) == 'x' || sbuf.charAt(pos) == 'X') {
                if (base == 0 || base == 16) {
                    radix = 16;
                    sbuf.deleteCharAt(pos);
                }
            } else if (sbuf.charAt(pos) == 'b' || sbuf.charAt(pos) == 'B') {
                if (base == 0 || base == 2) {
                    radix = 2;
                    sbuf.deleteCharAt(pos);
                }
            } else {
                radix = base == 0 ? 8 : base;
            }
        }
        while (pos < sbuf.length()) {
            if (sbuf.charAt(pos) == '_') {
                sbuf.deleteCharAt(pos);
                continue;
            }
            if (Character.digit(sbuf.charAt(pos), radix) == -1) break;
            digitsFound = true;
            ++pos;
        }
        if (!digitsFound) {
            return RubyFixnum.zero(ruby);
        }
        try {
            long l = Long.parseLong(sbuf.substring(0, pos), radix);
            return RubyFixnum.newFixnum(ruby, l);
        }
        catch (NumberFormatException ex) {
            BigInteger bi = new BigInteger(sbuf.substring(0, pos), radix);
            return new RubyBignum(ruby, bi);
        }
    }

    public static RubyFloat str2fnum(Ruby ruby, RubyString arg) {
        String str = arg.getValue().trim();
        double d = 0.0;
        int pos = str.length();
        int i = 0;
        while (i < pos) {
            if ("0123456789eE+-.".indexOf(str.charAt(i)) == -1) {
                pos = i + 1;
                break;
            }
            ++i;
        }
        while (pos > 0) {
            try {
                d = Double.parseDouble(str.substring(0, pos));
                break;
            }
            catch (NumberFormatException ex) {
                --pos;
            }
        }
        return new RubyFloat(ruby, d);
    }

    public RubyArray coerce(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (this.getRubyClass() == other.getRubyClass()) {
            return RubyArray.newArray(this.getRuby(), other, this);
        }
        return RubyArray.newArray(this.getRuby(), RubyFloat.newFloat(this.getRuby(), other.getDoubleValue()), RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()));
    }

    public RubyNumeric[] getCoerce(RubyNumeric other) {
        if (this.getRubyClass() == other.getRubyClass()) {
            return new RubyNumeric[]{this, other};
        }
        return new RubyNumeric[]{RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()), RubyFloat.newFloat(this.getRuby(), other.getDoubleValue())};
    }

    public RubyObject rbClone() {
        return this;
    }

    public RubyNumeric op_uplus() {
        return this;
    }

    public RubyNumeric op_uminus() {
        RubyNumeric[] coerce = this.getCoerce(RubyFixnum.zero(this.getRuby()));
        return (RubyNumeric)coerce[1].funcall("-", coerce[0]);
    }

    public RubyArray divmod(RubyObject val) {
        RubyNumeric other = RubyNumeric.numericValue(val);
        RubyNumeric div = (RubyNumeric)this.funcall("/", other);
        if (div instanceof RubyFloat) {
            double d = Math.floor(((RubyFloat)div).getValue());
            if (((RubyFloat)div).getValue() > d) {
                div = RubyFloat.newFloat(this.getRuby(), d);
            }
        }
        RubyNumeric mod = (RubyNumeric)this.funcall("%", other);
        return RubyArray.newArray(this.getRuby(), div, mod);
    }

    public RubyNumeric modulo(RubyObject val) {
        RubyNumeric other = RubyNumeric.numericValue(val);
        return (RubyNumeric)this.funcall("%", other);
    }

    public RubyNumeric remainder(RubyObject val) {
        RubyNumeric other = RubyNumeric.numericValue(val);
        RubyNumeric mod = (RubyNumeric)this.funcall("%", other);
        RubyFixnum zero = RubyFixnum.zero(this.getRuby());
        if (this.funcall("<", zero).isTrue() && other.funcall(">", zero).isTrue() || this.funcall(">", zero).isTrue() && other.funcall("<", zero).isTrue()) {
            return (RubyNumeric)mod.funcall("-", other);
        }
        return mod;
    }

    public RubyBoolean equal(RubyObject other) {
        return super.equal(other);
    }

    public RubyBoolean eql(RubyObject other) {
        if (this.getRubyClass() != other.getRubyClass()) {
            return this.getRuby().getFalse();
        }
        return super.equal(other);
    }

    public RubyNumeric abs() {
        if (this.funcall("<", RubyFixnum.zero(this.getRuby())).isTrue()) {
            return (RubyNumeric)this.funcall("-@");
        }
        return this;
    }

    public RubyBoolean int_p() {
        return this.getRuby().getFalse();
    }

    public RubyBoolean zero_p() {
        return this.equal(RubyFixnum.zero(this.getRuby()));
    }

    public RubyObject nonzero_p() {
        if (this.funcall("zero?").isTrue()) {
            return this.getRuby().getNil();
        }
        return this;
    }

    public RubyInteger floor() {
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).floor();
    }

    public RubyInteger ceil() {
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).ceil();
    }

    public RubyInteger round() {
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).round();
    }

    public RubyInteger truncate() {
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).truncate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

