/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Scope;

public class RubyProc
extends RubyObject {
    private Block block = null;
    private RubyModule wrapper = null;
    static /* synthetic */ Class class$org$jruby$RubyProc;

    public RubyProc(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createProcClass(Ruby ruby) {
        RubyClass procClass = ruby.defineClass("Proc", ruby.getClasses().getObjectClass());
        procClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyProc == null ? (class$org$jruby$RubyProc = RubyProc.class$("org.jruby.RubyProc")) : class$org$jruby$RubyProc, "newInstance"));
        procClass.defineMethod("call", CallbackFactory.getOptMethod(class$org$jruby$RubyProc == null ? (class$org$jruby$RubyProc = RubyProc.class$("org.jruby.RubyProc")) : class$org$jruby$RubyProc, "call"));
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public static RubyProc newInstance(Ruby ruby, RubyObject rubyClass, RubyObject[] args) {
        RubyProc proc = RubyProc.newProc(ruby, ruby.getClasses().getProcClass());
        proc.callInit(args);
        return proc;
    }

    public static RubyProc newProc(Ruby ruby, RubyClass rubyClass) {
        if (!ruby.isBlockGiven() && !ruby.isFBlockGiven()) {
            throw new ArgumentError(ruby, "tried to create Proc object without a block");
        }
        RubyProc newProc = new RubyProc(ruby, rubyClass);
        newProc.block = ruby.getBlock().getAct().cloneBlock();
        newProc.wrapper = ruby.getWrapper();
        newProc.block.setIter(newProc.block.getNext() != null ? Iter.ITER_PRE : Iter.ITER_NOT);
        newProc.block.setFrame(ruby.getActFrame());
        newProc.block.setScope((Scope)ruby.getScope().getTop());
        return newProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject call(RubyObject[] args) {
        RubyObject rubyObject;
        RubyModule oldWrapper = this.getRuby().getWrapper();
        Block oldBlock = this.getRuby().getBlock().getAct();
        this.getRuby().setWrapper(this.wrapper);
        this.getRuby().getBlock().setAct(this.block);
        this.getRuby().getIterStack().push(Iter.ITER_CUR);
        this.getRuby().getActFrame().setIter(Iter.ITER_CUR);
        try {
            rubyObject = this.getRuby().yield0(args != null ? RubyArray.newArray(this.getRuby(), args) : null, null, null, true);
            Object var6_5 = null;
            this.getRuby().getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getRuby().getIterStack().pop();
            this.getRuby().getBlock().setAct(oldBlock);
            this.getRuby().setWrapper(oldWrapper);
            throw throwable;
        }
        this.getRuby().getBlock().setAct(oldBlock);
        this.getRuby().setWrapper(oldWrapper);
        return rubyObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

