/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Frame;

public class RaiseException
extends JumpException {
    private RubyException actException;

    public RaiseException(RubyException actException) {
        this.setActException(actException);
    }

    public RaiseException(Ruby ruby, RubyClass excptnClass, String msg) {
        this.setActException(RubyException.newException(ruby, excptnClass, msg));
    }

    public RaiseException(Ruby ruby, String excptnClassName, String msg) {
        RubyClass excptnClass = (RubyClass)ruby.getRubyModule(excptnClassName);
        if (excptnClass == null) {
            System.err.println(excptnClassName);
        }
        this.setActException(RubyException.newException(ruby, excptnClass, msg));
    }

    public static RubyArray createBacktrace(Ruby ruby, int level) {
        RubyArray backtrace = RubyArray.newArray(ruby);
        Iterator iter = ruby.getFrameStack().iterator();
        while (level-- > 0) {
            if (!iter.hasNext()) {
                return RubyArray.nilArray(ruby);
            }
            iter.next();
        }
        Frame frame = null;
        if (iter.hasNext()) {
            frame = (Frame)iter.next();
        }
        while (frame != null && frame.getFile() != null) {
            StringBuffer sb = new StringBuffer(100);
            Frame previous = null;
            if (iter.hasNext() && (previous = (Frame)iter.next()).getLastFunc() != null) {
                sb.append(frame.getFile()).append(':').append(frame.getLine());
                sb.append(":in '").append(previous.getLastFunc()).append('\'');
            } else {
                sb.append(frame.getFile()).append(':').append(frame.getLine());
            }
            backtrace.push(RubyString.newString(ruby, sb.toString()));
            frame = previous;
        }
        return backtrace;
    }

    public RubyException getActException() {
        return this.actException;
    }

    protected void setActException(RubyException actException) {
        Ruby ruby = actException.getRuby();
        if (ruby.getRuntime().getTraceFunction() != null) {
            ruby.getRuntime().callTraceFunction("return", ruby.getSourceFile(), ruby.getSourceLine(), ruby.getActFrame().getSelf(), ruby.getActFrame().getLastFunc(), ruby.getActFrame().getLastClass());
        }
        this.actException = actException;
        if (ruby.stackTraces > 5) {
            return;
        }
        ++ruby.stackTraces;
        if (actException.funcall("backtrace").isNil() && ruby.getSourceFile() != null) {
            actException.funcall("set_backtrace", RaiseException.createBacktrace(ruby, -1));
        }
        --ruby.stackTraces;
    }
}

