/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CacheEntry;

public class RubyMethodCache {
    private Ruby ruby;
    private Map methodCache = new HashMap();

    public RubyMethodCache(Ruby ruby) {
        this.ruby = ruby;
    }

    public void saveUndefinedEntry(RubyModule recvClass, String name) {
        this.methodCache.put(RubyMethodCache.getKey(recvClass, name), new CacheEntry(name, recvClass));
    }

    public void saveEntry(RubyModule recvClass, String name, CacheEntry entry) {
        this.methodCache.put(RubyMethodCache.getKey(recvClass, name), entry);
    }

    public CacheEntry getEntry(RubyModule recvClass, String name) {
        CacheEntry entry = (CacheEntry)this.methodCache.get(RubyMethodCache.getKey(recvClass, name));
        if (entry != null && entry.getName().equals(name) && entry.getRecvClass() == recvClass) {
            return entry;
        }
        return null;
    }

    public void clearByName(String name) {
        Iterator iter = this.methodCache.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!((CacheEntry)entry.getValue()).getName().equals(name)) continue;
            iter.remove();
        }
    }

    public void clear() {
        this.methodCache.clear();
    }

    private static Integer getKey(RubyModule recvClass, String name) {
        return new Integer(System.identityHashCode(recvClass) ^ name.hashCode());
    }
}

