/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.EOFException;
import org.ablaf.common.IErrorHandler;
import org.ablaf.common.ISourcePosition;
import org.ablaf.lexer.ILexerSupport;

public class StringToken {
    private ILexerSupport support;
    private IErrorHandler errorHandler;
    private ISourcePosition position;
    private StringBuffer buffer = new StringBuffer(50);

    public StringToken(ILexerSupport support, IErrorHandler errorHandler, ISourcePosition position) {
        this.support = support;
        this.errorHandler = errorHandler;
        this.position = position;
    }

    public void append(char c) {
        this.buffer.append(c);
    }

    public void append(String s) {
        this.buffer.append(s);
    }

    public String getToken() {
        return this.buffer.toString();
    }

    public int getLength() {
        return this.buffer.length();
    }

    public void newToken(ISourcePosition position) {
        this.buffer = new StringBuffer(50);
        this.position = position;
    }

    public void appendEscape(char closeQuote) throws EOFException {
        char c = this.support.read();
        switch (c) {
            case '\n': {
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                this.append('\\');
                this.append(c);
                this.append(this.support.readOct(2));
                break;
            }
            case 'x': {
                this.append('\\');
                this.append(c);
                this.append(this.support.readHex(2));
                break;
            }
            case 'M': {
                c = this.support.read();
                if (c != '-') {
                    this.errorHandler.handleError(10, this.support.getPosition(), "Invalid escape character syntax. '-' expected, '" + c + "' found.");
                    this.support.unread();
                    break;
                }
                this.append("\\M-");
                this.appendPossibleEscapedChar(closeQuote);
                break;
            }
            case 'C': {
                c = this.support.read();
                if (c != '-') {
                    this.errorHandler.handleError(10, this.support.getPosition(), "Invalid escape character syntax. '-' expected, '" + c + "' found.");
                    this.support.unread();
                    break;
                }
                this.append("\\C-");
                this.appendPossibleEscapedChar(closeQuote);
                break;
            }
            case 'c': {
                this.append("\\c");
                this.appendPossibleEscapedChar(closeQuote);
                break;
            }
            case '\u0000': {
                this.errorHandler.handleError(10, this.support.getPosition(), "Invalid escape character syntax. Unexpected end of file.");
                throw new EOFException();
            }
            default: {
                if (c != closeQuote) {
                    this.append('\\');
                }
                this.append(c);
            }
        }
    }

    private final void appendPossibleEscapedChar(char closeQuote) throws EOFException {
        char c = this.support.read();
        switch (c) {
            case '\\': {
                this.appendEscape(closeQuote);
                break;
            }
            case '\u0000': {
                this.errorHandler.handleError(10, this.support.getPosition(), "Invalid escape character syntax. Unexpected end of file.");
                throw new EOFException();
            }
            default: {
                this.append(c);
            }
        }
    }

    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ILexerSupport getSupport() {
        return this.support;
    }

    public void setSupport(ILexerSupport support) {
        this.support = support;
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public void setPosition(ISourcePosition position) {
        this.position = position;
    }
}

