/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.marshal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.ArgumentError;

public class MarshalStream
extends FilterOutputStream {
    private static final int MARSHAL_MAJOR = 4;
    private static final int MARSHAL_MINOR = 5;
    private final Ruby ruby;
    private final int depthLimit;
    private int depth = 0;
    private Map dumpedObjects = new HashMap();
    private Map dumpedSymbols = new HashMap();

    public MarshalStream(Ruby ruby, OutputStream out, int depthLimit) throws IOException {
        super(out);
        this.ruby = ruby;
        this.depthLimit = depthLimit >= 0 ? depthLimit : Integer.MAX_VALUE;
        out.write(4);
        out.write(5);
    }

    public void dumpObject(RubyObject value) throws IOException {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw new ArgumentError(this.ruby, "exceed depth limit");
        }
        if (value.isNil()) {
            this.out.write(48);
        } else if (this.hasUserDefinedMarshaling(value)) {
            this.userMarshal(value);
        } else {
            this.writeAndRegister(value);
        }
        --this.depth;
    }

    private void writeAndRegister(RubyObject value) throws IOException {
        this.writeAndRegister(this.dumpedObjects, '@', value);
    }

    private void writeAndRegister(RubySymbol value) throws IOException {
        this.writeAndRegister(this.dumpedSymbols, ';', value);
    }

    private void writeAndRegister(Map registry, char linkSymbol, RubyObject value) throws IOException {
        if (registry.containsKey(value)) {
            this.out.write(linkSymbol);
            this.dumpInt((Integer)registry.get(value));
        } else {
            registry.put(value, new Integer(registry.size()));
            value.marshalTo(this);
        }
    }

    private boolean hasUserDefinedMarshaling(RubyObject value) {
        return value.respondsTo("_dump");
    }

    private void userMarshal(RubyObject value) throws IOException {
        this.out.write(117);
        this.dumpObject(value.getRubyClass().getClassname().intern());
        RubyFixnum depth = RubyFixnum.newFixnum(this.ruby, this.depthLimit);
        RubyString marshaled = (RubyString)value.funcall("_dump", depth);
        this.dumpString(marshaled.getValue());
    }

    public void dumpString(String value) throws IOException {
        this.dumpInt(value.length());
        this.out.write(RubyString.stringToBytes(value));
    }

    public void dumpInt(int value) throws IOException {
        if (value == 0) {
            this.out.write(0);
        } else if (0 < value && value < 123) {
            this.out.write(value + 5);
        } else if (-124 < value && value < 0) {
            this.out.write(value - 5 & 0xFF);
        } else {
            int[] buf = new int[4];
            int i = 0;
            while (i < buf.length) {
                buf[i] = value & 0xFF;
                if ((value >>= 8) == 0 || value == -1) break;
                ++i;
            }
            int len = i + 1;
            this.out.write(value < 0 ? -len : len);
            i = 0;
            while (i < len) {
                this.out.write(buf[i]);
                ++i;
            }
        }
    }

    static {
        MARSHAL_MAJOR = 4;
        MARSHAL_MINOR = 5;
    }
}

