/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.marshal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.util.RubyHashMap;

public class UnmarshalStream
extends FilterInputStream {
    private final Ruby ruby;

    public UnmarshalStream(Ruby ruby, InputStream in) throws IOException {
        super(in);
        this.ruby = ruby;
        in.read();
        in.read();
    }

    public RubyObject unmarshalObject() throws IOException {
        int type = this.readUnsignedByte();
        if (type == 48) {
            return RubyObject.nilObject(this.ruby);
        }
        if (type == 84) {
            return RubyBoolean.newBoolean(this.ruby, true);
        }
        if (type == 70) {
            return RubyBoolean.newBoolean(this.ruby, false);
        }
        if (type == 34) {
            return RubyString.unmarshalFrom(this);
        }
        if (type == 105) {
            return RubyFixnum.unmarshalFrom(this);
        }
        if (type == 58) {
            return RubySymbol.unmarshalFrom(this);
        }
        if (type == 91) {
            return RubyArray.unmarshalFrom(this);
        }
        if (type == 123) {
            return RubyHash.unmarshalFrom(this);
        }
        if (type == 99) {
            return RubyClass.unmarshalFrom(this);
        }
        if (type == 109) {
            return RubyModule.unmarshalFrom(this);
        }
        if (type == 108) {
            return RubyBignum.unmarshalFrom(this);
        }
        if (type == 111) {
            return this.defaultObjectUnmarshal();
        }
        if (type == 117) {
            return this.userUnmarshal();
        }
        throw new NotImplementedError();
    }

    public Ruby getRuby() {
        return this.ruby;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.read();
        if (result == -1) {
            throw new IOException("Unexpected end of stream");
        }
        return result;
    }

    public byte readSignedByte() throws IOException {
        int b = this.readUnsignedByte();
        if (b > 127) {
            return (byte)(b - 256);
        }
        return (byte)b;
    }

    public String unmarshalString() throws IOException {
        int length = this.unmarshalInt();
        byte[] buffer = new byte[length];
        int bytesRead = this.read(buffer);
        if (bytesRead != length) {
            throw new IOException("Unexpected end of stream");
        }
        return RubyString.bytesToString(buffer);
    }

    public int unmarshalInt() throws IOException {
        long result;
        int c = this.readSignedByte();
        if (c == 0) {
            return 0;
        }
        if (4 < c && c < 128) {
            return c - 5;
        }
        if (-129 < c && c < -4) {
            return c + 5;
        }
        if (c > 0) {
            result = 0L;
            int i = 0;
            while (i < c) {
                result |= (long)this.readUnsignedByte() << 8 * i;
                ++i;
            }
        } else {
            c = -c;
            result = -1L;
            int i = 0;
            while (i < c) {
                result &= 255L << 8 * i ^ 0xFFFFFFFFFFFFFFFFL;
                result |= (long)this.readUnsignedByte() << 8 * i;
                ++i;
            }
        }
        return (int)result;
    }

    private RubyObject defaultObjectUnmarshal() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject();
        int variableCount = this.unmarshalInt();
        RubyHashMap variables = new RubyHashMap(variableCount);
        int i = 0;
        while (i < variableCount) {
            RubySymbol name = (RubySymbol)this.unmarshalObject();
            RubyObject value = this.unmarshalObject();
            variables.put(name.toId(), value);
            ++i;
        }
        RubyClass rubyClass = this.ruby.getRubyClass(className.toId());
        RubyObject result = new RubyObject(this.ruby, rubyClass);
        result.setInstanceVariables(variables);
        return result;
    }

    private RubyObject userUnmarshal() throws IOException {
        String className = ((RubySymbol)this.unmarshalObject()).toId();
        String marshaled = this.unmarshalString();
        RubyModule classInstance = this.ruby.getRubyModule(className);
        return classInstance.funcall("_load", RubyString.newString(this.ruby, marshaled));
    }
}

