/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ablaf.ast.INode;
import org.ablaf.common.IErrorHandler;
import org.ablaf.common.ISourcePosition;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnCurrNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.IAssignableNode;
import org.jruby.ast.types.IListNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.util.ListNodeUtil;
import org.jruby.ast.util.NodeUtil;
import org.jruby.ast.visitor.UselessStatementVisitor;
import org.jruby.parser.BlockNamesStack;
import org.jruby.parser.IRubyParserConfiguration;
import org.jruby.parser.LocalNamesStack;
import org.jruby.parser.RubyParserResult;
import org.jruby.parser.Token;
import org.jruby.util.IdUtil;

public class ParserSupport {
    private LocalNamesStack localNames;
    private BlockNamesStack blockNames;
    private int inSingle;
    private boolean inDef;
    private boolean inDefined;
    private int classNest;
    private IErrorHandler errorHandler;
    private IRubyParserConfiguration configuration;
    private RubyParserResult result;

    public void reset() {
        this.localNames = new LocalNamesStack();
        this.blockNames = new BlockNamesStack(this.localNames);
        this.inSingle = 0;
        this.inDef = false;
        this.inDefined = false;
        this.classNest = this.configuration.isClassNest() ? 1 : 0;
    }

    public String getOperatorName(int operatorName) {
        if (operatorName >= 321 && operatorName <= 340) {
            return Token.operators[operatorName - 321];
        }
        return String.valueOf((char)operatorName);
    }

    public INode arg_blk_pass(IListNode firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public INode appendPrintToBlock(INode block) {
        return this.appendToBlock(block, new FCallNode(null, "print", new ArrayNode(block.getPosition()).add(new GlobalVarNode(block.getPosition(), "$_"))));
    }

    public INode appendWhileLoopToBlock(INode block, boolean chop, boolean split) {
        if (split) {
            block = this.appendToBlock(new GlobalAsgnNode(null, "$F", new CallNode(null, new GlobalVarNode(null, "$_"), "split", null)), block);
        }
        if (chop) {
            block = this.appendToBlock(new CallNode(null, new GlobalVarNode(null, "$_"), "chop!", null), block);
        }
        return new OptNNode(null, block);
    }

    public INode getAccessNode(String id, ISourcePosition iPosition) {
        if (IdUtil.isLocal(id)) {
            if (this.blockNames.isInBlock() && this.blockNames.isDefined(id)) {
                return new DVarNode(iPosition, id);
            }
            if (this.getLocalNames().isLocalRegistered(id)) {
                return new LocalVarNode(iPosition, this.getLocalNames().getLocalIndex(id));
            }
            return new VCallNode(iPosition, id);
        }
        if (IdUtil.isGlobal(id)) {
            return new GlobalVarNode(iPosition, id);
        }
        if (IdUtil.isInstanceVariable(id)) {
            return new InstVarNode(iPosition, id);
        }
        if (IdUtil.isConstant(id)) {
            return new ConstNode(iPosition, id);
        }
        if (IdUtil.isClassVariable(id)) {
            return new ClassVarNode(iPosition, id);
        }
        return null;
    }

    public INode getAssignmentNode(String id, INode valueNode, ISourcePosition iPosition) {
        this.checkExpression(valueNode);
        if (IdUtil.isLocal(id)) {
            if (this.blockNames.isCurrent(id)) {
                return new DAsgnCurrNode(iPosition, id, valueNode);
            }
            if (this.blockNames.isDefined(id)) {
                return new DAsgnNode(iPosition, id, valueNode);
            }
            if (this.getLocalNames().isLocalRegistered(id) || !this.blockNames.isInBlock()) {
                return new LocalAsgnNode(iPosition, this.getLocalNames().getLocalIndex(id), valueNode);
            }
            this.blockNames.add(id);
            return new DAsgnCurrNode(iPosition, id, valueNode);
        }
        if (IdUtil.isGlobal(id)) {
            return new GlobalAsgnNode(iPosition, id, valueNode);
        }
        if (IdUtil.isInstanceVariable(id)) {
            return new InstAsgnNode(iPosition, id, valueNode);
        }
        if (IdUtil.isConstant(id)) {
            if (this.isInDef() || this.isInSingle()) {
                this.errorHandler.handleError(10, "Dynamic constant assignment.");
            }
            return new ConstDeclNode(iPosition, id, valueNode);
        }
        if (IdUtil.isClassVariable(id)) {
            if (this.isInDef() || this.isInSingle()) {
                return new ClassVarAsgnNode(iPosition, id, valueNode);
            }
            return new ClassVarDeclNode(iPosition, id, valueNode);
        }
        return null;
    }

    public INode newline_node(INode node, ISourcePosition iPosition) {
        if (node != null) {
            return new NewlineNode(iPosition, node);
        }
        return null;
    }

    public INode appendToBlock(INode head, INode tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getPosition()).add(head);
        }
        if (this.errorHandler.isHandled(5) && NodeUtil.isBreakStatement(ListNodeUtil.getLast((IListNode)head))) {
            this.errorHandler.handleError(2, tail.getPosition(), "Statement not reached.", null);
        }
        if (tail instanceof BlockNode) {
            ListNodeUtil.addAll((IListNode)head, (IListNode)tail);
        } else {
            ((IListNode)head).add(tail);
        }
        return head;
    }

    public INode getOperatorCallNode(INode firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, null);
    }

    public INode getOperatorCallNode(INode firstNode, String operator, INode secondNode) {
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, new ArrayNode(secondNode.getPosition()).add(secondNode));
    }

    public INode getMatchNode(INode firstNode, INode secondNode) {
        this.getLocalNames().getLocalIndex("~");
        if (firstNode instanceof DRegexpNode || firstNode instanceof RegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), secondNode, firstNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public INode getElementAssignmentNode(INode recv, IListNode idx) {
        this.checkExpression(recv);
        return new CallNode(recv.getPosition(), recv, "[]=", idx);
    }

    public INode getAttributeAssignmentNode(INode recv, String name) {
        this.checkExpression(recv);
        return new CallNode(recv.getPosition(), recv, name + "=", null);
    }

    public void backrefAssignError(INode node) {
        if (node instanceof NthRefNode) {
            this.errorHandler.handleError(10, null, "Can't set variable $" + ((NthRefNode)node).getMatchNumber() + '.', null);
        } else if (node instanceof BackRefNode) {
            this.errorHandler.handleError(10, null, "Can't set variable $" + ((BackRefNode)node).getType() + '.', null);
        }
    }

    public INode node_assign(INode lhs, INode rhs) {
        if (lhs == null) {
            return null;
        }
        this.checkExpression(rhs);
        if (lhs instanceof IAssignableNode) {
            ((IAssignableNode)((Object)lhs)).setValueNode(rhs);
        } else if (lhs instanceof CallNode) {
            CallNode lCallLHS = (CallNode)lhs;
            IListNode lArgs = lCallLHS.getArgsNode();
            if (lArgs == null) {
                lArgs = new ArrayNode(lhs.getPosition());
                lCallLHS.setArgsNode(lArgs);
            }
            lArgs.add(rhs);
        }
        return lhs;
    }

    public void checkExpression(INode node) {
        if (!NodeUtil.isExpression(node)) {
            this.errorHandler.handleError(10, node.getPosition(), "Void value expression.", null);
        }
    }

    public void checkUselessStatement(INode node) {
        if (this.errorHandler.isHandled(5)) {
            new UselessStatementVisitor(this.errorHandler).acceptNode(node);
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.errorHandler.isHandled(5)) {
            Iterator iterator = blockNode.iterator();
            while (iterator.hasNext()) {
                this.checkUselessStatement((INode)iterator.next());
            }
        }
    }

    private boolean checkAssignmentInCondition(INode node) {
        if (node instanceof MultipleAsgnNode) {
            this.errorHandler.handleError(10, null, "Multiple assignment in conditional.", null);
            return true;
        }
        if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            INode valueNode = ((IAssignableNode)((Object)node)).getValueNode();
            if (valueNode instanceof ILiteralNode || valueNode instanceof NilNode || valueNode instanceof TrueNode || valueNode instanceof FalseNode) {
                this.errorHandler.handleError(1, null, "Found '=' in conditional, should be '=='.", null);
            }
            return true;
        }
        return false;
    }

    private INode cond0(INode node) {
        this.checkAssignmentInCondition(node);
        if (node instanceof DRegexpNode) {
            this.getLocalNames().getLocalIndex("_");
            this.getLocalNames().getLocalIndex("~");
            return new Match2Node(node.getPosition(), node, new GlobalVarNode(node.getPosition(), "$_"));
        }
        if (node instanceof DotNode) {
            FlipNode flipNode = new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), ((DotNode)node).isExclusive());
            flipNode.setCount(this.localNames.registerLocal(null));
            return flipNode;
        }
        if (node instanceof RegexpNode) {
            return new MatchNode(node.getPosition(), node);
        }
        if (node instanceof StrNode) {
            this.getLocalNames().getLocalIndex("_");
            this.getLocalNames().getLocalIndex("~");
            return new MatchNode(node.getPosition(), new RegexpNode(node.getPosition(), ((StrNode)node).getValue(), 0));
        }
        return node;
    }

    public INode getConditionNode(INode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof NewlineNode) {
            ((NewlineNode)node).setNextNode(this.cond0(((NewlineNode)node).getNextNode()));
            return node;
        }
        return this.cond0(node);
    }

    private INode getFlipConditionNode(INode node) {
        if ((node = this.getConditionNode(node)) instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        if (node instanceof FixnumNode) {
            return this.getOperatorCallNode(node, "==", new GlobalVarNode(node.getPosition(), "$."));
        }
        return node;
    }

    public AndNode newAndNode(INode left, INode right) {
        this.checkExpression(left);
        return new AndNode(left.getPosition(), this.getConditionNode(left), this.getConditionNode(right));
    }

    public OrNode newOrNode(INode left, INode right) {
        this.checkExpression(left);
        return new OrNode(left.getPosition(), this.getConditionNode(left), this.getConditionNode(right));
    }

    public INode getReturnArgsNode(INode node) {
        if (node instanceof ArrayNode && ListNodeUtil.getLength((IListNode)node) == 1) {
            return (INode)((IListNode)node).iterator().next();
        }
        if (node instanceof BlockPassNode) {
            this.errorHandler.handleError(10, null, "Block argument should not be given.", null);
        }
        return node;
    }

    public INode new_call(INode receiverNode, String name, INode args) {
        if (args != null && args instanceof BlockPassNode) {
            ((BlockPassNode)args).setIterNode(new CallNode(receiverNode.getPosition(), receiverNode, name, ((BlockPassNode)args).getArgsNode()));
            return args;
        }
        return new CallNode(receiverNode.getPosition(), receiverNode, name, (IListNode)args);
    }

    public INode new_fcall(String name, INode args, ISourcePosition iPosition) {
        if (args != null && args instanceof BlockPassNode) {
            ((BlockPassNode)args).setIterNode(new FCallNode(args.getPosition(), name, ((BlockPassNode)args).getArgsNode()));
            return args;
        }
        return new FCallNode(iPosition, name, (IListNode)args);
    }

    public INode new_super(INode args, ISourcePosition iPosition) {
        if (args != null && args instanceof BlockPassNode) {
            ((BlockPassNode)args).setIterNode(new SuperNode(args.getPosition(), ((BlockPassNode)args).getArgsNode()));
            return args;
        }
        return new SuperNode(iPosition, (IListNode)args);
    }

    public void initTopLocalVariables() {
        this.localNames.push();
        List names = this.configuration.getLocalVariables();
        if (names != null && names.size() > 0) {
            this.localNames.setNames(new ArrayList(names));
        }
        if (this.configuration.getBlockVariables() != null) {
            this.blockNames.push(this.configuration.getBlockVariables());
        }
    }

    public void updateTopLocalVariables() {
        this.result.setLocalVariables(this.localNames.getNames().size() > 0 ? this.localNames.getNames() : null);
        this.result.setBlockVariables(this.blockNames.isInBlock() ? this.blockNames.getNames() : null);
        this.localNames.pop();
    }

    public boolean isInSingle() {
        return this.inSingle != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingle = inSingle;
    }

    public boolean isInDef() {
        return this.inDef;
    }

    public void setInDef(boolean inDef) {
        this.inDef = inDef;
    }

    public int getInSingle() {
        return this.inSingle;
    }

    public boolean isInDefined() {
        return this.inDefined;
    }

    public void setInDefined(boolean inDefined) {
        this.inDefined = inDefined;
    }

    public boolean isCompileForEval() {
        return this.configuration.isCompileForEval();
    }

    public int getClassNest() {
        return this.classNest;
    }

    public void setClassNest(int classNest) {
        this.classNest = classNest;
    }

    public BlockNamesStack getBlockNames() {
        return this.blockNames;
    }

    public LocalNamesStack getLocalNames() {
        return this.localNames;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result) {
        this.result = result;
    }

    public IRubyParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IRubyParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

