/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.ablaf.ast.INode;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Iter;
import org.jruby.runtime.RubyVarmap;
import org.jruby.runtime.Scope;
import org.jruby.runtime.methods.IMethod;
import org.jruby.util.collections.StackElement;

public class Block
implements StackElement {
    private INode var;
    private IMethod method;
    private RubyObject self;
    private Frame frame;
    private Scope scope;
    private RubyModule klass;
    private Iter iter;
    private RubyVarmap dynamicVars;
    private RubyObject origThread;
    private Block next;

    public Block(INode var, IMethod method, RubyObject self, Frame frame, Scope scope, RubyModule klass, Iter iter, RubyVarmap dynamicVars, RubyObject origThread) {
        this.var = var;
        this.method = method;
        this.self = self;
        this.frame = frame;
        this.scope = scope;
        this.klass = klass;
        this.iter = iter;
        this.dynamicVars = dynamicVars;
        this.origThread = origThread;
    }

    public Block cloneBlock() {
        Block newBlock = new Block(this.var, this.method, this.self, this.frame, this.scope, this.klass, this.iter, this.dynamicVars, this.origThread);
        if (this.getNext() != null) {
            newBlock.setNext((Block)this.getNext());
        }
        return newBlock;
    }

    public StackElement getNext() {
        return this.next;
    }

    public void setNext(StackElement newNext) {
        this.next = (Block)newNext;
    }

    public RubyVarmap getDynamicVars() {
        return this.dynamicVars;
    }

    public void setDynamicVars(RubyVarmap dynamicVars) {
        this.dynamicVars = dynamicVars;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Iter getIter() {
        return this.iter;
    }

    public void setIter(Iter iter) {
        this.iter = iter;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public void setKlass(RubyModule klass) {
        this.klass = klass;
    }

    public IMethod getMethod() {
        return this.method;
    }

    public void setMethod(IMethod method) {
        this.method = method;
    }

    public RubyObject getOrigThread() {
        return this.origThread;
    }

    public void setOrigThread(RubyObject origThread) {
        this.origThread = origThread;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public RubyObject getSelf() {
        return this.self;
    }

    public void setSelf(RubyObject self) {
        this.self = self;
    }

    public INode getVar() {
        return this.var;
    }

    public void setVar(INode var) {
        this.var = var;
    }
}

