/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.RubyObject;

public class Namespace {
    private Namespace parent;
    private RubyModule namespaceModule;

    public Namespace(RubyModule namespaceModule) {
        this(namespaceModule, null);
    }

    public Namespace(RubyModule namespaceModule, Namespace parent) {
        this.namespaceModule = namespaceModule;
        this.parent = parent;
    }

    public Namespace cloneNamespace() {
        return new Namespace(this.namespaceModule, this.parent != null ? this.parent.cloneNamespace() : null);
    }

    public Namespace getParent() {
        return this.parent;
    }

    public void setParent(Namespace newParent) {
        this.parent = newParent;
    }

    public RubyModule getNamespaceModule() {
        return this.namespaceModule;
    }

    public void setNamespaceModule(RubyModule namespaceModule) {
        this.namespaceModule = namespaceModule;
    }

    public RubyObject getConstant(RubyObject self, String name) {
        Namespace ns = this;
        while (ns != null && ns.getParent() != null) {
            if (ns.getNamespaceModule() == null) {
                return self.getRubyClass().getConstant(name);
            }
            if (!ns.getNamespaceModule().getInstanceVar(name).isNil()) {
                return (RubyObject)ns.getNamespaceModule().getInstanceVariables().get(name);
            }
            ns = ns.getParent();
        }
        return this.getNamespaceModule().getConstant(name);
    }
}

