/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Callback;

public class ReflectionCallbackMethod
implements Callback {
    private Class klass;
    private String methodName;
    private Class[] args;
    private boolean staticMethod;
    private boolean restArgs;
    private Method method;
    static /* synthetic */ Class array$Lorg$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$Ruby;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public ReflectionCallbackMethod(Class klass, String methodName) {
        this(klass, methodName, (Class[])null, false, false);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, Class args) {
        this(klass, methodName, new Class[]{args}, false, false);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, Class[] args) {
        this(klass, methodName, args, false, false);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, boolean restArgs) {
        Class[] classArray;
        if (restArgs) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = array$Lorg$jruby$RubyObject == null ? (array$Lorg$jruby$RubyObject = ReflectionCallbackMethod.class$("[Lorg.jruby.RubyObject;")) : array$Lorg$jruby$RubyObject;
        } else {
            classArray = null;
        }
        this(klass, methodName, classArray, restArgs, false);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, Class args, boolean restArgs) {
        this(klass, methodName, new Class[]{args}, restArgs, false);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, Class[] args, boolean restArgs) {
        this(klass, methodName, args, restArgs, false);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, boolean restArgs, boolean staticMethod) {
        Class[] classArray;
        if (restArgs) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = array$Lorg$jruby$RubyObject == null ? (array$Lorg$jruby$RubyObject = ReflectionCallbackMethod.class$("[Lorg.jruby.RubyObject;")) : array$Lorg$jruby$RubyObject;
        } else {
            classArray = null;
        }
        this(klass, methodName, classArray, restArgs, staticMethod);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, Class args, boolean restArgs, boolean staticMethod) {
        this(klass, methodName, new Class[]{args}, restArgs, staticMethod);
    }

    public ReflectionCallbackMethod(Class klass, String methodName, Class[] args, boolean restArgs, boolean staticMethod) {
        this.klass = null;
        this.methodName = null;
        this.args = null;
        this.staticMethod = false;
        this.restArgs = false;
        this.method = null;
        this.klass = klass;
        this.methodName = methodName;
        this.args = args != null ? args : new Class[]{};
        this.restArgs = restArgs;
        this.staticMethod = staticMethod;
    }

    protected Method getMethod() {
        if (this.method == null) {
            try {
                Class[] newArgs = this.args;
                if (this.staticMethod) {
                    newArgs = new Class[this.args.length + 2];
                    System.arraycopy(this.args, 0, newArgs, 2, this.args.length);
                    newArgs[0] = class$org$jruby$Ruby == null ? (class$org$jruby$Ruby = ReflectionCallbackMethod.class$("org.jruby.Ruby")) : class$org$jruby$Ruby;
                    newArgs[1] = class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = ReflectionCallbackMethod.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject;
                }
                this.method = this.klass.getMethod(this.methodName, newArgs);
            }
            catch (NoSuchMethodException nsmExcptn) {
                throw new RuntimeException("NoSuchMethodException: Cannot get method \"" + this.methodName + "\" in class \"" + this.klass.getName() + "\" by Reflection.");
            }
            catch (SecurityException sExcptn) {
                throw new RuntimeException("SecurityException: Cannot get method \"" + this.methodName + "\" in class \"" + this.klass.getName() + "\" by Reflection.");
            }
        }
        return this.method;
    }

    protected void testArgsCount(Ruby ruby, RubyObject[] methodArgs) {
        if (this.restArgs ? methodArgs.length < this.args.length - 1 : methodArgs.length != this.args.length) {
            throw new ArgumentError(ruby, this.getExceptedArgsString(methodArgs));
        }
    }

    protected String getExceptedArgsString(RubyObject[] methodArgs) {
        String className;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Wrong arguments:");
        if (methodArgs.length == 0) {
            sb.append(" No args");
        } else {
            sb.append(" (");
            i = 0;
            while (i < methodArgs.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                className = methodArgs[i].getClass().getName();
                className = className.substring(className.lastIndexOf(".Ruby") + 5);
                sb.append("a");
                if (className.charAt(0) == 'A' || className.charAt(0) == 'E' || className.charAt(0) == 'I' || className.charAt(0) == 'O' || className.charAt(0) == 'U') {
                    sb.append("n");
                }
                sb.append(className);
                ++i;
            }
            sb.append(")");
        }
        sb.append(" given, ");
        if (this.args.length == 0) {
            sb.append("no arguments excepted.");
        } else {
            sb.append("(");
            i = 0;
            while (i < this.args.length) {
                if (i > 0) {
                    sb.append(",");
                }
                className = this.args[i].getName();
                sb.append("a").append(className.substring(className.lastIndexOf(".Ruby") + 5));
                ++i;
            }
            if (this.restArgs) {
                sb.append(", ...");
            }
            sb.append(") excepted.");
        }
        return sb.toString();
    }

    protected RubyObject invokeMethod(RubyObject recv, Object[] methodArgs, Ruby ruby) {
        if (this.restArgs) {
            RubyObject[] restArray = new RubyObject[methodArgs.length - (this.args.length - 1)];
            Object[] newMethodArgs = new Object[this.args.length];
            try {
                System.arraycopy(methodArgs, this.args.length - 1, restArray, 0, methodArgs.length - (this.args.length - 1));
            }
            catch (ArrayIndexOutOfBoundsException aioobExcptn) {
                throw new RuntimeException("Cannot call \"" + this.methodName + "\" in class \"" + this.klass.getName() + "\". " + this.getExceptedArgsString((RubyObject[])methodArgs));
            }
            System.arraycopy(methodArgs, 0, newMethodArgs, 0, this.args.length - 1);
            newMethodArgs[this.args.length - 1] = restArray;
            methodArgs = newMethodArgs;
        }
        if (this.staticMethod) {
            Object[] newMethodArgs = new Object[methodArgs.length + 2];
            System.arraycopy(methodArgs, 0, newMethodArgs, 2, methodArgs.length);
            newMethodArgs[0] = ruby;
            newMethodArgs[1] = recv;
            methodArgs = newMethodArgs;
        }
        try {
            return (RubyObject)this.getMethod().invoke((Object)(this.staticMethod ? null : recv), methodArgs);
        }
        catch (InvocationTargetException itExcptn) {
            if (itExcptn.getTargetException() instanceof RaiseException) {
                throw (RaiseException)itExcptn.getTargetException();
            }
            if (itExcptn.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)itExcptn.getTargetException();
            }
            System.err.println("[ERROR] Calling method: " + this.klass + "#" + this.method);
            itExcptn.getTargetException().printStackTrace();
            return ruby.getNil();
        }
        catch (IllegalAccessException iaExcptn) {
            throw new RaiseException(ruby, "RuntimeError", iaExcptn.getMessage());
        }
        catch (IllegalArgumentException iaExcptn) {
            throw new RaiseException(ruby, "TypeError", iaExcptn.getMessage());
        }
    }

    public RubyObject execute(RubyObject recv, RubyObject[] args, Ruby ruby) {
        args = args != null ? args : new RubyObject[]{};
        this.testArgsCount(ruby, args);
        return this.invokeMethod(recv, args, ruby);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

