/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import junit.framework.Assert;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.test.TestRubyBase;

public class TestRubyHash
extends TestRubyBase {
    private RubyHash rubyHash;
    private String result;

    public TestRubyHash(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
        this.eval("$h = {'foo' => 'bar'}");
    }

    public void tearDown() {
        super.tearDown();
    }

    public void testConstructors() {
        this.result = this.eval("hash = {'a', 100}; p hash");
        Assert.assertEquals((Object)"{\"a\"=>100}", (Object)this.result);
        this.result = this.eval("hash = Hash['b', 200]; p hash");
        Assert.assertEquals((Object)"{\"b\"=>200}", (Object)this.result);
        this.result = this.eval("hash = Hash.new(); p hash['test']");
        Assert.assertEquals((Object)"nil", (Object)this.result);
        this.result = this.eval("hash = Hash.new('default'); p hash['test']");
        Assert.assertEquals((Object)"\"default\"", (Object)this.result);
    }

    public void testLookups() {
        this.result = this.eval("key = 'a'; hash = {key => 'one'}; hash.store('a', 'two'); puts hash[key]");
        Assert.assertEquals((Object)"two", (Object)this.result);
        this.result = this.eval("key = [1,2]; hash = {key => 'one'}; hash[[1,2]] = 'two'; puts hash[key]");
        Assert.assertEquals((Object)"two", (Object)this.result);
        this.result = this.eval("key = :a; hash = {key => 'one'}; hash[:a] = 'two'; puts hash[key]");
        Assert.assertEquals((Object)"two", (Object)this.result);
        this.result = this.eval("key = 1234; hash = {key => 'one'}; hash[1234] = 'two'; puts hash[key]");
        Assert.assertEquals((Object)"two", (Object)this.result);
        this.result = this.eval("key = 12.4; hash = {key => 'one'}; hash[12.4] = 'two'; puts hash[key]");
        Assert.assertEquals((Object)"two", (Object)this.result);
        this.result = this.eval("key = 19223372036854775807; hash = {key => 'one'}; hash[19223372036854775807] = 'two'; puts hash[key]");
        Assert.assertEquals((Object)"two", (Object)this.result);
        this.result = this.eval("key = /a/; hash = {key => 'one'}; hash[/a/] = 'two'; puts hash[key]");
        Assert.assertEquals((Object)"one", (Object)this.result);
        this.result = this.eval("key = (1..3); hash = {key => 'one'}; hash[(1..3)] = 'two'; puts hash[key]");
        Assert.assertEquals((Object)"one", (Object)this.result);
    }

    public void testConversions() {
        this.result = this.eval("p $h.to_s");
        Assert.assertEquals((Object)"\"foobar\"", (Object)this.result);
        this.result = this.eval("p $h.to_a");
        Assert.assertEquals((Object)"[[\"foo\", \"bar\"]]", (Object)this.result);
        this.result = this.eval("p $h.to_hash");
        Assert.assertEquals((Object)"{\"foo\"=>\"bar\"}", (Object)this.result);
    }

    public void testSizeRelated() {
        Assert.assertEquals((Object)"1", (Object)this.eval("p $h.size"));
        Assert.assertEquals((Object)"1", (Object)this.eval("p $h.length"));
        Assert.assertEquals((Object)"false", (Object)this.eval("p $h.empty?"));
        Assert.assertEquals((Object)"true", (Object)this.eval("p Hash.new().empty?"));
    }

    public void testIterating() {
        Assert.assertEquals((Object)"[\"foo\", \"bar\"]", (Object)this.eval("$h.each {|pair| p pair}"));
        Assert.assertEquals((Object)"{\"foo\"=>\"bar\"}", (Object)this.eval("p $h.each {|pair| }"));
        Assert.assertEquals((Object)"[\"foo\", \"bar\"]", (Object)this.eval("$h.each_pair {|pair| p pair}"));
        Assert.assertEquals((Object)"{\"foo\"=>\"bar\"}", (Object)this.eval("p $h.each_pair {|pair| }"));
        Assert.assertEquals((Object)"\"foo\"", (Object)this.eval("$h.each_key {|k| p k}"));
        Assert.assertEquals((Object)"{\"foo\"=>\"bar\"}", (Object)this.eval("p $h.each_key {|k| }"));
        Assert.assertEquals((Object)"\"bar\"", (Object)this.eval("$h.each_value {|v| p v}"));
        Assert.assertEquals((Object)"{\"foo\"=>\"bar\"}", (Object)this.eval("p $h.each_value {|v| }"));
    }

    public void testDeleting() {
        this.eval("$delete_h = {1=>2,3=>4}");
        Assert.assertEquals((Object)"2", (Object)this.eval("p $delete_h.delete(1)"));
        Assert.assertEquals((Object)"{3=>4}", (Object)this.eval("p $delete_h"));
        Assert.assertEquals((Object)"nil", (Object)this.eval("p $delete_h.delete(100)"));
        Assert.assertEquals((Object)"100", (Object)this.eval("$delete_h.delete(100) {|x| p x }"));
        this.eval("$delete_h = {1=>2,3=>4,5=>6}");
        Assert.assertEquals((Object)"{1=>2}", (Object)this.eval("p $delete_h.delete_if {|k,v| k >= 3}"));
        Assert.assertEquals((Object)"{1=>2}", (Object)this.eval("p $delete_h"));
        this.eval("$delete_h.clear");
        Assert.assertEquals((Object)"{}", (Object)this.eval("p $delete_h"));
        this.eval("$delete_h = {1=>2,3=>4,5=>6}");
        Assert.assertEquals((Object)"{1=>2}", (Object)this.eval("p $delete_h.reject {|k,v| k >= 3}"));
        Assert.assertEquals((Object)"3", (Object)this.eval("p $delete_h.size"));
        this.eval("$delete_h = {1=>2,3=>4,5=>6}");
        this.eval("p $delete_h");
        Assert.assertEquals((Object)"{1=>2}", (Object)this.eval("p $delete_h.reject! {|k,v| k >= 3}"));
        Assert.assertEquals((Object)"1", (Object)this.eval("p $delete_h.size"));
        Assert.assertEquals((Object)"nil", (Object)this.eval("p $delete_h.reject! {|k,v| false}"));
    }

    public void testDefault() {
        Assert.assertEquals((Object)"nil", (Object)this.eval("p $h['njet']"));
        Assert.assertEquals((Object)"nil", (Object)this.eval("p $h.default"));
        this.eval("$h.default = 'missing'");
        Assert.assertEquals((Object)"\"missing\"", (Object)this.eval("p $h['njet']"));
        Assert.assertEquals((Object)"\"missing\"", (Object)this.eval("p $h.default"));
    }

    public void testRestructuring() {
        this.eval("$h_sort = {\"a\"=>20,\"b\"=>30,\"c\"=>10}");
        Assert.assertEquals((Object)"[[\"a\", 20], [\"b\", 30], [\"c\", 10]]", (Object)this.eval("p $h_sort.sort"));
        Assert.assertEquals((Object)"[[\"c\", 10], [\"a\", 20], [\"b\", 30]]", (Object)this.eval("p $h_sort.sort {|a,b| a[1]<=>b[1]}"));
        this.eval("$h_invert = {\"n\"=>100,\"y\"=>300,\"d\"=>200,\"a\"=>0}");
        Assert.assertEquals((Object)"[[0, \"a\"], [100, \"n\"], [200, \"d\"], [300, \"y\"]]", (Object)this.eval("p $h_invert.invert.sort"));
    }
}

