/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyClass
extends RubyModule {
    private boolean singleton = false;
    static /* synthetic */ Class class$org$jruby$RubyClass;

    private RubyClass(Ruby ruby) {
        this(ruby, null, null);
    }

    protected RubyClass(Ruby ruby, RubyClass superClass) {
        this(ruby, null, superClass);
    }

    public RubyClass(Ruby ruby, RubyClass rubyClass, RubyClass superClass) {
        super(ruby, rubyClass, superClass);
    }

    public static RubyClass nilClass(Ruby ruby) {
        return new RubyClass(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    protected void testFrozen() {
        if (this.isFrozen()) {
            if (this.isSingleton()) {
                throw new RubyFrozenException(this.getRuntime(), "object");
            }
            throw new RubyFrozenException(this.getRuntime(), "class");
        }
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public static void createClassClass(RubyClass classClass) {
        classClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyClass == null ? (class$org$jruby$RubyClass = RubyClass.class$("org.jruby.RubyClass")) : class$org$jruby$RubyClass, "newInstance"));
        classClass.defineMethod("new", CallbackFactory.getOptMethod(class$org$jruby$RubyClass == null ? (class$org$jruby$RubyClass = RubyClass.class$("org.jruby.RubyClass")) : class$org$jruby$RubyClass, "newInstance"));
        classClass.defineMethod("superclass", CallbackFactory.getMethod(class$org$jruby$RubyClass == null ? (class$org$jruby$RubyClass = RubyClass.class$("org.jruby.RubyClass")) : class$org$jruby$RubyClass, "superclass"));
        classClass.defineSingletonMethod("inherited", CallbackFactory.getNilMethod(1));
        classClass.undefMethod("module_function");
    }

    public void inheritedBy(RubyClass superType) {
        if (superType == null) {
            superType = this.runtime.getClasses().getObjectClass();
        }
        superType.callMethod("inherited", this);
    }

    public RubyClass getSingletonClassClone() {
        if (!this.isSingleton()) {
            return this;
        }
        RubyClass clone = RubyClass.newClass(this.getRuntime(), this.getInternalClass(), this.getSuperClass());
        clone.setupClone(this);
        clone.setInstanceVariables(this.getInstanceVariables().cloneRubyMap());
        Iterator iter = this.getMethods().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ICallable value = (ICallable)entry.getValue();
            clone.getMethods().put(entry.getKey(), value);
        }
        clone.setSingleton(true);
        return clone;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public RubyClass getInternalClass() {
        RubyClass type = super.getInternalClass();
        return type != null ? type : this.getRuntime().getClasses().getClassClass();
    }

    public RubyClass getRealClass() {
        if (this.isSingleton() || this.isIncluded()) {
            return this.getSuperClass().getRealClass();
        }
        return this;
    }

    public void attachSingletonClass(IRubyObject object) {
        if (this.isSingleton()) {
            this.setInstanceVariable("__atached__", object);
        }
    }

    public RubyClass newSingletonClass() {
        RubyClass newClass = RubyClass.newClass(this.getRuntime(), this);
        newClass.setSingleton(true);
        return newClass;
    }

    public static RubyClass newClass(Ruby ruby, RubyClass superClass) {
        return new RubyClass(ruby, ruby.getClasses().getClassClass(), superClass);
    }

    public static RubyClass newClass(Ruby ruby, RubyClass rubyClass, RubyClass superClass) {
        return new RubyClass(ruby, rubyClass, superClass);
    }

    public IRubyObject newInstance(IRubyObject[] args) {
        if (this.isSingleton()) {
            throw new TypeError(this.getRuntime(), "can't create instance of virtual class");
        }
        IRubyObject obj = this.getRuntime().getFactory().newObject(this);
        obj.callInit(args);
        return obj;
    }

    public static RubyModule newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyClass superClass = recv.getRuntime().getClasses().getObjectClass();
        if (args.length >= 1) {
            superClass = (RubyClass)args[0];
        }
        if (superClass.isSingleton()) {
            throw new TypeError(recv.getRuntime(), "Can't make subclass of virtual class.");
        }
        RubyClass newClass = RubyClass.newClass(recv.getRuntime(), superClass);
        newClass.makeMetaClass(superClass.getInternalClass());
        newClass.callInit(args);
        newClass.inheritedBy(superClass);
        return newClass;
    }

    public RubyClass superclass() {
        RubyClass superClass = this.getSuperClass();
        while (superClass != null && superClass.isIncluded()) {
            superClass = superClass.getSuperClass();
        }
        return superClass != null ? superClass : RubyClass.nilClass(this.getRuntime());
    }

    public static IRubyObject inherited(RubyClass recv) {
        throw new TypeError(recv.getRuntime(), "can't make subclass of Class");
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(99);
        output.dumpString(this.getClassname().toString());
    }

    public static RubyModule unmarshalFrom(UnmarshalStream output) throws IOException {
        return (RubyClass)RubyModule.unmarshalFrom(output);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

