/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class RubyFloat
extends RubyNumeric {
    private static final NumberFormat usFormat = NumberFormat.getInstance(Locale.US);
    private double value;
    static /* synthetic */ Class class$org$jruby$RubyFloat;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyFloat(Ruby ruby) {
        this(ruby, 0.0);
    }

    public RubyFloat(Ruby ruby, double value) {
        super(ruby, ruby.getClasses().getFloatClass());
        this.value = value;
    }

    public Class getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return (long)this.value;
    }

    public static RubyClass createFloatClass(Ruby ruby) {
        RubyClass floatClass = ruby.defineClass("Float", ruby.getClasses().getNumericClass());
        floatClass.defineSingletonMethod("induced_from", CallbackFactory.getSingletonMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "induced_from", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("to_i", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "to_i"));
        floatClass.defineMethod("to_f", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "to_f"));
        floatClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "to_s"));
        floatClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_plus", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_minus", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_mul", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("/", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_div", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("%", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_mod", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("**", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_pow", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_equal", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_cmp", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod(">", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_gt", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod(">=", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_ge", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("<", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_lt", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("<=", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_le", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFloat.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        floatClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "hash"));
        floatClass.defineMethod("floor", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "floor"));
        floatClass.defineMethod("ceil", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "ceil"));
        floatClass.defineMethod("round", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "round"));
        floatClass.defineMethod("truncate", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "truncate"));
        return floatClass;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, new Double(this.value).hashCode());
    }

    public static RubyFloat newFloat(Ruby ruby, double value) {
        return new RubyFloat(ruby, value);
    }

    public static RubyFloat induced_from(IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyFloat) {
            return (RubyFloat)number;
        }
        if (number instanceof RubyInteger) {
            return (RubyFloat)number.callMethod("to_f");
        }
        throw new TypeError(recv.getRuntime(), "failed to convert " + number.getInternalClass() + "into Float");
    }

    public RubyArray coerce(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyArray.newArray(this.getRuntime(), RubyFloat.newFloat(this.getRuntime(), other.getDoubleValue()), this);
    }

    public RubyInteger ceil() {
        double val = Math.ceil(this.getDoubleValue());
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            return RubyBignum.newBignum(this.getRuntime(), val);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), (long)val);
    }

    public RubyInteger floor() {
        double val = Math.floor(this.getDoubleValue());
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            return RubyBignum.newBignum(this.getRuntime(), val);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), (long)val);
    }

    public RubyInteger round() {
        double val = Math.round(this.getDoubleValue());
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            return RubyBignum.newBignum(this.getRuntime(), val);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), (long)val);
    }

    public RubyInteger truncate() {
        if (this.getDoubleValue() > 0.0) {
            return this.floor();
        }
        if (this.getDoubleValue() < 0.0) {
            return this.ceil();
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public RubyNumeric op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    public RubyNumeric op_plus(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() + other.getDoubleValue());
    }

    public RubyNumeric op_minus(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() - other.getDoubleValue());
    }

    public RubyNumeric op_mul(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() * other.getDoubleValue());
    }

    public RubyNumeric op_div(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() / other.getDoubleValue());
    }

    public RubyNumeric op_mod(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() % other.getDoubleValue());
    }

    public RubyNumeric op_pow(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.getDoubleValue(), other.getDoubleValue()));
    }

    public RubyBoolean op_equal(IRubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return this.getRuntime().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue((RubyNumeric)other) == 0);
    }

    public RubyNumeric op_cmp(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFixnum.newFixnum(this.getRuntime(), this.compareValue(other));
    }

    public RubyBoolean op_gt(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) > 0);
    }

    public RubyBoolean op_ge(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) >= 0);
    }

    public RubyBoolean op_lt(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) < 0);
    }

    public RubyBoolean op_le(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) <= 0);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuntime(), usFormat.format(this.getValue()));
    }

    public RubyFloat to_f() {
        return this;
    }

    public RubyInteger to_i() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue());
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(102);
        String strValue = this.toString();
        double value = this.getValue();
        if (Double.isInfinite(value)) {
            strValue = value < 0.0 ? "-inf" : "inf";
        } else if (Double.isNaN(value)) {
            strValue = "nan";
        }
        output.dumpString(strValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        usFormat.setMinimumFractionDigits(1);
    }
}

