/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyGlobal {
    public static void createGlobals(Ruby ruby) {
        IRubyObject version = RubyString.newString(ruby, "1.6.7").freeze();
        IRubyObject release = RubyString.newString(ruby, "2002-08-08").freeze();
        IRubyObject platform = RubyString.newString(ruby, "java").freeze();
        ruby.defineGlobalConstant("RUBY_VERSION", version);
        ruby.defineGlobalConstant("RUBY_RELEASE_DATE", release);
        ruby.defineGlobalConstant("RUBY_PLATFORM", platform);
        ruby.defineGlobalConstant("VERSION", version);
        ruby.defineGlobalConstant("RELEASE_DATE", release);
        ruby.defineGlobalConstant("PLATFORM", platform);
        ruby.defineVariable(new StringGlobalVariable(ruby, "$/", RubyString.newString(ruby, "\n")));
        ruby.defineVariable(new StringGlobalVariable(ruby, "$\\", ruby.getNil()));
        ruby.defineVariable(new StringGlobalVariable(ruby, "$,", ruby.getNil()));
        ruby.defineVariable(new LineNumberGlobalVariable(ruby, "$.", RubyFixnum.one(ruby)));
        ruby.defineVariable(new LastlineGlobalVariable(ruby, "$_"));
        ruby.defineVariable(new ErrorInfoGlobalVariable(ruby, "$!", ruby.getNil()));
        ruby.defineVariable(new SafeGlobalVariable(ruby, "$SAFE"));
        ruby.defineVariable(new BacktraceGlobalVariable(ruby, "$@"));
        IRubyObject stdin = RubyIO.stdin(ruby, ruby.getClasses().getIoClass(), System.in);
        IRubyObject stdout = RubyIO.stdout(ruby, ruby.getClasses().getIoClass(), System.out);
        IRubyObject stderr = RubyIO.stderr(ruby, ruby.getClasses().getIoClass(), System.err);
        ruby.defineVariable(new InputGlobalVariable(ruby, "$stdin", stdin));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$stdout", stdout));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$stderr", stderr));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$>", stdout));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$defout", stdout));
        ruby.defineGlobalConstant("STDIN", stdin);
        ruby.defineGlobalConstant("STDOUT", stdout);
        ruby.defineGlobalConstant("STDERR", stderr);
        ruby.defineVariable(new LoadedFeatures(ruby, "$\""));
        ruby.defineReadonlyVariable("$*", RubyArray.newArray(ruby));
        ruby.defineVariable(new LoadPath(ruby, "$:"));
        ruby.defineVariable(new LoadPath(ruby, "$-I"));
        ruby.defineVariable(new LoadPath(ruby, "$LOAD_PATH"));
        RubyArgsFile argsFile = new RubyArgsFile(ruby);
        argsFile.initArgsFile();
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby runtime, String name) {
            super(runtime, name, null);
        }

        public IRubyObject get() {
            return RubyArray.newArray(this.ruby, this.ruby.getLoadService().getLoadedFeatures());
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby runtime, String name) {
            super(runtime, name, null);
        }

        public IRubyObject get() {
            return RubyArray.newArray(this.ruby, this.ruby.getLoadService().getLoadPath());
        }
    }

    private static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby ruby, String name, IRubyObject value) {
            super(ruby, name, value);
        }

        public IRubyObject set(IRubyObject value) {
            if (value == this.get()) {
                return value;
            }
            if (value instanceof RubyIO) {
                ((RubyIO)value).checkWriteable();
            }
            if (!value.respondsTo("write")) {
                throw new TypeError(this.ruby, this.name() + " must have write method, " + value.getType().toName() + " given");
            }
            return super.set(value);
        }
    }

    private static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby ruby, String name, IRubyObject value) {
            super(ruby, name, value);
        }

        public IRubyObject set(IRubyObject value) {
            if (value == this.get()) {
                return value;
            }
            if (value instanceof RubyIO) {
                ((RubyIO)value).checkReadable();
            }
            return super.set(value);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby ruby, String name) {
            super(ruby, name, null);
        }

        public IRubyObject get() {
            return this.ruby.getLastline();
        }

        public IRubyObject set(IRubyObject value) {
            this.ruby.setLastline(value);
            return value;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby ruby, String name) {
            super(ruby, name, null);
        }

        public IRubyObject get() {
            IRubyObject errorInfo = this.ruby.getGlobalVar("$!");
            return errorInfo.isNil() ? this.ruby.getNil() : errorInfo.callMethod("backtrace");
        }

        public IRubyObject set(IRubyObject value) {
            if (this.ruby.getGlobalVar("$!").isNil()) {
                throw new ArgumentError(this.ruby, "$! not set.");
            }
            this.ruby.getGlobalVar("$!").callMethod("set_backtrace", value);
            return value;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby ruby, String name) {
            super(ruby, name, null);
        }

        public IRubyObject get() {
            return RubyFixnum.newFixnum(this.ruby, this.ruby.getSafeLevel());
        }

        public IRubyObject set(IRubyObject value) {
            int level = RubyFixnum.fix2int(value);
            if (level < this.ruby.getSafeLevel()) {
                throw new SecurityException("tried to downgrade level from " + this.ruby.getSafeLevel() + " to " + level);
            }
            this.ruby.setSafeLevel(level);
            return value;
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby ruby, String name, IRubyObject value) {
            super(ruby, name, value);
        }

        public IRubyObject set(IRubyObject value) {
            if (!(value instanceof RubyString)) {
                throw new TypeError(this.ruby, "value of " + this.name() + " must be a String");
            }
            return super.set(value);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby ruby, String name, IRubyObject value) {
            super(ruby, name, value);
        }

        public IRubyObject set(IRubyObject value) {
            if (!value.isNil() && !value.isKindOf(this.ruby.getClasses().getExceptionClass())) {
                throw new TypeError(this.ruby, "assigning non-exception to $!");
            }
            return super.set(value);
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby ruby, String name, RubyFixnum value) {
            super(ruby, name, value);
        }

        public IRubyObject set(IRubyObject value) {
            ((RubyArgsFile)this.ruby.getGlobalVar("$<")).setCurrentLineNumber(RubyFixnum.fix2int(value));
            return super.set(value);
        }
    }
}

