/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.EOFError;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThrowJump;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyKernel {
    static /* synthetic */ Class class$org$jruby$RubyKernel;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyString;

    public static RubyModule createKernelModule(Ruby ruby) {
        RubyModule kernelModule = ruby.defineModule("Kernel");
        kernelModule.defineModuleFunction("open", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "open"));
        kernelModule.defineModuleFunction("format", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sprintf"));
        kernelModule.defineModuleFunction("gets", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "gets"));
        kernelModule.defineModuleFunction("p", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "p"));
        kernelModule.defineModuleFunction("print", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "print"));
        kernelModule.defineModuleFunction("printf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "printf"));
        kernelModule.defineModuleFunction("puts", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "puts"));
        kernelModule.defineModuleFunction("readline", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "readline"));
        kernelModule.defineModuleFunction("readlines", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "readlines"));
        kernelModule.defineModuleFunction("sprintf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sprintf"));
        kernelModule.defineModuleFunction("gsub!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "gsub_bang"));
        kernelModule.defineModuleFunction("gsub", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "gsub"));
        kernelModule.defineModuleFunction("sub!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sub_bang"));
        kernelModule.defineModuleFunction("sub", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sub"));
        kernelModule.defineModuleFunction("chop!", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chop_bang"));
        kernelModule.defineModuleFunction("chop", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chop"));
        kernelModule.defineModuleFunction("chomp!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chomp_bang"));
        kernelModule.defineModuleFunction("chomp", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "chomp"));
        kernelModule.defineModuleFunction("split", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "split"));
        kernelModule.defineModuleFunction("scan", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "scan", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyKernel.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        kernelModule.defineModuleFunction("load", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "load", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineModuleFunction("raise", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "raise"));
        kernelModule.defineModuleFunction("require", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "require", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineModuleFunction("global_variables", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "global_variables"));
        kernelModule.defineModuleFunction("local_variables", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "local_variables"));
        kernelModule.defineModuleFunction("block_given?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "block_given"));
        kernelModule.defineModuleFunction("iterator?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "block_given"));
        kernelModule.defineModuleFunction("proc", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "proc"));
        kernelModule.defineModuleFunction("loop", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "loop"));
        kernelModule.defineModuleFunction("eval", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "eval", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineModuleFunction("caller", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "caller"));
        kernelModule.defineModuleFunction("catch", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "rbCatch", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyKernel.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        kernelModule.defineModuleFunction("throw", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "rbThrow", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyKernel.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        kernelModule.defineModuleFunction("singleton_method_added", CallbackFactory.getNilMethod(1));
        kernelModule.defineModuleFunction("set_trace_func", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "set_trace_func", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyKernel.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        kernelModule.defineModuleFunction("sleep", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "sleep", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyKernel.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        kernelModule.defineModuleFunction("`", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "backquote", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyKernel.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineModuleFunction("exit", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "exit"));
        kernelModule.defineModuleFunction("srand", CallbackFactory.getSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "srand", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyKernel.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        kernelModule.defineModuleFunction("rand", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyKernel == null ? (class$org$jruby$RubyKernel = RubyKernel.class$("org.jruby.RubyKernel")) : class$org$jruby$RubyKernel, "rand"));
        kernelModule.defineAlias("lambda", "proc");
        return kernelModule;
    }

    public static IRubyObject open(IRubyObject recv, IRubyObject[] args) {
        if (args[0].toString().startsWith("|")) {
            return recv.getRuntime().getNil();
        }
        return RubyFile.open(recv.getRuntime().getClasses().getFileClass(), args);
    }

    public static RubyString gets(IRubyObject recv, IRubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)recv.getRuntime().getGlobalVar("$<");
        RubyString line = argsFile.internalGets(args);
        recv.getRuntime().setLastline(line);
        return line;
    }

    public static IRubyObject p(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVar("$>");
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                defout.callMethod("write", args[i].callMethod("inspect"));
                defout.callMethod("write", RubyString.newString(recv.getRuntime(), "\n"));
            }
            ++i;
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject puts(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVar("$>");
        RubyIO.puts(defout, args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject print(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVar("$>");
        RubyIO.print(defout, args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject printf(IRubyObject recv, IRubyObject[] args) {
        if (args.length != 0) {
            IRubyObject defout = recv.getRuntime().getGlobalVar("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                IRubyObject[] newArgs = new IRubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                args = newArgs;
            }
            RubyIO.printf(defout, args);
        }
        return recv.getRuntime().getNil();
    }

    public static RubyString readline(IRubyObject recv, IRubyObject[] args) {
        RubyString line = RubyKernel.gets(recv, args);
        if (line.isNil()) {
            throw new EOFError(recv.getRuntime());
        }
        return line;
    }

    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)recv.getRuntime().getGlobalVar("$<");
        RubyArray lines = RubyArray.newArray(recv.getRuntime());
        RubyString line = argsFile.internalGets(args);
        while (!line.isNil()) {
            lines.append(line);
            line = argsFile.internalGets(args);
        }
        return lines;
    }

    private static RubyString getLastlineString(Ruby ruby) {
        IRubyObject line = ruby.getLastline();
        if (line.isNil()) {
            throw new TypeError(ruby, "$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw new TypeError(ruby, "$_ value need to be String (" + line.getInternalClass().toName() + " given).");
        }
        return (RubyString)line;
    }

    public static IRubyObject sub_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).sub_bang(args);
    }

    public static IRubyObject sub(IRubyObject recv, IRubyObject[] args) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.sub_bang(args).isNil()) {
            recv.getRuntime().setLastline(str);
        }
        return str;
    }

    public static IRubyObject gsub_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).gsub_bang(args);
    }

    public static IRubyObject gsub(IRubyObject recv, IRubyObject[] args) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.gsub_bang(args).isNil()) {
            recv.getRuntime().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chop_bang(IRubyObject recv) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chop_bang();
    }

    public static IRubyObject chop(IRubyObject recv) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        if (str.getValue().length() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            recv.getRuntime().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chomp_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chomp_bang(args);
    }

    public static IRubyObject chomp(IRubyObject recv, IRubyObject[] args) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        recv.getRuntime().setLastline(dup);
        return str;
    }

    public static IRubyObject split(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).split(args);
    }

    public static IRubyObject scan(IRubyObject recv, IRubyObject pattern) {
        return RubyKernel.getLastlineString(recv.getRuntime()).scan(pattern);
    }

    public static IRubyObject sleep(IRubyObject recv, IRubyObject seconds) {
        try {
            Thread.sleep((long)(RubyNumeric.numericValue(seconds).getDoubleValue() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return recv;
    }

    public static IRubyObject exit(IRubyObject recv, IRubyObject[] args) {
        int status = 0;
        if (args.length > 0) {
            status = RubyNumeric.fix2int(args[0]);
        }
        System.exit(status);
        return recv.getRuntime().getNil();
    }

    public static RubyArray global_variables(IRubyObject recv) {
        RubyArray globalVariables = RubyArray.newArray(recv.getRuntime());
        Iterator iter = recv.getRuntime().globalVariableNames();
        while (iter.hasNext()) {
            String globalVariableName = (String)iter.next();
            globalVariables.append(RubyString.newString(recv.getRuntime(), globalVariableName));
        }
        return globalVariables;
    }

    public static RubyArray local_variables(IRubyObject recv) {
        RubyArray localVariables = RubyArray.newArray(recv.getRuntime());
        if (recv.getRuntime().getScope().getLocalNames() != null) {
            int i = 2;
            while (i < recv.getRuntime().getScope().getLocalNames().size()) {
                if (recv.getRuntime().getScope().getLocalNames().get(i) != null) {
                    localVariables.append(RubyString.newString(recv.getRuntime(), (String)recv.getRuntime().getScope().getLocalNames().get(i)));
                }
                ++i;
            }
        }
        Iterator dynamicNames = recv.getRuntime().getDynamicNames().iterator();
        while (dynamicNames.hasNext()) {
            String name = (String)dynamicNames.next();
            localVariables.append(RubyString.newString(recv.getRuntime(), name));
        }
        return localVariables;
    }

    public static RubyBoolean block_given(IRubyObject recv) {
        return RubyBoolean.newBoolean(recv.getRuntime(), recv.getRuntime().isFBlockGiven());
    }

    public static IRubyObject sprintf(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(recv.getRuntime(), "sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = RubyArray.newArray(recv.getRuntime(), args);
        newArgs.shift();
        return str.format(newArgs);
    }

    public static IRubyObject raise(IRubyObject recv, IRubyObject[] args) {
        switch (args.length) {
            case 0: 
            case 1: {
                if (args[0] instanceof RubyException) {
                    throw new RaiseException((RubyException)args[0]);
                }
                throw new RaiseException(RubyException.newInstance(recv.getRuntime().getExceptions().getRuntimeError(), args));
            }
            case 2: {
                RubyException excptn = (RubyException)args[0].callMethod("exception", args[1]);
                throw new RaiseException(excptn);
            }
        }
        throw new ArgumentError(recv.getRuntime(), "wrong # of arguments");
    }

    public static IRubyObject require(IRubyObject recv, RubyString file) {
        if (recv.getRuntime().getLoadService().require(file.toString())) {
            return recv.getRuntime().getTrue();
        }
        return recv.getRuntime().getFalse();
    }

    public static IRubyObject load(IRubyObject recv, RubyString file) {
        if (recv.getRuntime().getLoadService().load(file.toString())) {
            return recv.getRuntime().getTrue();
        }
        return recv.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject eval(IRubyObject recv, RubyString src, IRubyObject[] args) {
        IRubyObject scope = args.length > 0 ? args[0] : recv.getRuntime().getNil();
        String file = "(eval)";
        int line = 1;
        if (args.length > 1) {
            file = args[1].toString();
        }
        if (args.length > 2) {
            line = RubyFixnum.fix2int(args[2]);
        }
        src.checkSafeString();
        if (scope.isNil() && recv.getRuntime().getFrameStack().getPrevious() != null) {
            IRubyObject iRubyObject;
            try {
                recv.getRuntime().getFrameStack().push(recv.getRuntime().getFrameStack().getPrevious());
                iRubyObject = recv.eval(src, scope, file, line);
                Object var8_7 = null;
                recv.getRuntime().getFrameStack().pop();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                recv.getRuntime().getFrameStack().pop();
                throw throwable;
            }
            return iRubyObject;
        }
        return recv.eval(src, scope, file, line);
    }

    public static IRubyObject caller(IRubyObject recv, IRubyObject[] args) {
        int level;
        int n = level = args.length > 0 ? RubyFixnum.fix2int(args[0]) : 1;
        if (level < 0) {
            throw new ArgumentError(recv.getRuntime(), "negative level(" + level + ')');
        }
        return RaiseException.createBacktrace(recv.getRuntime(), level);
    }

    public static IRubyObject rbCatch(IRubyObject recv, IRubyObject tag) {
        try {
            return recv.getRuntime().yield(tag);
        }
        catch (ThrowJump throwJump) {
            if (throwJump.getTag().equals(tag.toId())) {
                return throwJump.getValue();
            }
            throw throwJump;
        }
    }

    public static IRubyObject rbThrow(IRubyObject recv, IRubyObject tag, IRubyObject[] args) {
        throw new ThrowJump(tag.toId(), args.length > 0 ? args[0] : recv.getRuntime().getNil());
    }

    public static IRubyObject set_trace_func(IRubyObject recv, IRubyObject trace_func) {
        if (trace_func.isNil()) {
            recv.getRuntime().getRuntime().setTraceFunction(null);
        } else if (!(trace_func instanceof RubyProc)) {
            throw new TypeError(recv.getRuntime(), "trace_func needs to be Proc.");
        }
        recv.getRuntime().getRuntime().setTraceFunction((RubyProc)trace_func);
        return trace_func;
    }

    public static RubyProc proc(IRubyObject recv) {
        return RubyProc.newProc(recv.getRuntime(), recv.getRuntime().getClasses().getProcClass());
    }

    public static IRubyObject loop(IRubyObject recv) {
        while (true) {
            recv.getRuntime().yield(recv.getRuntime().getNil());
            Thread.yield();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static IRubyObject backquote(IRubyObject recv, RubyString aString) {
        try {
            String line;
            Process aProcess;
            String lShellProp = System.getProperty("jruby.shell");
            String lCommand = aString.toString();
            String lSwitch = "-c";
            if (lShellProp != null) {
                if (!lShellProp.endsWith("sh")) {
                    lSwitch = "/c";
                }
                aProcess = Runtime.getRuntime().exec(new String[]{lShellProp, lSwitch, lCommand});
            } else {
                aProcess = Runtime.getRuntime().exec(lCommand);
            }
            StringBuffer sb = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
            while ((line = reader.readLine()) != null) {
                void var8_9;
                sb.append((String)var8_9).append('\n');
            }
            aProcess.waitFor();
            return RubyString.newString(recv.getRuntime(), sb.toString());
        }
        catch (Exception excptn) {
            excptn.printStackTrace();
            return RubyString.newString(recv.getRuntime(), "");
        }
    }

    public static RubyInteger srand(IRubyObject recv, IRubyObject arg) {
        long oldRandomSeed = recv.getRuntime().randomSeed;
        RubyInteger integerSeed = (RubyInteger)arg.convertToType("Integer", "to_int", true);
        recv.getRuntime().randomSeed = integerSeed.getLongValue();
        recv.getRuntime().random.setSeed(recv.getRuntime().randomSeed);
        return RubyFixnum.newFixnum(recv.getRuntime(), oldRandomSeed);
    }

    public static RubyNumeric rand(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            double result = recv.getRuntime().random.nextDouble();
            return RubyFloat.newFloat(recv.getRuntime(), result);
        }
        if (args.length == 1) {
            RubyInteger integerCeil = (RubyInteger)args[0].convertToType("Integer", "to_int", true);
            long ceil = integerCeil.getLongValue();
            if (ceil > Integer.MAX_VALUE) {
                throw new NotImplementedError("Random values larger than Integer.MAX_VALUE not supported");
            }
            return RubyFixnum.newFixnum(recv.getRuntime(), recv.getRuntime().random.nextInt((int)ceil));
        }
        throw new ArgumentError(recv.getRuntime(), "wrong # of arguments(" + args.length + " for 1)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

