/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.AttrSetNode;
import org.jruby.ast.InstVarNode;
import org.jruby.internal.runtime.methods.CallbackMethod;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMethod
extends RubyObject {
    private RubyClass receiverClass;
    private IRubyObject receiver;
    private String methodId;
    private ICallable method;
    private RubyClass originalClass;
    private String originalId;
    static /* synthetic */ Class class$org$jruby$RubyMethod;

    public RubyMethod(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby ruby) {
        RubyClass methodClass = ruby.defineClass("Method", ruby.getClasses().getObjectClass());
        methodClass.defineMethod("arity", CallbackFactory.getMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "arity"));
        methodClass.defineMethod("[]", CallbackFactory.getOptMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "call"));
        methodClass.defineMethod("call", CallbackFactory.getOptMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "call"));
        methodClass.defineMethod("to_proc", CallbackFactory.getMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "to_proc"));
        return methodClass;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public void setMethodId(String methodId) {
        this.methodId = methodId;
    }

    public RubyClass getOriginalClass() {
        return this.originalClass;
    }

    public void setOriginalClass(RubyClass originalClass) {
        this.originalClass = originalClass;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public IRubyObject getReceiver() {
        return this.receiver;
    }

    public void setReceiver(IRubyObject receiver) {
        this.receiver = receiver;
    }

    public RubyClass getReceiverClass() {
        return this.receiverClass;
    }

    public void setReceiverClass(RubyClass receiverClass) {
        this.receiverClass = receiverClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(IRubyObject[] args) {
        IRubyObject iRubyObject;
        if (args == null) {
            args = new IRubyObject[]{};
        }
        this.getRuntime().getIterStack().push(this.getRuntime().isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
        try {
            iRubyObject = this.getReceiverClass().call0(this.getReceiver(), this.getMethodId(), args, this.getMethod(), false);
            Object var4_3 = null;
            this.getRuntime().getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getRuntime().getIterStack().pop();
            throw throwable;
        }
        return iRubyObject;
    }

    public RubyFixnum arity() {
        if (this.method instanceof EvaluateMethod) {
            if (((EvaluateMethod)this.method).getNode() instanceof AttrSetNode) {
                return RubyFixnum.one(this.getRuntime());
            }
            if (((EvaluateMethod)this.method).getNode() instanceof InstVarNode) {
                return RubyFixnum.zero(this.getRuntime());
            }
        } else {
            if (this.method instanceof DefaultMethod) {
                ArgsNode args = ((DefaultMethod)this.method).getArgsNode();
                if (args == null) {
                    return RubyFixnum.zero(this.getRuntime());
                }
                int n = args.getArgsCount();
                if (args.getOptArgs() != null || args.getRestArg() >= 0) {
                    n = -n - 1;
                }
                return RubyFixnum.newFixnum(this.getRuntime(), n);
            }
            if (this.method instanceof CallbackMethod) {
                return RubyFixnum.newFixnum(this.getRuntime(), ((CallbackMethod)this.method).getCallback().getArity());
            }
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -1L);
    }

    public ICallable getMethod() {
        return this.method;
    }

    public void setMethod(ICallable method) {
        this.method = method;
    }

    public IRubyObject to_proc() {
        return this.runtime.iterate(CallbackFactory.getSingletonMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "mproc"), null, CallbackFactory.getBlockMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "bmcall"), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject mproc(IRubyObject recv) {
        RubyProc rubyProc;
        try {
            recv.getRuntime().getIterStack().push(Iter.ITER_CUR);
            recv.getRuntime().getFrameStack().push();
            rubyProc = RubyKernel.proc(recv);
            Object var3_2 = null;
            recv.getRuntime().getFrameStack().pop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            recv.getRuntime().getFrameStack().pop();
            recv.getRuntime().getIterStack().pop();
            throw throwable;
        }
        recv.getRuntime().getIterStack().pop();
        return rubyProc;
    }

    public static IRubyObject bmcall(IRubyObject blockArg, IRubyObject arg1, IRubyObject self) {
        if (blockArg instanceof RubyArray) {
            return ((RubyMethod)arg1).call(((RubyArray)blockArg).toJavaArray());
        }
        return ((RubyMethod)arg1).call(new IRubyObject[]{blockArg});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Nil
    extends RubyMethod {
        public Nil(Ruby ruby) {
            super(ruby, ruby.getClasses().getNilClass());
        }
    }
}

