/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RangeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    static /* synthetic */ Class class$org$jruby$RubyRange;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyRange(Ruby ruby) {
        super(ruby, ruby.getRubyClass("Range"));
    }

    public void init(IRubyObject begin, IRubyObject end, RubyBoolean isExclusive) {
        if (!(begin instanceof RubyFixnum) || !(end instanceof RubyFixnum)) {
            try {
                begin.callMethod("<=>", end);
            }
            catch (RaiseException rExcptn) {
                throw new ArgumentError(this.getRuntime(), "bad value for range");
            }
        }
        this.begin = begin;
        this.end = end;
        this.isExclusive = isExclusive.isTrue();
    }

    public static RubyClass createRangeClass(Ruby ruby) {
        RubyClass rangeClass = ruby.defineClass("Range", ruby.getClasses().getObjectClass());
        rangeClass.includeModule(ruby.getClasses().getEnumerableModule());
        rangeClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "equal", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyRange.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        rangeClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "op_eqq", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyRange.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        rangeClass.defineMethod("first", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "first"));
        rangeClass.defineMethod("begin", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "first"));
        rangeClass.defineMethod("last", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "last"));
        rangeClass.defineMethod("end", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "last"));
        rangeClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "inspect"));
        rangeClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "inspect"));
        rangeClass.defineMethod("exclude_end?", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "exclude_end_p"));
        rangeClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "length"));
        rangeClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "length"));
        rangeClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "each"));
        rangeClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "initialize"));
        return rangeClass;
    }

    public long[] getBeginLength(long limit, boolean truncate, boolean isStrict) {
        long beginLong = RubyNumeric.num2long(this.begin);
        long endLong = RubyNumeric.num2long(this.end);
        if (!this.isExclusive) {
            ++endLong;
        }
        if (beginLong < 0L && (beginLong += limit) < 0L) {
            if (isStrict) {
                throw new RangeError(this.runtime, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && beginLong > limit) {
            if (isStrict) {
                throw new RangeError(this.runtime, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && endLong > limit) {
            endLong = limit;
        }
        if ((endLong < 0L || !this.isExclusive && endLong == 0L) && (endLong += limit) < 0L) {
            if (isStrict) {
                throw new RangeError(this.runtime, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (beginLong > endLong) {
            if (isStrict) {
                throw new RangeError(this.runtime, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        return new long[]{beginLong, endLong - beginLong};
    }

    public static RubyRange newRange(Ruby ruby, IRubyObject begin, IRubyObject end, boolean isExclusive) {
        RubyRange range = new RubyRange(ruby);
        range.init(begin, end, isExclusive ? ruby.getTrue() : ruby.getFalse());
        return range;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        if (args.length == 3) {
            this.init(args[0], args[1], (RubyBoolean)args[2]);
        } else if (args.length == 2) {
            this.init(args[0], args[1], this.getRuntime().getFalse());
        } else {
            throw new ArgumentError(this.getRuntime(), "Wrong arguments. (anObject, anObject, aBoolean = false) excepted");
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject first() {
        return this.begin;
    }

    public IRubyObject last() {
        return this.end;
    }

    public RubyString inspect() {
        RubyString begStr = (RubyString)this.begin.callMethod("to_s");
        RubyString endStr = (RubyString)this.end.callMethod("to_s");
        begStr.cat(this.isExclusive ? "..." : "..");
        begStr.concat(endStr);
        return begStr;
    }

    public RubyBoolean exclude_end_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isExclusive);
    }

    public RubyFixnum length() {
        long size = 0L;
        if (this.begin.callMethod(">", this.end).isTrue()) {
            return RubyFixnum.newFixnum(this.getRuntime(), 0L);
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            size = ((RubyNumeric)this.end).getLongValue() - ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++size;
            }
        }
        return RubyFixnum.newFixnum(this.getRuntime(), size);
    }

    public RubyBoolean equal(IRubyObject obj) {
        if (!(obj instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)obj;
        boolean result = this.begin.equals(otherRange.begin) && this.end.equals(otherRange.end) && this.isExclusive == otherRange.isExclusive;
        return RubyBoolean.newBoolean(this.getRuntime(), result);
    }

    public RubyBoolean op_eqq(IRubyObject obj) {
        if (this.begin instanceof RubyFixnum && obj instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long o;
            long b = RubyNumeric.fix2long(this.begin);
            if (b <= (o = RubyNumeric.fix2long(obj))) {
                long e = RubyNumeric.fix2long(this.end);
                if (this.isExclusive ? o < e : o <= e) {
                    return this.getRuntime().getTrue();
                }
            }
            return this.getRuntime().getFalse();
        }
        if (this.begin.callMethod("<=", obj).isTrue() && (this.isExclusive ? this.end.callMethod(">", obj).isTrue() : this.end.callMethod(">=", obj).isTrue())) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    /*
     * Unable to fully structure code
     */
    public IRubyObject each() {
        block7: {
            block10: {
                block9: {
                    block8: {
                        if (!(this.begin instanceof RubyFixnum) || !(this.end instanceof RubyFixnum)) break block8;
                        endLong = ((RubyNumeric)this.end).getLongValue();
                        i = ((RubyNumeric)this.begin).getLongValue();
                        if (!this.isExclusive) {
                            ++endLong;
                        }
                        while (i < endLong) {
                            this.getRuntime().yield(RubyFixnum.newFixnum(this.getRuntime(), i));
                            ++i;
                        }
                        break block7;
                    }
                    if (!(this.begin instanceof RubyString)) break block9;
                    ((RubyString)this.begin).upto(this.end, this.isExclusive);
                    break block7;
                }
                if (!this.begin.isKindOf(this.getRuntime().getClasses().getNumericClass())) break block10;
                if (!this.isExclusive) {
                    this.end = this.end.callMethod("+", RubyFixnum.one(this.getRuntime()));
                }
                while (this.begin.callMethod("<", this.end).isTrue()) {
                    this.getRuntime().yield(this.begin);
                    this.begin = this.begin.callMethod("+", RubyFixnum.one(this.getRuntime()));
                }
                break block7;
            }
            v = this.begin;
            if (!this.isExclusive) ** GOTO lbl42
            while (v.callMethod("<", this.end).isTrue()) {
                if (!v.equals(this.end)) {
                    this.getRuntime().yield(v);
                    v = v.callMethod("succ");
                    continue;
                }
                break block7;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                this.getRuntime().yield(v);
                if (v.equals(this.end)) break;
                v = v.callMethod("succ");
lbl42:
                // 2 sources

                ** while (v.callMethod((String)"<=", (IRubyObject)this.end).isTrue())
            }
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

