/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CacheEntry;

public class RubyMethodCache {
    private Ruby ruby;
    private Map methodCache = new HashMap();

    public RubyMethodCache(Ruby ruby) {
        this.ruby = ruby;
    }

    public void saveUndefinedEntry(RubyModule recvClass, String name) {
        this.methodCache.put(this.getKey(recvClass, name), new CacheEntry(name, recvClass));
    }

    public void saveEntry(RubyModule recvClass, String name, CacheEntry entry) {
        this.methodCache.put(this.getKey(recvClass, name), entry);
    }

    public CacheEntry getEntry(RubyModule recvClass, String name) {
        return (CacheEntry)this.methodCache.get(this.getKey(recvClass, name));
    }

    public void clearByName(String name) {
        Iterator iter = this.methodCache.values().iterator();
        while (iter.hasNext()) {
            CacheEntry entry = (CacheEntry)iter.next();
            if (!entry.getName().equals(name)) continue;
            iter.remove();
        }
    }

    public void clear() {
        this.methodCache.clear();
    }

    private EntryKey getKey(RubyModule recvClass, String name) {
        return new EntryKey(recvClass, name);
    }

    private class EntryKey {
        private final RubyModule recvClass;
        private final String name;

        public EntryKey(RubyModule recvClass, String name) {
            this.recvClass = recvClass;
            this.name = name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof EntryKey)) {
                return false;
            }
            EntryKey otherKey = (EntryKey)other;
            return this.name.equals(otherKey.name) && this.recvClass == otherKey.recvClass;
        }

        public int hashCode() {
            return System.identityHashCode(this.recvClass) ^ this.name.hashCode();
        }
    }
}

