/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.bsf;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import java.util.Vector;
import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ReturnJump;
import org.jruby.exceptions.ThrowJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyEngine
extends BSFEngineImpl {
    private Ruby ruby;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jruby$runtime$regexp$GNURegexpAdapter;

    public Object apply(String file, int line, int col, Object funcBody, Vector paramNames, Vector args) {
        ISourcePosition oldPosition = this.ruby.getPosition();
        this.ruby.setPosition(file, line);
        StringBuffer sb = new StringBuffer(((String)funcBody).length() + 100);
        sb.append("def __jruby_bsf_anonymous (");
        int paramLength = paramNames.size();
        int i = 0;
        while (i < paramLength) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paramNames.elementAt(i));
            ++i;
        }
        sb.append(") \n");
        sb.append(funcBody);
        sb.append("\nend\n");
        this.ruby.evalScript(sb.toString(), null);
        IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(this.ruby, args.toArray());
        Object result = JavaUtil.convertRubyToJava(this.ruby, this.ruby.getTopSelf().callMethod("__jruby_bsf_anonymous", rubyArgs));
        this.ruby.setPosition(oldPosition);
        return result;
    }

    public Object eval(String file, int line, int col, Object expr) throws BSFException {
        ISourcePosition oldPosition = this.ruby.getPosition();
        this.ruby.setPosition(file, line);
        try {
            Object result = this.ruby.evalScript((String)expr, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
            this.ruby.setPosition(oldPosition);
            return result;
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file, int line, int col, Object expr) throws BSFException {
        try {
            ISourcePosition oldPosition = this.ruby.getPosition();
            this.ruby.setPosition(file, line);
            this.ruby.evalScript((String)expr, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
            this.ruby.setPosition(oldPosition);
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv, String method, Object[] args) throws BSFException {
        try {
            IRubyObject rubyRecv = recv != null ? JavaUtil.convertJavaToRuby(this.ruby, recv) : this.ruby.getTopSelf();
            IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(this.ruby, args);
            IRubyObject result = rubyRecv.callMethod(method, rubyArgs);
            return JavaUtil.convertRubyToJava(this.ruby, result, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception excptn) {
            JRubyEngine.printException(this.ruby, excptn);
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, excptn.getMessage(), (Throwable)excptn);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.ruby = Ruby.getDefaultInstance(class$org$jruby$runtime$regexp$GNURegexpAdapter == null ? (class$org$jruby$runtime$regexp$GNURegexpAdapter = JRubyEngine.class$("org.jruby.runtime.regexp.GNURegexpAdapter")) : class$org$jruby$runtime$regexp$GNURegexpAdapter);
        int size = declaredBeans.size();
        int i = 0;
        while (i < size) {
            BSFDeclaredBean bean = (BSFDeclaredBean)declaredBeans.elementAt(i);
            this.ruby.defineVariable(new BeanGlobalVariable(this.ruby, bean));
            ++i;
        }
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.ruby.defineVariable(new BeanGlobalVariable(this.ruby, bean));
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.ruby.undefineGlobalVar(bean.name);
    }

    public void handleException(BSFException bsfExcptn) {
        JRubyEngine.printException(this.ruby, (Exception)bsfExcptn.getTargetException());
    }

    private static void printException(Ruby ruby, Exception exception) {
        if (exception instanceof RaiseException) {
            ruby.getRuntime().printError(((RaiseException)exception).getException());
        } else if (exception instanceof ThrowJump) {
            ruby.getRuntime().printError(((ThrowJump)exception).getNameError());
        } else if (exception instanceof BreakJump) {
            ruby.getRuntime().getErrorStream().println("break without block.");
        } else if (exception instanceof ReturnJump) {
            ruby.getRuntime().getErrorStream().println("return without block.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BeanGlobalVariable
    extends GlobalVariable {
        private BSFDeclaredBean bean;

        public BeanGlobalVariable(Ruby ruby, BSFDeclaredBean bean) {
            super(ruby, bean.name, null);
            this.bean = bean;
        }

        public IRubyObject get() {
            return JavaUtil.convertJavaToRuby(this.ruby, this.bean.bean);
        }

        public IRubyObject set(IRubyObject value) {
            this.bean.bean = JavaUtil.convertRubyToJava(this.ruby, value, this.bean.type);
            return value;
        }
    }
}

