/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyKernel;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyTestCase
extends TestCase {
    private static final IRubyObject[] EMPTY_ARRAY = new IRubyObject[0];
    static /* synthetic */ Class class$org$jruby$runtime$regexp$JDKRegexpAdapter;

    public RubyTestCase(String name) {
        super(name);
    }

    protected Ruby createRuby(String fileName) throws IOException {
        return this.createRuby(new File(fileName));
    }

    protected Ruby createRuby(URL url) throws IOException {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            return this.createRuby(new File(url.getPath()));
        }
        return this.createRuby(url.openStream());
    }

    /*
     * WARNING - void declaration
     */
    protected Ruby createRuby(InputStream in) throws IOException {
        int l;
        File f = File.createTempFile("rtc", ".rb");
        FileOutputStream out = new FileOutputStream(f);
        byte[] buf = new byte[8096];
        while ((l = in.read(buf, 0, buf.length)) >= 0) {
            void var4_5;
            out.write(buf, 0, (int)var4_5);
        }
        in.close();
        out.close();
        return this.createRuby(f);
    }

    protected Ruby createRuby(File file) throws IOException {
        String filePath = file.getAbsolutePath();
        Ruby ruby = Ruby.getDefaultInstance(class$org$jruby$runtime$regexp$JDKRegexpAdapter == null ? (class$org$jruby$runtime$regexp$JDKRegexpAdapter = RubyTestCase.class$("org.jruby.runtime.regexp.JDKRegexpAdapter")) : class$org$jruby$runtime$regexp$JDKRegexpAdapter);
        this.initRuby(ruby);
        RubyKernel.require(ruby.getTopSelf(), new RubyString(ruby, filePath));
        return ruby;
    }

    protected void initRuby(Ruby ruby) throws IOException {
        IRubyObject empty = JavaUtil.convertJavaToRuby(ruby, EMPTY_ARRAY, EMPTY_ARRAY.getClass());
        ruby.defineReadonlyVariable("$-p", ruby.getNil());
        ruby.defineReadonlyVariable("$-n", ruby.getNil());
        ruby.defineReadonlyVariable("$-a", ruby.getNil());
        ruby.defineReadonlyVariable("$-l", ruby.getNil());
        ruby.defineReadonlyVariable("$\"", empty);
        ruby.defineReadonlyVariable("$*", empty);
        ruby.defineReadonlyVariable("$:", empty);
        ruby.defineGlobalConstant("ARGV", empty);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

