/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.runtime.ObjectSpace;

public class TestObjectSpace
extends TestCase {
    private Ruby ruby;

    public TestObjectSpace(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
    }

    public void testObjectSpace() {
        ObjectSpace os = new ObjectSpace();
        RubyFixnum o1 = RubyFixnum.newFixnum(this.ruby, 10L);
        RubyFixnum o2 = RubyFixnum.newFixnum(this.ruby, 20L);
        RubyFixnum o3 = RubyFixnum.newFixnum(this.ruby, 30L);
        RubyString o4 = RubyString.newString(this.ruby, "hello");
        os.add(o1);
        os.add(o2);
        os.add(o3);
        os.add(o4);
        ArrayList<RubyFixnum> storedFixnums = new ArrayList<RubyFixnum>(3);
        storedFixnums.add(o1);
        storedFixnums.add(o2);
        storedFixnums.add(o3);
        Iterator strings = os.iterator(this.ruby.getClasses().getStringClass());
        Assert.assertTrue((boolean)strings.hasNext());
        Assert.assertSame((Object)o4, strings.next());
        Assert.assertTrue((!strings.hasNext() ? 1 : 0) != 0);
        Iterator numerics = os.iterator(this.ruby.getClasses().getNumericClass());
        int i = 0;
        while (i < 3) {
            Assert.assertTrue((boolean)numerics.hasNext());
            Object item = numerics.next();
            Assert.assertTrue((boolean)storedFixnums.contains(item));
            storedFixnums.remove(item);
            ++i;
        }
        Assert.assertTrue((!numerics.hasNext() ? 1 : 0) != 0);
    }
}

