/*
 * Decompiled with CFR 0.152.
 */
package org.ablaf.internal.ast;

import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.ablaf.ast.IAstDecoder;
import org.ablaf.ast.IAstEncoder;
import org.ablaf.ast.IAstMarshal;
import org.ablaf.ast.INode;

public class XmlAstMarshal
implements IAstMarshal {
    private Map delegates;

    public XmlAstMarshal() {
        this(null);
    }

    public XmlAstMarshal(Map delegates) {
        this.delegates = delegates;
    }

    public IAstDecoder openDecoder(InputStream input) {
        final XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(input));
        return new IAstDecoder(){

            public INode readNode() {
                return (INode)decoder.readObject();
            }

            public void close() {
                decoder.close();
            }
        };
    }

    public IAstEncoder openEncoder(OutputStream output) {
        final XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(output));
        if (this.delegates != null) {
            Iterator iter = this.delegates.entrySet().iterator();
            int i = 0;
            int size = this.delegates.size();
            while (i < size) {
                Map.Entry entry = iter.next();
                encoder.setPersistenceDelegate((Class)entry.getKey(), (PersistenceDelegate)entry.getValue());
                ++i;
            }
        }
        return new IAstEncoder(){

            public void writeNode(INode node) {
                encoder.writeObject(node);
            }

            public void close() {
                encoder.close();
            }
        };
    }
}

