/*
 * Decompiled with CFR 0.152.
 */
package org.ablaf.internal.lexer;

import org.ablaf.lexer.ILexerSource;

public abstract class AbstractLexerSource
implements ILexerSource {
    private StringBuffer buffer = new StringBuffer(200);
    private int offset = 0;
    private String sourceName;
    private char lastRead = '\u0000';
    private int line = 0;

    protected AbstractLexerSource(String sourceName) {
        this.sourceName = sourceName;
    }

    protected abstract char internalRead();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char read() {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (this.lastRead == '\n') {
                ++this.line;
            }
            this.readIntoBuffer();
            this.lastRead = this.buffer.charAt(this.offset++);
            return this.lastRead;
        }
    }

    private void readIntoBuffer() {
        if (this.buffer.length() - this.offset < 1) {
            this.buffer.append(this.internalRead());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread() {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            int result = this.offset > 0 ? (int)this.buffer.charAt(--this.offset) : 0;
            if (result == 10) {
                --this.line;
            }
            return;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public char getLastRead() {
        return this.lastRead;
    }

    public int getLine() {
        return this.line;
    }
}

