/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.IOError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyInputStream;

public class RubyArgsFile
extends RubyObject {
    private RubyIO currentFile = null;
    private int currentLineNumber;
    static /* synthetic */ Class class$org$jruby$RubyArgsFile;
    static /* synthetic */ Class class$org$jruby$RubyGlobal;

    public RubyArgsFile(Ruby ruby) {
        super(ruby, ruby.getClasses().getObjectClass());
    }

    public void setCurrentLineNumber(int newLineNumber) {
        this.currentLineNumber = newLineNumber;
    }

    public void initArgsFile() {
        this.extendObject(this.runtime.getClasses().getEnumerableModule());
        this.runtime.defineReadonlyVariable("$<", this);
        this.runtime.defineGlobalConstant("ARGF", this);
        this.defineSingletonMethod("each", CallbackFactory.getOptMethod(class$org$jruby$RubyArgsFile == null ? (class$org$jruby$RubyArgsFile = RubyArgsFile.class$("org.jruby.RubyArgsFile")) : class$org$jruby$RubyArgsFile, "each_line"));
        this.defineSingletonMethod("each_line", CallbackFactory.getOptMethod(class$org$jruby$RubyArgsFile == null ? (class$org$jruby$RubyArgsFile = RubyArgsFile.class$("org.jruby.RubyArgsFile")) : class$org$jruby$RubyArgsFile, "each_line"));
        this.defineSingletonMethod("filename", CallbackFactory.getMethod(class$org$jruby$RubyArgsFile == null ? (class$org$jruby$RubyArgsFile = RubyArgsFile.class$("org.jruby.RubyArgsFile")) : class$org$jruby$RubyArgsFile, "filename"));
        this.defineSingletonMethod("gets", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyArgsFile.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "gets"));
        this.defineSingletonMethod("readline", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyArgsFile.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "readline"));
        this.defineSingletonMethod("readlines", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyArgsFile.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "readlines"));
        this.defineSingletonMethod("to_a", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyArgsFile.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "readlines"));
        this.defineSingletonMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyArgsFile == null ? (class$org$jruby$RubyArgsFile = RubyArgsFile.class$("org.jruby.RubyArgsFile")) : class$org$jruby$RubyArgsFile, "filename"));
        this.runtime.defineReadonlyVariable("$FILENAME", RubyString.newString(this.runtime, "-"));
        this.currentFile = (RubyIO)this.runtime.getGlobalVariables().get("$stdin");
    }

    protected boolean nextArgsFile() {
        RubyArray args = (RubyArray)this.runtime.getGlobalVariables().get("$*");
        if (args.getLength() == 0) {
            if (this.currentFile == this.runtime.getGlobalVariables().get("$stdin")) {
                return true;
            }
            this.currentFile = (RubyIO)this.runtime.getGlobalVariables().get("$stdin");
            ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue("-");
            this.currentLineNumber = 0;
            return false;
        }
        String filename = ((RubyString)args.shift()).getValue();
        ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(filename);
        if (filename.equals("-")) {
            this.currentFile = (RubyIO)this.runtime.getGlobalVariables().get("$stdin");
        } else {
            File file = new File(filename);
            try {
                RubyInputStream inStream = new RubyInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.currentFile = new RubyFile(this.runtime, this.runtime.getClasses().getFileClass());
                this.currentFile.initIO(inStream, null, filename);
            }
            catch (FileNotFoundException fnfExcptn) {
                throw new IOError(this.runtime, fnfExcptn.getMessage());
            }
        }
        return true;
    }

    public RubyString internalGets(IRubyObject[] args) {
        if (!this.nextArgsFile()) {
            return RubyString.nilString(this.runtime);
        }
        RubyString line = (RubyString)this.currentFile.callMethod("gets", args);
        while (line.isNil()) {
            this.currentFile.callMethod("close");
            if (!this.nextArgsFile()) {
                return line;
            }
            line = (RubyString)this.currentFile.callMethod("gets", args);
        }
        ++this.currentLineNumber;
        this.runtime.getGlobalVariables().set("$.", RubyFixnum.newFixnum(this.runtime, this.currentLineNumber));
        return line;
    }

    public IRubyObject each_line(IRubyObject[] args) {
        RubyString nextLine = this.internalGets(args);
        while (!nextLine.isNil()) {
            this.getRuntime().yield(nextLine);
            nextLine = this.internalGets(args);
        }
        return this;
    }

    public RubyString filename() {
        return (RubyString)this.runtime.getGlobalVariables().get("$FILENAME");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

