/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.FrozenError;
import org.jruby.exceptions.IndexError;
import org.jruby.exceptions.SecurityError;
import org.jruby.internal.runtime.builtin.definitions.HashDefinition;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyHash
extends RubyObject {
    private Map valueMap;
    private IRubyObject defaultValue;
    private boolean isRehashing = false;
    static /* synthetic */ Class class$org$jruby$RubyHash;

    public RubyHash(Ruby ruby) {
        this(ruby, ruby.getNil());
    }

    public RubyHash(Ruby ruby, IRubyObject defaultValue) {
        this(ruby, new HashMap(), defaultValue);
    }

    public RubyHash(Ruby ruby, Map valueMap, IRubyObject defaultValue) {
        super(ruby, ruby.getClass("Hash"));
        this.valueMap = new HashMap(valueMap);
        this.defaultValue = defaultValue;
    }

    public static RubyHash nilHash(Ruby ruby) {
        return new RubyHash(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public IRubyObject getDefaultValue() {
        return this.defaultValue == null ? this.getRuntime().getNil() : this.defaultValue;
    }

    public IRubyObject setDefaultValue(IRubyObject defaultValue) {
        this.defaultValue = defaultValue;
        return defaultValue;
    }

    public Map getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(Map valueMap) {
        this.valueMap = valueMap;
    }

    private Iterator keyIterator() {
        return new ArrayList(this.valueMap.keySet()).iterator();
    }

    private Iterator valueIterator() {
        return new ArrayList(this.valueMap.values()).iterator();
    }

    private Iterator modifiableEntryIterator() {
        return this.valueMap.entrySet().iterator();
    }

    private Iterator entryIterator() {
        return new ArrayList(this.valueMap.entrySet()).iterator();
    }

    public static RubyClass createHashClass(Ruby runtime) {
        return new HashDefinition(runtime).getType();
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 61441: {
                return this.initialize(args);
            }
            case 61442: {
                return this.rbClone();
            }
            case 61443: {
                return this.rehash();
            }
            case 61444: {
                return this.to_hash();
            }
            case 61445: {
                return this.to_a();
            }
            case 61446: {
                return this.to_s();
            }
            case 61447: {
                return this.inspect();
            }
            case 61448: {
                return this.equal(args[0]);
            }
            case 61449: {
                return this.aref(args[0]);
            }
            case 61450: {
                return this.fetch(args);
            }
            case 61451: {
                return this.aset(args[0], args[1]);
            }
            case 61452: {
                return this.getDefaultValue();
            }
            case 61453: {
                return this.setDefaultValue(args[0]);
            }
            case 61454: {
                return this.index(args[0]);
            }
            case 61455: {
                return this.indices(args);
            }
            case 61456: {
                return this.size();
            }
            case 61457: {
                return this.empty_p();
            }
            case 61458: {
                return this.each();
            }
            case 61459: {
                return this.each_value();
            }
            case 61460: {
                return this.each_key();
            }
            case 61461: {
                return this.sort();
            }
            case 61462: {
                return this.keys();
            }
            case 61463: {
                return this.values();
            }
            case 61464: {
                return this.shift();
            }
            case 61465: {
                return this.delete(args[0]);
            }
            case 61466: {
                return this.delete_if();
            }
            case 61467: {
                return this.reject();
            }
            case 61468: {
                return this.reject_bang();
            }
            case 61469: {
                return this.clear();
            }
            case 61470: {
                return this.invert();
            }
            case 61471: {
                return this.update(args[0]);
            }
            case 61472: {
                return this.replace(args[0]);
            }
            case 61473: {
                return this.has_key(args[0]);
            }
            case 61474: {
                return this.has_value(args[0]);
            }
        }
        return super.callIndexed(index, args);
    }

    public void modify() {
        if (this.isFrozen()) {
            throw new FrozenError(this.getRuntime(), "Hash");
        }
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new SecurityError(this.getRuntime(), "Insecure: can't modify hash");
        }
    }

    private int length() {
        return this.valueMap.size();
    }

    public static RubyHash newHash(Ruby ruby) {
        return RubyHash.newInstance(ruby.getClass("Hash"), IRubyObject.NULL_ARRAY);
    }

    public static RubyHash newHash(Ruby ruby, Map valueMap, IRubyObject defaultValue) {
        return new RubyHash(ruby, valueMap, defaultValue);
    }

    public static RubyHash newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyHash hash = new RubyHash(recv.getRuntime());
        hash.setMetaClass((RubyClass)recv);
        hash.callInit(args);
        return hash;
    }

    public static RubyHash create(IRubyObject recv, IRubyObject[] args) {
        RubyHash hsh = new RubyHash(recv.getRuntime());
        if (args.length == 1) {
            hsh.setValueMap(new HashMap(((RubyHash)args[0]).getValueMap()));
        } else {
            if (args.length % 2 != 0) {
                throw new ArgumentError(recv.getRuntime(), "odd number of args for Hash");
            }
            int i = 0;
            while (i < args.length) {
                hsh.aset(args[i], args[i + 1]);
                i += 2;
            }
        }
        return hsh;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        if (args.length > 0) {
            this.modify();
            this.setDefaultValue(args[0]);
        }
        return this;
    }

    public RubyString inspect() {
        String sep = ", ";
        String arrow = "=>";
        StringBuffer sb = new StringBuffer("{");
        Iterator iter = this.valueMap.entrySet().iterator();
        boolean firstEntry = true;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IRubyObject key = (IRubyObject)entry.getKey();
            IRubyObject value = (IRubyObject)entry.getValue();
            if (!firstEntry) {
                sb.append(", ");
            }
            sb.append(key.callMethod("inspect"));
            sb.append("=>");
            sb.append(value.callMethod("inspect"));
            firstEntry = false;
        }
        sb.append("}");
        return RubyString.newString(this.runtime, sb.toString());
    }

    public RubyFixnum size() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.length());
    }

    public RubyBoolean empty_p() {
        return this.length() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyArray to_a() {
        RubyArray result = RubyArray.newArray(this.getRuntime(), this.length());
        Iterator iter = this.valueMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IRubyObject key = (IRubyObject)entry.getKey();
            IRubyObject value = (IRubyObject)entry.getValue();
            result.append(RubyArray.newArray(this.getRuntime(), key, value));
        }
        return result;
    }

    public RubyString to_s() {
        return this.to_a().to_s();
    }

    public IRubyObject rbClone() {
        RubyHash result = RubyHash.newHash(this.runtime, this.getValueMap(), this.getDefaultValue());
        result.setupClone(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash rehash() {
        this.modify();
        try {
            this.isRehashing = true;
            this.valueMap = new HashMap(this.valueMap);
            Object var2_1 = null;
            this.isRehashing = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isRehashing = false;
            throw throwable;
        }
        return this;
    }

    public RubyHash to_hash() {
        return this;
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        this.modify();
        if (!(key instanceof RubyString) || this.valueMap.get(key) != null) {
            this.valueMap.put(key, value);
        } else {
            IRubyObject realKey = key.dup();
            realKey.setFrozen(true);
            this.valueMap.put(realKey, value);
        }
        return value;
    }

    public IRubyObject aref(IRubyObject key) {
        IRubyObject value = (IRubyObject)this.valueMap.get(key);
        return value != null ? value : this.getDefaultValue();
    }

    public IRubyObject fetch(IRubyObject[] args) {
        if (args.length < 1) {
            throw new ArgumentError(this.runtime, args.length, 1);
        }
        IRubyObject key = args[0];
        IRubyObject result = (IRubyObject)this.valueMap.get(key);
        if (result == null) {
            if (args.length > 1) {
                return args[1];
            }
            if (this.runtime.isBlockGiven()) {
                return this.runtime.yield(key);
            }
            throw new IndexError(this.runtime, "key not found");
        }
        return result;
    }

    public RubyBoolean has_key(IRubyObject key) {
        return RubyBoolean.newBoolean(this.runtime, this.valueMap.containsKey(key));
    }

    public RubyBoolean has_value(IRubyObject value) {
        return RubyBoolean.newBoolean(this.runtime, this.valueMap.containsValue(value));
    }

    public RubyHash each() {
        Iterator iter = this.entryIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            Map.Entry entry = (Map.Entry)iter.next();
            this.runtime.yield(RubyArray.newArray(this.runtime, (IRubyObject)entry.getKey(), (IRubyObject)entry.getValue()));
        }
        return this;
    }

    private void checkRehashing() {
        if (this.isRehashing) {
            throw new IndexError(this.getRuntime(), "rehash occured during iteration");
        }
    }

    public RubyHash each_value() {
        Iterator iter = this.valueIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            IRubyObject value = (IRubyObject)iter.next();
            this.runtime.yield(value);
        }
        return this;
    }

    public RubyHash each_key() {
        Iterator iter = this.keyIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            IRubyObject key = (IRubyObject)iter.next();
            this.runtime.yield(key);
        }
        return this;
    }

    public RubyArray sort() {
        RubyArray result = this.to_a();
        result.sort_bang();
        return result;
    }

    public IRubyObject index(IRubyObject value) {
        Iterator iter = this.valueMap.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!value.equals(this.valueMap.get(key))) continue;
            return (IRubyObject)key;
        }
        return this.getDefaultValue();
    }

    public RubyArray indices(IRubyObject[] indices) {
        ArrayList<IRubyObject> values = new ArrayList<IRubyObject>(indices.length);
        int i = 0;
        while (i < indices.length) {
            values.add(this.aref(indices[i]));
            ++i;
        }
        return RubyArray.newArray(this.runtime, values);
    }

    public RubyArray keys() {
        return RubyArray.newArray(this.runtime, new ArrayList(this.valueMap.keySet()));
    }

    public RubyArray values() {
        return RubyArray.newArray(this.runtime, new ArrayList(this.valueMap.values()));
    }

    public RubyBoolean equal(IRubyObject other) {
        if (this == other) {
            return this.runtime.getTrue();
        }
        if (!(other instanceof RubyHash)) {
            return this.runtime.getFalse();
        }
        if (this.length() != ((RubyHash)other).length()) {
            return this.runtime.getFalse();
        }
        Iterator iter = this.modifiableEntryIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            Map.Entry entry = (Map.Entry)iter.next();
            Object value = ((RubyHash)other).valueMap.get(entry.getKey());
            if (value != null && entry.getValue().equals(value)) continue;
            return this.runtime.getFalse();
        }
        return this.runtime.getTrue();
    }

    public RubyArray shift() {
        this.modify();
        Iterator iter = this.modifiableEntryIterator();
        Map.Entry entry = (Map.Entry)iter.next();
        iter.remove();
        return RubyArray.newArray(this.runtime, (IRubyObject)entry.getKey(), (IRubyObject)entry.getValue());
    }

    public IRubyObject delete(IRubyObject key) {
        this.modify();
        IRubyObject result = (IRubyObject)this.valueMap.remove(key);
        if (result != null) {
            return result;
        }
        if (this.runtime.isBlockGiven()) {
            return this.runtime.yield(key);
        }
        return this.getDefaultValue();
    }

    public RubyHash delete_if() {
        this.reject_bang();
        return this;
    }

    public RubyHash reject() {
        RubyHash result = (RubyHash)this.dup();
        result.reject_bang();
        return result;
    }

    public RubyHash reject_bang() {
        this.modify();
        boolean isModified = false;
        Iterator iter = this.keyIterator();
        while (iter.hasNext()) {
            IRubyObject value;
            IRubyObject key = (IRubyObject)iter.next();
            IRubyObject shouldDelete = this.runtime.yield(RubyArray.newArray(this.runtime, key, value = (IRubyObject)this.valueMap.get(key)));
            if (!shouldDelete.isTrue()) continue;
            this.valueMap.remove(key);
            isModified = true;
        }
        if (isModified) {
            return this;
        }
        return RubyHash.nilHash(this.runtime);
    }

    public RubyHash clear() {
        this.modify();
        this.valueMap.clear();
        return this;
    }

    public RubyHash invert() {
        RubyHash result = RubyHash.newHash(this.runtime);
        Iterator iter = this.modifiableEntryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            IRubyObject key = (IRubyObject)entry.getKey();
            IRubyObject value = (IRubyObject)entry.getValue();
            result.aset(value, key);
        }
        return result;
    }

    public RubyHash update(IRubyObject freshElements) {
        this.modify();
        RubyHash freshElementsHash = (RubyHash)freshElements.convertType(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "Hash", "to_hash");
        this.valueMap.putAll(freshElementsHash.valueMap);
        return this;
    }

    public RubyHash replace(IRubyObject replacement) {
        this.modify();
        RubyHash replacementHash = (RubyHash)replacement.convertType(class$org$jruby$RubyHash == null ? (class$org$jruby$RubyHash = RubyHash.class$("org.jruby.RubyHash")) : class$org$jruby$RubyHash, "Hash", "to_hash");
        this.valueMap.clear();
        this.valueMap.putAll(replacementHash.valueMap);
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(123);
        output.dumpInt(this.getValueMap().size());
        Iterator iter = this.entryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            IRubyObject key = (IRubyObject)entry.getKey();
            IRubyObject value = (IRubyObject)entry.getValue();
            output.dumpObject(key);
            output.dumpObject(value);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyHash result = RubyHash.newHash(input.getRuntime());
        input.registerLinkTarget(result);
        int size = input.unmarshalInt();
        int i = 0;
        while (i < size) {
            IRubyObject key = input.unmarshalObject();
            IRubyObject value = input.unmarshalObject();
            result.aset(key, value);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

