/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.ZSuperNode;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.FrozenError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.SecurityError;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Callback;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.LastCallStatus;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.util.Asserts;
import org.jruby.util.PrintfFormat;

public class RubyObject
implements Cloneable,
IRubyObject,
IndexCallable {
    protected transient Ruby runtime;
    private RubyClass metaClass;
    private Map instanceVariables;
    private boolean frozen;
    private boolean taint;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyObject(Ruby ruby) {
        this(ruby, null, false);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, true);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass, boolean useObjectSpace) {
        this.runtime = ruby;
        this.metaClass = rubyClass;
        this.frozen = false;
        this.taint = false;
        if (useObjectSpace) {
            ruby.objectSpace.add(this);
        }
    }

    public static IRubyObject nilObject(Ruby ruby) {
        if (ruby.getNil() != null) {
            return ruby.getNil();
        }
        return new RubyObject(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public MetaClass makeMetaClass(RubyClass type) {
        MetaClass metaClass = type.newSingletonClass();
        this.setMetaClass(metaClass);
        metaClass.attachToObject(this);
        return metaClass;
    }

    public Class getJavaClass() {
        return class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyObject.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod("==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        return ((RubyString)this.callMethod("to_s")).getValue();
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public boolean hasInstanceVariable(String name) {
        if (this.getInstanceVariables() == null) {
            return false;
        }
        return this.getInstanceVariables().containsKey(name);
    }

    public IRubyObject removeInstanceVariable(String name) {
        if (this.getInstanceVariables() == null) {
            return null;
        }
        return (IRubyObject)this.getInstanceVariables().remove(name);
    }

    public Map getInstanceVariables() {
        return this.instanceVariables;
    }

    public void setInstanceVariables(Map instanceVariables) {
        this.instanceVariables = instanceVariables;
    }

    public RubyClass getMetaClass() {
        if (this.isNil()) {
            return this.getRuntime().getClasses().getNilClass();
        }
        return this.metaClass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isTaint() {
        return this.taint;
    }

    public void setTaint(boolean taint) {
        this.taint = taint;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isTrue() {
        return !this.isNil();
    }

    public boolean isFalse() {
        return this.isNil();
    }

    public boolean respondsTo(String name) {
        return this.getMetaClass().isMethodBound(name, false);
    }

    public int argCount(IRubyObject[] args, int min, int max) {
        int len = args.length;
        if (len < min || max > -1 && len > max) {
            throw new ArgumentError(this.getRuntime(), "Wrong # of arguments for method. " + args.length + " is not in Range " + min + ".." + max);
        }
        return len;
    }

    public boolean isKindOf(RubyModule type) {
        return this.getMetaClass().ancestors().includes(type);
    }

    private RubyClass getNilSingletonClass() {
        RubyClass rubyClass = this.getMetaClass();
        if (!rubyClass.isSingleton()) {
            rubyClass = rubyClass.newSingletonClass();
            rubyClass.attachToObject(this);
        }
        return rubyClass;
    }

    public RubyClass getSingletonClass() {
        if (this.isNil()) {
            return this.getNilSingletonClass();
        }
        RubyClass type = this.getMetaClass() instanceof MetaClass ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        type.setTaint(this.isTaint());
        type.setFrozen(this.isFrozen());
        return type;
    }

    public void defineSingletonMethod(String name, Callback method) {
        this.getSingletonClass().defineMethod(name, method);
    }

    public void setupClone(IRubyObject obj) {
        this.setMetaClass(obj.getMetaClass().getSingletonClassClone());
        this.getMetaClass().attachToObject(this);
        this.frozen = obj.isFrozen();
        this.taint = obj.isTaint();
    }

    protected void infectBy(IRubyObject obj) {
        this.setTaint(this.isTaint() || obj.isTaint());
    }

    public IRubyObject callMethod(String name, IRubyObject[] args) {
        return this.getMetaClass().call(this, name, args, CallType.FUNCTIONAL);
    }

    public IRubyObject callMethod(String name) {
        return this.callMethod(name, IRubyObject.NULL_ARRAY);
    }

    public IRubyObject callMethod(String name, IRubyObject arg) {
        return this.callMethod(name, new IRubyObject[]{arg});
    }

    public IRubyObject getInstanceVariable(String name) {
        if (!this.hasInstanceVariable(name)) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.getInstanceVariables().get(name);
    }

    public IRubyObject setInstanceVariable(String name, IRubyObject value) {
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new SecurityError(this.getRuntime(), "Insecure: can't modify instance variable");
        }
        if (this.isFrozen()) {
            throw new FrozenError(this.getRuntime(), "");
        }
        if (this.getInstanceVariables() == null) {
            this.setInstanceVariables(new HashMap());
        }
        this.getInstanceVariables().put(name, value);
        return value;
    }

    public Iterator instanceVariableNames() {
        if (this.getInstanceVariables() == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.getInstanceVariables().keySet().iterator();
    }

    public IRubyObject eval(INode n) {
        return EvaluateVisitor.createVisitor(this).eval(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callInit(IRubyObject[] args) {
        this.runtime.getIterStack().push(this.runtime.isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
        try {
            this.callMethod("initialize", args);
            Object var3_2 = null;
            this.runtime.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.runtime.getIterStack().pop();
            throw throwable;
        }
    }

    public void extendObject(RubyModule module) {
        this.getSingletonClass().includeModule(module);
    }

    public String asSymbol() {
        throw new TypeError(this.getRuntime(), this.inspect().getValue() + " is not a symbol");
    }

    public IRubyObject convertToType(String targetType, String convertMethod, boolean raise) {
        if (!this.respondsTo(convertMethod)) {
            if (raise) {
                throw new TypeError(this.runtime, "Failed to convert " + this.getMetaClass().toName() + " into " + targetType + ".");
            }
            return this.runtime.getNil();
        }
        return this.callMethod(convertMethod);
    }

    public IRubyObject convertToString() {
        return (RubyString)this.convertToType("String", "to_s", true);
    }

    public IRubyObject convertType(Class type, String targetType, String convertMethod) {
        if (type.isAssignableFrom(this.getClass())) {
            return this;
        }
        IRubyObject result = this.convertToType(targetType, convertMethod, true);
        if (!type.isAssignableFrom(result.getClass())) {
            throw new TypeError(this.runtime, this.getMetaClass().toName() + "#" + convertMethod + " should return " + targetType + ".");
        }
        return result;
    }

    public void checkSafeString() {
        if (this.runtime.getSafeLevel() > 0 && this.isTaint()) {
            if (this.runtime.getCurrentFrame().getLastFunc() != null) {
                throw new SecurityError(this.runtime, "Insecure operation - " + this.runtime.getCurrentFrame().getLastFunc());
            }
            throw new SecurityError(this.runtime, "Insecure operation: -r");
        }
        this.getRuntime().secure(4);
        if (!(this instanceof RubyString)) {
            throw new TypeError(this.getRuntime(), "wrong argument type " + this.getMetaClass().toName() + " (expected String)");
        }
    }

    public IRubyObject specificEval(RubyModule mod, IRubyObject[] args) {
        if (this.getRuntime().isBlockGiven()) {
            if (args.length > 0) {
                throw new ArgumentError(this.getRuntime(), "wrong # of arguments (" + args.length + " for 0)");
            }
            return this.yieldUnder(mod);
        }
        if (args.length == 0) {
            throw new ArgumentError(this.getRuntime(), "block not supplied");
        }
        if (args.length > 3) {
            String lastFuncName = this.runtime.getCurrentFrame().getLastFunc();
            throw new ArgumentError(this.getRuntime(), "wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        IRubyObject file = args.length > 1 ? args[1] : RubyString.newString(this.getRuntime(), "(eval)");
        IRubyObject line = args.length > 2 ? args[2] : RubyFixnum.one(this.getRuntime());
        return this.evalUnder(mod, args[0], file, line);
    }

    public IRubyObject evalUnder(RubyModule under, IRubyObject src, IRubyObject file, IRubyObject line) {
        return under.executeUnder(new Callback(){

            public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                return args[0].eval(args[1], self.getRuntime().getNil(), ((RubyString)args[2]).getValue(), RubyNumeric.fix2int(args[3]));
            }

            public Arity getArity() {
                return Arity.optional();
            }
        }, new IRubyObject[]{this, src, file, line});
    }

    public IRubyObject yieldUnder(RubyModule under) {
        return under.executeUnder(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                Block oldBlock = RubyObject.this.runtime.getBlockStack().getCurrent().cloneBlock();
                RubyObject.this.runtime.getBlockStack().getCurrent().getFrame().setNamespace(RubyObject.this.runtime.getCurrentFrame().getNamespace());
                try {
                    IRubyObject iRubyObject = RubyObject.this.runtime.yield(args[0], args[0], RubyObject.this.runtime.getRubyClass(), false);
                    Object var6_5 = null;
                    RubyObject.this.runtime.getBlockStack().setCurrent(oldBlock);
                    return iRubyObject;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    RubyObject.this.runtime.getBlockStack().setCurrent(oldBlock);
                    throw throwable;
                }
            }

            public Arity getArity() {
                return Arity.optional();
            }
        }, new IRubyObject[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject eval(IRubyObject src, IRubyObject scope, String file, int line) {
        ISourcePosition savedPosition = this.runtime.getPosition();
        Iter iter = this.runtime.getCurrentFrame().getIter();
        if (file == null) {
            file = this.runtime.getSourceFile();
        }
        if (scope.isNil() && this.runtime.getFrameStack().getPrevious() != null) {
            this.runtime.getCurrentFrame().setIter(this.runtime.getFrameStack().getPrevious().getIter());
        }
        this.getRuntime().pushClass(this.runtime.getCBase());
        IRubyObject result = this.getRuntime().getNil();
        try {
            INode node = this.getRuntime().parse(src.toString(), file);
            result = this.eval(node);
        }
        finally {
            this.runtime.popClass();
            if (scope.isNil()) {
                this.runtime.getCurrentFrame().setIter(iter);
            }
            this.runtime.setPosition(savedPosition);
        }
        return result;
    }

    public RubyBoolean equal(IRubyObject obj) {
        if (this.isNil()) {
            return RubyBoolean.newBoolean(this.getRuntime(), obj.isNil());
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this == obj);
    }

    public RubyBoolean respond_to(IRubyObject[] args) {
        this.argCount(args, 1, 2);
        String name = args[0].asSymbol();
        boolean includePrivate = args.length > 1 ? args[1].isTrue() : false;
        return RubyBoolean.newBoolean(this.runtime, this.getMetaClass().isMethodBound(name, !includePrivate));
    }

    public RubyFixnum id() {
        return RubyFixnum.newFixnum(this.getRuntime(), System.identityHashCode(this));
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, System.identityHashCode(this));
    }

    public final int hashCode() {
        return RubyNumeric.fix2int(this.callMethod("hash"));
    }

    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    public IRubyObject rbClone() {
        try {
            IRubyObject clone = (IRubyObject)this.clone();
            clone.setupClone(this);
            if (this.getInstanceVariables() != null) {
                clone.setInstanceVariables(new HashMap(this.getInstanceVariables()));
            }
            return clone;
        }
        catch (CloneNotSupportedException cnsExcptn) {
            Asserts.notReached(cnsExcptn.getMessage());
            return null;
        }
    }

    protected void copyObjectTo(IRubyObject destination) {
        if (destination.isFrozen()) {
            throw new TypeError(this.runtime, "[bug] frozen object (" + destination.getType().toName() + ") allocated");
        }
        destination.setTaint(destination.isTaint() || this.isTaint());
        destination.callMethod("become", this);
        destination.setInstanceVariables(null);
        if (this.getInstanceVariables() != null) {
            destination.setInstanceVariables(new HashMap(this.getInstanceVariables()));
        }
    }

    public IRubyObject dup() {
        IRubyObject dup = this.callMethod("clone");
        if (!dup.getClass().equals(this.getClass())) {
            throw new TypeError(this.getRuntime(), "duplicated object must be same type");
        }
        dup.setMetaClass(this.type());
        dup.setFrozen(false);
        return dup;
    }

    public RubyBoolean tainted() {
        if (this.isTaint()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public IRubyObject taint() {
        this.getRuntime().secure(4);
        if (!this.isTaint()) {
            if (this.isFrozen()) {
                throw new FrozenError(this.getRuntime(), "object");
            }
            this.setTaint(true);
        }
        return this;
    }

    public IRubyObject untaint() {
        this.getRuntime().secure(3);
        if (this.isTaint()) {
            if (this.isFrozen()) {
                throw new FrozenError(this.getRuntime(), "object");
            }
            this.setTaint(false);
        }
        return this;
    }

    public IRubyObject freeze() {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw new SecurityError(this.getRuntime(), "Insecure: can't freeze object");
        }
        this.setFrozen(true);
        return this;
    }

    public RubyBoolean frozen() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isFrozen());
    }

    public RubyString inspect() {
        return (RubyString)this.callMethod("to_s");
    }

    public RubyBoolean instance_of(IRubyObject type) {
        return RubyBoolean.newBoolean(this.getRuntime(), this.type() == type);
    }

    public RubyArray instance_variables() {
        ArrayList<RubyString> names = new ArrayList<RubyString>();
        Iterator iter = this.instanceVariableNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            names.add(RubyString.newString(this.getRuntime(), name));
        }
        return RubyArray.newArray(this.runtime, names);
    }

    public RubyBoolean kind_of(IRubyObject type) {
        return RubyBoolean.newBoolean(this.runtime, this.isKindOf((RubyModule)type));
    }

    public IRubyObject methods() {
        return this.getMetaClass().instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public IRubyObject protected_methods() {
        return this.getMetaClass().protected_instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public IRubyObject private_methods() {
        return this.getMetaClass().private_instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public RubyArray singleton_methods() {
        RubyArray result = RubyArray.newArray(this.getRuntime());
        RubyClass type = this.getMetaClass();
        while (type != null && type instanceof MetaClass) {
            Iterator iter = type.getMethods().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                ICallable value = (ICallable)entry.getValue();
                RubyString name = RubyString.newString(this.getRuntime(), key);
                if (value.getVisibility().isPublic()) {
                    if (result.includes(name)) continue;
                    if (value == null) {
                        result.append(this.getRuntime().getNil());
                    }
                    result.append(name);
                    continue;
                }
                if (!(value instanceof EvaluateMethod) || !(((EvaluateMethod)value).getNode() instanceof ZSuperNode)) continue;
                result.append(this.getRuntime().getNil());
                result.append(name);
            }
            type = type.getSuperClass();
        }
        result.compact_bang();
        return result;
    }

    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asSymbol(), true);
    }

    public RubyArray to_a() {
        return RubyArray.newArray(this.getRuntime(), this);
    }

    public RubyString to_s() {
        String cname = this.getMetaClass().toName();
        RubyString str = RubyString.newString(this.getRuntime(), "");
        str.setValue("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    public IRubyObject instance_eval(IRubyObject[] args) {
        return this.specificEval(this.getSingletonClass(), args);
    }

    public IRubyObject extend(IRubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(this.runtime, "wrong # of arguments");
        }
        int i = 0;
        while (i < args.length) {
            args[i].callMethod("extend_object", this);
            ++i;
        }
        return this;
    }

    public IRubyObject method_missing(IRubyObject[] args) {
        boolean noClass;
        if (args.length == 0) {
            throw new ArgumentError(this.getRuntime(), "no id given");
        }
        String name = args[0].asSymbol();
        String description = this.callMethod("inspect").toString();
        boolean bl = noClass = description.charAt(0) == '#';
        if (this.isNil()) {
            noClass = true;
            description = "nil";
        } else if (this == this.runtime.getTrue()) {
            noClass = true;
            description = "true";
        } else if (this == this.runtime.getFalse()) {
            noClass = true;
            description = "false";
        }
        LastCallStatus lastCallStatus = this.runtime.getLastCallStatus();
        String format = lastCallStatus.errorMessageFormat(name);
        String msg = new PrintfFormat(format).sprintf(new Object[]{name, description, noClass ? "" : ":", noClass ? "" : this.getType().toName()});
        throw new NameError(this.getRuntime(), msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject send(IRubyObject[] args) {
        IRubyObject iRubyObject;
        if (args.length < 1) {
            throw new ArgumentError(this.runtime, "no method name given");
        }
        String name = args[0].asSymbol();
        IRubyObject[] newArgs = new IRubyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        this.runtime.getIterStack().push(this.runtime.isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
        try {
            iRubyObject = this.getMetaClass().call(this, name, newArgs, CallType.FUNCTIONAL);
            Object var6_5 = null;
            this.getRuntime().getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getRuntime().getIterStack().pop();
            throw throwable;
        }
        return iRubyObject;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(111);
        RubySymbol classname = RubySymbol.newSymbol(this.runtime, this.getMetaClass().getClassname());
        output.dumpObject(classname);
        if (this.getInstanceVariables() == null) {
            output.dumpInt(0);
        } else {
            output.dumpInt(this.getInstanceVariables().size());
            Iterator iter = this.instanceVariableNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                IRubyObject value = this.getInstanceVariable(name);
                output.dumpObject(RubySymbol.newSymbol(this.runtime, name));
                output.dumpObject(value);
            }
        }
    }

    public RubyClass getType() {
        return this.type();
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 5121: {
                return this.rbClone();
            }
            case 5122: {
                return this.dup();
            }
            case 5123: {
                return this.equal(args[0]);
            }
            case 5124: {
                return this.extend(args);
            }
            case 5125: {
                return this.freeze();
            }
            case 5126: {
                return this.frozen();
            }
            case 5132: {
                return this.hash();
            }
            case 5133: {
                return this.id();
            }
            case 5127: {
                return this.inspect();
            }
            case 5128: {
                return this.instance_eval(args);
            }
            case 5129: {
                return this.instance_of(args[0]);
            }
            case 5130: {
                return this.instance_variables();
            }
            case 5131: {
                return this.kind_of(args[0]);
            }
            case 5134: {
                return this.runtime.getFalse();
            }
            case 5135: {
                return this.method(args[0]);
            }
            case 5137: {
                return this.method_missing(args);
            }
            case 5136: {
                return this.methods();
            }
            case 5138: {
                return this.runtime.getFalse();
            }
            case 5139: {
                return this.private_methods();
            }
            case 5140: {
                return this.protected_methods();
            }
            case 5141: {
                return this.respond_to(args);
            }
            case 5142: {
                return this.send(args);
            }
            case 5143: {
                return this.singleton_methods();
            }
            case 5144: {
                return this.taint();
            }
            case 5145: {
                return this.tainted();
            }
            case 5146: {
                return this.to_a();
            }
            case 5147: {
                return this.to_s();
            }
            case 5148: {
                return this.type();
            }
            case 5149: {
                return this.untaint();
            }
        }
        Asserts.notReached("invalid index '" + index + "'.");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

