/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyDateFormat;

public class RubyTime
extends RubyObject {
    private Calendar cal;
    private long usec;
    private static RubyDateFormat rubyDateFormat = new RubyDateFormat("-", Locale.US);
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("-", Locale.US);
    private static final String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final long[] time_min = new long[]{1L, 0L, 0L, 0L, 0L};
    private static final long[] time_max = new long[]{31L, 23L, 59L, 60L, Long.MAX_VALUE};
    static /* synthetic */ Class class$org$jruby$RubyTime;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyTime(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createTimeClass(Ruby ruby) {
        RubyClass timeClass = ruby.defineClass("Time", ruby.getClasses().getObjectClass());
        timeClass.includeModule(ruby.getClasses().getComparableModule());
        timeClass.defineSingletonMethod("at", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "new_at"));
        timeClass.defineSingletonMethod("new", CallbackFactory.getSingletonMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "s_new"));
        timeClass.defineSingletonMethod("now", CallbackFactory.getSingletonMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "s_new"));
        timeClass.defineSingletonMethod("local", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "new_local"));
        timeClass.defineSingletonMethod("mktime", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "new_local"));
        timeClass.defineSingletonMethod("gm", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "new_utc"));
        timeClass.defineSingletonMethod("utc", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "new_utc"));
        timeClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "op_cmp", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyTime.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        timeClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "op_minus", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyTime.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        timeClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "op_plus", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyTime.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        timeClass.defineMethod("sec", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "sec"));
        timeClass.defineMethod("min", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "min"));
        timeClass.defineMethod("hour", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "hour"));
        timeClass.defineMethod("day", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "mday"));
        timeClass.defineMethod("mday", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "mday"));
        timeClass.defineMethod("mon", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "month"));
        timeClass.defineMethod("month", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "month"));
        timeClass.defineMethod("year", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "year"));
        timeClass.defineMethod("wday", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "wday"));
        timeClass.defineMethod("yday", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "yday"));
        timeClass.defineMethod("isdst", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "isdst"));
        timeClass.defineMethod("zone", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "zone"));
        timeClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "to_a"));
        timeClass.defineMethod("to_f", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "to_f"));
        timeClass.defineMethod("asctime", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "asctime"));
        timeClass.defineMethod("ctime", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "asctime"));
        timeClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "to_s"));
        timeClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "to_s"));
        timeClass.defineMethod("strftime", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "strftime", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyTime.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        timeClass.defineMethod("tv_usec", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "usec"));
        timeClass.defineMethod("usec", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "usec"));
        timeClass.defineMethod("tv_sec", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "to_i"));
        timeClass.defineMethod("to_i", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "to_i"));
        timeClass.defineMethod("gmtime", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "gmtime"));
        timeClass.defineMethod("utc", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "gmtime"));
        timeClass.defineMethod("gmt?", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "gmt"));
        timeClass.defineMethod("gmtime?", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "gmt"));
        timeClass.defineMethod("utc?", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "gmt"));
        timeClass.defineMethod("localtime", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "localtime"));
        timeClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyTime == null ? (class$org$jruby$RubyTime = RubyTime.class$("org.jruby.RubyTime")) : class$org$jruby$RubyTime, "hash"));
        return timeClass;
    }

    protected long getTimeInMillis() {
        return this.cal.getTime().getTime();
    }

    public static RubyTime s_new(IRubyObject receiver) {
        IRubyObject[] args = new IRubyObject[]{RubyFixnum.newFixnum(receiver.getRuntime(), new Date().getTime())};
        return RubyTime.s_at(receiver, args);
    }

    public static RubyTime new_at(IRubyObject receiver, IRubyObject[] args) {
        int len = receiver.argCount(args, 1, 2);
        RubyTime time = new RubyTime(receiver.getRuntime(), (RubyClass)receiver);
        time.cal = Calendar.getInstance();
        if (args[0] instanceof RubyTime) {
            time.cal.setTimeZone(((RubyTime)args[0]).cal.getTimeZone());
            time.cal.setTimeInMillis(((RubyTime)args[0]).getTimeInMillis());
        } else {
            long usec = len > 1 ? RubyNumeric.num2long(args[1]) / 1000L : 0L;
            time.usec = len > 1 ? RubyNumeric.num2long(args[1]) % 1000L : 0L;
            time.cal.setTimeInMillis(RubyNumeric.num2long(args[0]) * 1000L + usec);
        }
        time.callInit(args);
        return time;
    }

    public static RubyTime new_local(IRubyObject type, IRubyObject[] args) {
        return RubyTime.createTime(type, args, false);
    }

    public static RubyTime new_utc(IRubyObject type, IRubyObject[] args) {
        return RubyTime.createTime(type, args, true);
    }

    private static RubyTime createTime(IRubyObject type, IRubyObject[] args, boolean gmt) {
        int len = 6;
        if (args.length == 10) {
            args = new IRubyObject[]{args[5], args[4], args[3], args[2], args[1], args[0]};
        } else {
            len = type.argCount(args, 1, 7);
        }
        int year = RubyNumeric.fix2int(args[0]);
        int month = 0;
        if (len > 1) {
            if (!args[1].isNil()) {
                if (args[1] instanceof RubyString) {
                    month = -1;
                    int i = 0;
                    while (i < 12) {
                        if (months[i].equalsIgnoreCase(args[1].toString())) {
                            month = i;
                        }
                        ++i;
                    }
                    if (month == -1) {
                        try {
                            month = Integer.parseInt(args[1].toString()) - 1;
                        }
                        catch (NumberFormatException nfExcptn) {
                            throw new ArgumentError(type.getRuntime(), "Argument out of range.");
                        }
                    }
                } else {
                    month = RubyNumeric.fix2int(args[1]) - 1;
                }
            }
            if (0 > month || month > 11) {
                throw new ArgumentError(type.getRuntime(), "Argument out of range.");
            }
        }
        int[] int_args = new int[]{1, 0, 0, 0, 0};
        int i = 0;
        while (len > i + 2) {
            if (!args[i + 2].isNil()) {
                int_args[i] = RubyNumeric.fix2int(args[i + 2]);
                if (time_min[i] > (long)int_args[i] || (long)int_args[i] > time_max[i]) {
                    throw new ArgumentError(type.getRuntime(), "Argument out of range.");
                }
            }
            ++i;
        }
        RubyTime time = new RubyTime(type.getRuntime(), (RubyClass)type);
        time.cal = gmt ? Calendar.getInstance(TimeZone.getTimeZone("GMT")) : Calendar.getInstance();
        time.cal.set(year, month, int_args[0], int_args[1], int_args[2], int_args[3]);
        time.cal.set(14, int_args[4] / 1000);
        time.usec = int_args[4] % 1000;
        time.callInit(args);
        return time;
    }

    public static RubyTime s_at(IRubyObject rubyClass, IRubyObject[] args) {
        long secs = RubyNumeric.num2long(args[0]);
        RubyTime time = new RubyTime(rubyClass.getRuntime(), (RubyClass)rubyClass);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(secs));
        time.setJavaCalendar(cal);
        return time;
    }

    public RubyTime gmtime() {
        this.cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this;
    }

    public RubyTime localtime() {
        this.cal.setTimeZone(TimeZone.getDefault());
        return this;
    }

    public RubyBoolean gmt() {
        return RubyBoolean.newBoolean(this.runtime, this.cal.getTimeZone().getID().equals("GMT"));
    }

    public RubyString strftime(IRubyObject format) {
        rubyDateFormat.setCalendar(this.cal);
        rubyDateFormat.applyPattern(format.toString());
        String result = rubyDateFormat.format(this.cal.getTime());
        return RubyString.newString(this.runtime, result);
    }

    public IRubyObject op_plus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            throw new TypeError(this.runtime, "time + time ?");
        }
        time = (long)((double)time + ((RubyNumeric)other).getDoubleValue() * 1000.0);
        RubyTime newTime = new RubyTime(this.runtime, this.getMetaClass());
        newTime.cal = Calendar.getInstance();
        newTime.cal.setTime(new Date(time));
        return newTime;
    }

    public IRubyObject op_minus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            return RubyFloat.newFloat(this.runtime, (double)(time -= ((RubyTime)other).getTimeInMillis()) * 0.001);
        }
        time = (long)((double)time - ((RubyNumeric)other).getDoubleValue() * 1000.0);
        RubyTime newTime = new RubyTime(this.runtime, this.getMetaClass());
        newTime.cal = Calendar.getInstance();
        newTime.cal.setTime(new Date(time));
        return newTime;
    }

    public RubyFixnum op_cmp(IRubyObject other) {
        long millis_other;
        long millis = this.getTimeInMillis();
        if (other instanceof RubyFloat || other instanceof RubyBignum) {
            double time = (double)millis / 1000.0;
            double time_other = ((RubyNumeric)other).getDoubleValue();
            if (time > time_other) {
                return RubyFixnum.one(this.runtime);
            }
            if (time < time_other) {
                return RubyFixnum.minus_one(this.runtime);
            }
            return RubyFixnum.zero(this.runtime);
        }
        long l = millis_other = other instanceof RubyTime ? ((RubyTime)other).getTimeInMillis() : RubyNumeric.num2long(other) * 1000L;
        if (millis > millis_other) {
            return RubyFixnum.one(this.runtime);
        }
        if (millis < millis_other) {
            return RubyFixnum.minus_one(this.runtime);
        }
        return RubyFixnum.zero(this.runtime);
    }

    public RubyString asctime() {
        simpleDateFormat.setCalendar(this.cal);
        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
        String result = simpleDateFormat.format(this.cal.getTime());
        return RubyString.newString(this.runtime, result);
    }

    public RubyString to_s() {
        simpleDateFormat.setCalendar(this.cal);
        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss z yyyy");
        String result = simpleDateFormat.format(this.cal.getTime());
        return RubyString.newString(this.runtime, result);
    }

    public RubyArray to_a() {
        return RubyArray.newArray(this.runtime, new IRubyObject[]{this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone()});
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.runtime, (double)this.getTimeInMillis() / 1000.0);
    }

    public RubyInteger to_i() {
        return RubyFixnum.newFixnum(this.runtime, this.getTimeInMillis() / 1000L);
    }

    public RubyInteger usec() {
        return RubyFixnum.newFixnum(this.runtime, this.getTimeInMillis() % 1000L * 1000L + this.usec);
    }

    public RubyInteger sec() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(13));
    }

    public RubyInteger min() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(12));
    }

    public RubyInteger hour() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(11));
    }

    public RubyInteger mday() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(5));
    }

    public RubyInteger month() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(2) + 1);
    }

    public RubyInteger year() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(1));
    }

    public RubyInteger wday() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(7) - 1);
    }

    public RubyInteger yday() {
        return RubyFixnum.newFixnum(this.runtime, this.cal.get(6));
    }

    public RubyBoolean isdst() {
        return RubyBoolean.newBoolean(this.runtime, this.cal.getTimeZone().inDaylightTime(this.cal.getTime()));
    }

    public RubyString zone() {
        return RubyString.newString(this.runtime, this.cal.getTimeZone().getID());
    }

    public void setJavaCalendar(Calendar cal) {
        this.cal = cal;
    }

    public Date getJavaDate() {
        return this.cal.getTime();
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, (int)((long)this.cal.get(13) ^ this.usec));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

