/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.builtin.definitions;

import org.jruby.KernelModule;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.definitions.MethodContext;
import org.jruby.runtime.builtin.definitions.ModuleDefinition;
import org.jruby.runtime.builtin.definitions.ModuleFunctionsContext;
import org.jruby.util.Asserts;

public class KernelDefinition
extends ModuleDefinition {
    private static final int KERNEL = 4096;
    private static final int STATIC = 4352;
    private static final int AUTOLOAD = 4353;
    private static final int BACKQUOTE = 4354;
    private static final int BLOCK_GIVEN = 4355;
    private static final int CALLER = 4356;
    private static final int CATCH = 4357;
    private static final int CHOMP = 4358;
    private static final int CHOMP_BANG = 4359;
    private static final int CHOP = 4360;
    private static final int CHOP_BANG = 4361;
    private static final int EVAL = 4362;
    private static final int EXIT = 4363;
    private static final int GETS = 4364;
    private static final int GLOBAL_VARIABLES = 4365;
    private static final int GSUB = 4366;
    private static final int GSUB_BANG = 4367;
    private static final int LOAD = 4368;
    private static final int LOCAL_VARIABLES = 4369;
    private static final int LOOP = 4370;
    private static final int OPEN = 4371;
    private static final int P = 4372;
    private static final int PUTS = 4373;
    private static final int PRINT = 4374;
    private static final int PRINTF = 4375;
    private static final int PROC = 4376;
    private static final int RAISE = 4377;
    private static final int RAND = 4378;
    private static final int READLINE = 4379;
    private static final int READLINES = 4380;
    private static final int REQUIRE = 4381;
    private static final int SCAN = 4382;
    private static final int SET_TRACE_FUNC = 4383;
    private static final int SINGLETON_METHOD_ADDED = 4384;
    private static final int SLEEP = 4385;
    private static final int SPLIT = 4386;
    private static final int SPRINTF = 4387;
    private static final int SRAND = 4388;
    private static final int SUB = 4389;
    private static final int SUB_BANG = 4390;
    private static final int SYSTEM = 4391;
    private static final int THROW = 4392;

    public KernelDefinition(Ruby runtime) {
        super(runtime);
    }

    protected RubyModule createModule(Ruby runtime) {
        return runtime.defineModule("Kernel");
    }

    protected void defineModuleFunctions(ModuleFunctionsContext context) {
        context.createOptional("open", 4371, 1);
        context.createOptional("format", 4387, 1);
        context.createOptional("gets", 4364);
        context.createOptional("p", 4372);
        context.createOptional("print", 4374);
        context.createOptional("printf", 4375);
        context.createOptional("puts", 4373);
        context.createOptional("readline", 4379);
        context.createOptional("readlines", 4380);
        context.createOptional("sprintf", 4387);
        context.createOptional("gsub!", 4367);
        context.createOptional("gsub", 4366);
        context.createOptional("sub!", 4390);
        context.createOptional("sub", 4389);
        context.create("chop!", 4361, 0);
        context.create("chop", 4360, 0);
        context.createOptional("chomp!", 4359);
        context.createOptional("chomp", 4358);
        context.createOptional("split", 4386);
        context.create("scan", 4382, 1);
        context.createOptional("load", 4368, 1);
        context.create("autoload", 4353, 2);
        context.createOptional("raise", 4377);
        context.create("require", 4381, 1);
        context.create("global_variables", 4365, 0);
        context.create("local_variables", 4369, 0);
        context.create("block_given?", 4355, 0);
        context.create("iterator?", 4355, 0);
        context.create("proc", 4376, 0);
        context.create("lambda", 4376, 0);
        context.create("loop", 4370, 0);
        context.createOptional("eval", 4362, 1);
        context.createOptional("caller", 4356);
        context.create("catch", 4357, 1);
        context.createOptional("throw", 4392, 1);
        context.create("singleton_method_added", 4384, 1);
        context.create("set_trace_func", 4383, 1);
        context.create("sleep", 4385, 1);
        context.create("`", 4354, 1);
        context.createOptional("exit", 4363);
        context.createOptional("srand", 4388);
        context.createOptional("rand", 4378);
        context.createOptional("system", 4391, 1);
    }

    public IRubyObject callIndexed(int index, IRubyObject receiver, IRubyObject[] args) {
        switch (index) {
            case 4353: {
                return KernelModule.autoload(receiver, args[0], args[1]);
            }
            case 4354: {
                return KernelModule.backquote(receiver, args[0]);
            }
            case 4355: {
                return KernelModule.block_given(receiver);
            }
            case 4356: {
                return KernelModule.caller(receiver, args);
            }
            case 4357: {
                return KernelModule.rbCatch(receiver, args[0]);
            }
            case 4358: {
                return KernelModule.chomp(receiver, args);
            }
            case 4359: {
                return KernelModule.chomp_bang(receiver, args);
            }
            case 4360: {
                return KernelModule.chop(receiver);
            }
            case 4361: {
                return KernelModule.chop_bang(receiver);
            }
            case 4362: {
                return KernelModule.eval(receiver, args);
            }
            case 4363: {
                return KernelModule.exit(receiver, args);
            }
            case 4364: {
                return KernelModule.gets(receiver, args);
            }
            case 4365: {
                return KernelModule.global_variables(receiver);
            }
            case 4366: {
                return KernelModule.gsub(receiver, args);
            }
            case 4367: {
                return KernelModule.gsub_bang(receiver, args);
            }
            case 4368: {
                return KernelModule.load(receiver, args);
            }
            case 4369: {
                return KernelModule.local_variables(receiver);
            }
            case 4370: {
                return KernelModule.loop(receiver);
            }
            case 4371: {
                return KernelModule.open(receiver, args);
            }
            case 4372: {
                return KernelModule.p(receiver, args);
            }
            case 4374: {
                return KernelModule.print(receiver, args);
            }
            case 4375: {
                return KernelModule.printf(receiver, args);
            }
            case 4376: {
                return KernelModule.proc(receiver);
            }
            case 4373: {
                return KernelModule.puts(receiver, args);
            }
            case 4377: {
                return KernelModule.raise(receiver, args);
            }
            case 4378: {
                return KernelModule.rand(receiver, args);
            }
            case 4379: {
                return KernelModule.readline(receiver, args);
            }
            case 4380: {
                return KernelModule.readlines(receiver, args);
            }
            case 4381: {
                return KernelModule.require(receiver, args[0]);
            }
            case 4382: {
                return KernelModule.scan(receiver, args[0]);
            }
            case 4383: {
                return KernelModule.set_trace_func(receiver, args[0]);
            }
            case 4384: {
                return receiver.getRuntime().getNil();
            }
            case 4385: {
                return KernelModule.sleep(receiver, args[0]);
            }
            case 4386: {
                return KernelModule.split(receiver, args);
            }
            case 4387: {
                return KernelModule.sprintf(receiver, args);
            }
            case 4388: {
                return KernelModule.srand(receiver, args);
            }
            case 4389: {
                return KernelModule.sub(receiver, args);
            }
            case 4390: {
                return KernelModule.sub_bang(receiver, args);
            }
            case 4391: {
                return KernelModule.system(receiver, args);
            }
            case 4392: {
                return KernelModule.rbThrow(receiver, args);
            }
        }
        Asserts.notReached("'" + index + "' is not a valid index.");
        return null;
    }

    protected void defineMethods(MethodContext context) {
    }
}

