/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.builtin.definitions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.definitions.ClassDefinition;
import org.jruby.runtime.builtin.definitions.MethodContext;
import org.jruby.runtime.builtin.definitions.SingletonMethodContext;
import org.jruby.util.Asserts;

public class StringDefinition
extends ClassDefinition {
    private static final int STRING = 61440;
    private static final int STATIC = 61696;
    public static final int REPLACE = 61441;
    public static final int RBCLONE = 61442;
    public static final int DUP = 61443;
    public static final int OP_CMP = 61444;
    public static final int EQUAL = 61445;
    public static final int HASH = 61446;
    public static final int OP_PLUS = 61447;
    public static final int OP_MUL = 61448;
    public static final int FORMAT = 61449;
    public static final int AREF = 61450;
    public static final int ASET = 61451;
    public static final int LENGTH = 61452;
    public static final int EMPTY = 61453;
    public static final int MATCH = 61454;
    public static final int MATCH2 = 61455;
    public static final int SUCC = 61456;
    public static final int SUCC_BANG = 61457;
    public static final int UPTO = 61458;
    public static final int INDEX = 61459;
    public static final int RINDEX = 61460;
    public static final int TO_I = 61461;
    public static final int TO_F = 61462;
    public static final int TO_S = 61463;
    public static final int INSPECT = 61464;
    public static final int DUMP = 61465;
    public static final int UPCASE = 61466;
    public static final int DOWNCASE = 61467;
    public static final int CAPITALIZE = 61468;
    public static final int CONCAT = 61469;
    public static final int INTERN = 61470;
    public static final int SUM = 61471;
    public static final int NEWINSTANCE = 61697;

    public StringDefinition(Ruby runtime) {
        super(runtime);
    }

    protected RubyClass createType(Ruby runtime) {
        RubyClass result = runtime.defineClass("String", (RubyClass)runtime.getClasses().getClass("Object"));
        result.includeModule(runtime.getClasses().getClass("Comparable"));
        result.includeModule(runtime.getClasses().getClass("Enumerable"));
        return result;
    }

    protected void defineMethods(MethodContext context) {
        context.create("replace", 61441, 1);
        context.create("initialize", 61441, 1);
        context.create("clone", 61442, 0);
        context.create("dup", 61443, 0);
        context.create("<=>", 61444, 1);
        context.create("==", 61445, 1);
        context.create("===", 61445, 1);
        context.create("eql?", 61445, 1);
        context.create("hash", 61446, 0);
        context.create("+", 61447, 1);
        context.create("*", 61448, 1);
        context.create("%", 61449, 1);
        context.createOptional("[]", 61450, 0);
        context.createOptional("[]=", 61451, 0);
        context.create("length", 61452, 0);
        context.create("size", 61452, 0);
        context.create("empty?", 61453, 0);
        context.create("=~", 61454, 1);
        context.create("~", 61455, 0);
        context.create("succ", 61456, 0);
        context.create("succ!", 61457, 0);
        context.create("next", 61456, 0);
        context.create("next!", 61457, 0);
        context.create("upto", 61458, 1);
        context.createOptional("index", 61459, 0);
        context.createOptional("rindex", 61460, 0);
        context.create("to_i", 61461, 0);
        context.create("to_f", 61462, 0);
        context.create("to_s", 61463, 0);
        context.create("to_str", 61463, 0);
        context.create("inspect", 61464, 0);
        context.create("dump", 61465, 0);
        context.create("upcase", 61466, 0);
        context.create("downcase", 61467, 0);
        context.create("capitalize", 61468, 0);
        context.create("concat", 61469, 1);
        context.create("<<", 61469, 1);
        context.create("intern", 61470, 0);
        context.createOptional("sum", 61471, 0);
        context.createOptional("slice", 61450, 0);
    }

    protected void defineSingletonMethods(SingletonMethodContext context) {
        context.createOptional("new", 61697, 0);
    }

    public IRubyObject callIndexed(int index, IRubyObject receiver, IRubyObject[] args) {
        switch (index) {
            case 61697: {
                return RubyString.newInstance(receiver, args);
            }
        }
        Asserts.notReached();
        return null;
    }
}

