/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.LoadError;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.ILoadService;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.Library;

public class LoadService
implements ILoadService {
    private ArrayList loadPath = new ArrayList();
    private ArrayList loadedFeatures = new ArrayList();
    private Map builtinLibraries = new HashMap();
    private Map autoloadMap = new HashMap();
    private final Ruby runtime;

    public LoadService(Ruby runtime) {
        this.runtime = runtime;
    }

    public void init(Ruby runtime, List additionalDirectories) {
        String jrubyHome;
        String jrubyLib;
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.addPath((String)iter.next());
        }
        if (runtime.getSafeLevel() == 0 && (jrubyLib = System.getProperty("jruby.lib")) != null) {
            this.addPath(jrubyLib);
        }
        if ((jrubyHome = System.getProperty("jruby.home")) != null) {
            String rubyDir = jrubyHome + File.separatorChar + "lib" + File.separatorChar + "ruby" + File.separatorChar;
            this.addPath(rubyDir + "site_ruby" + File.separatorChar + "1.6");
            this.addPath(rubyDir + "site_ruby" + File.separatorChar + "1.6" + File.separatorChar + "java");
            this.addPath(rubyDir + "site_ruby");
            this.addPath(rubyDir + "1.6");
            this.addPath(rubyDir + "1.6" + File.separatorChar + "java");
        }
        if (runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    private void addPath(String path) {
        this.loadPath.add(RubyString.newString(this.runtime, path));
    }

    public boolean load(String file) {
        String[] suffixes = new String[]{"", ".rb", ".jar"};
        Library library = null;
        int i = 0;
        while (i < suffixes.length) {
            library = this.findLibrary(file + suffixes[i]);
            if (library != null) break;
            ++i;
        }
        if (library == null) {
            throw new LoadError(this.runtime, "No such file to load -- " + file);
        }
        library.load(this.runtime);
        return true;
    }

    private Library findLibrary(String file) {
        if (this.builtinLibraries.containsKey(file)) {
            return (Library)this.builtinLibraries.get(file);
        }
        URL url = this.findFile(file);
        if (url == null) {
            return null;
        }
        if (file.endsWith(".jar")) {
            return new JarredScript(url);
        }
        return new ExternalScript(url, file);
    }

    public boolean require(String file) {
        RubyString name = RubyString.newString(this.runtime, file);
        if (this.loadedFeatures.contains(name)) {
            return false;
        }
        if (this.load(file)) {
            this.loadedFeatures.add(name);
            return true;
        }
        return false;
    }

    public ArrayList getLoadPath() {
        return this.loadPath;
    }

    public ArrayList getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public boolean isAutoloadDefined(String name) {
        return this.autoloadMap.containsKey(name);
    }

    public IRubyObject autoload(String name) {
        IAutoloadMethod loadMethod = (IAutoloadMethod)this.autoloadMap.get(name);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name);
        }
        return null;
    }

    public void addAutoload(String name, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name, loadMethod);
    }

    public void registerBuiltin(String name, Library library) {
        this.builtinLibraries.put(name, library);
    }

    /*
     * Unable to fully structure code
     */
    private URL findFile(String name) {
        try {
            if (name.startsWith("jar:")) {
                return new URL(name);
            }
            i = 0;
            size = this.loadPath.size();
            while (i < size) {
                entry = this.loadPath.get(i).toString();
                if (entry.startsWith("jar:")) {
                    try {
                        current = new JarFile(entry.substring(4));
                        if (current.getJarEntry(name) == null) ** GOTO lbl20
                        return new URL(entry + name);
                    }
                    catch (FileNotFoundException ignored) {
                    }
                    catch (IOException e) {
                        throw IOError.fromException(this.runtime, e);
                    }
                } else {
                    current = new File(entry, name);
                    if (current.exists()) {
                        return current.toURL();
                    }
                }
lbl20:
                // 4 sources

                ++i;
            }
            current = new File(name);
            if (current.exists()) {
                return current.toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new IOError(this.runtime, e.getMessage());
        }
        return null;
    }
}

