/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.TypeError;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaClass
extends RubyObject
implements IndexCallable {
    private final Class javaClass;
    private static final int PUBLIC_P = 1;
    private static final int FINAL_P = 2;
    private static final int INTERFACE_P = 3;
    private static final int ARRAY_P = 4;
    private static final int NAME = 5;
    private static final int SUPERCLASS = 7;
    private static final int OP_CMP = 8;
    private static final int JAVA_INSTANCE_METHODS = 11;
    private static final int JAVA_CLASS_METHODS = 12;
    private static final int JAVA_METHOD = 14;
    private static final int CONSTRUCTORS = 15;
    private static final int CONSTRUCTOR = 16;
    private static final int ARRAY_CLASS = 17;
    private static final int NEW_ARRAY = 18;
    private static final int FIELDS = 20;
    private static final int FIELD = 21;
    private static final int INTERFACES = 22;
    private static final int PRIMITIVE_P = 23;
    private static final int ASSIGNABLE_FROM_P = 24;
    private static final int COMPONENT_TYPE = 25;
    static /* synthetic */ Class class$org$jruby$javasupport$JavaClass;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Character;

    private JavaClass(Ruby runtime, String name) {
        this(runtime, runtime.getJavaSupport().loadJavaClass(name));
    }

    public JavaClass(Ruby runtime, Class javaClass) {
        super(runtime, (RubyClass)runtime.getClasses().getClassFromPath("Java::JavaClass"));
        this.javaClass = javaClass;
    }

    public Class getValue() {
        return this.javaClass;
    }

    public static RubyClass createJavaClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass javaClassClass = javaModule.defineClassUnder("JavaClass", runtime.getClasses().getObjectClass());
        javaClassClass.includeModule(runtime.getClasses().getComparableModule());
        javaClassClass.defineSingletonMethod("for_name", CallbackFactory.getSingletonMethod(class$org$jruby$javasupport$JavaClass == null ? (class$org$jruby$javasupport$JavaClass = JavaClass.class$("org.jruby.javasupport.JavaClass")) : class$org$jruby$javasupport$JavaClass, "for_name", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = JavaClass.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        javaClassClass.defineMethod("public?", IndexedCallback.create(1, 0));
        javaClassClass.defineMethod("final?", IndexedCallback.create(2, 0));
        javaClassClass.defineMethod("interface?", IndexedCallback.create(3, 0));
        javaClassClass.defineMethod("array?", IndexedCallback.create(4, 0));
        javaClassClass.defineMethod("name", IndexedCallback.create(5, 0));
        javaClassClass.defineMethod("to_s", IndexedCallback.create(5, 0));
        javaClassClass.defineMethod("superclass", IndexedCallback.create(7, 0));
        javaClassClass.defineMethod("<=>", IndexedCallback.create(8, 1));
        javaClassClass.defineMethod("java_instance_methods", IndexedCallback.create(11, 0));
        javaClassClass.defineMethod("java_class_methods", IndexedCallback.create(12, 0));
        javaClassClass.defineMethod("java_method", IndexedCallback.createOptional(14, 1));
        javaClassClass.defineMethod("constructors", IndexedCallback.create(15, 0));
        javaClassClass.defineMethod("constructor", IndexedCallback.createOptional(16));
        javaClassClass.defineMethod("array_class", IndexedCallback.create(17, 0));
        javaClassClass.defineMethod("new_array", IndexedCallback.create(18, 1));
        javaClassClass.defineMethod("fields", IndexedCallback.create(20, 0));
        javaClassClass.defineMethod("field", IndexedCallback.create(21, 1));
        javaClassClass.defineMethod("interfaces", IndexedCallback.create(22, 0));
        javaClassClass.defineMethod("primitive?", IndexedCallback.create(23, 0));
        javaClassClass.defineMethod("assignable_from?", IndexedCallback.create(24, 1));
        javaClassClass.defineMethod("component_type", IndexedCallback.create(25, 0));
        javaClassClass.getMetaClass().undefineMethod("new");
        return javaClassClass;
    }

    public static JavaClass for_name(IRubyObject recv, IRubyObject name) {
        return new JavaClass(recv.getRuntime(), name.asSymbol());
    }

    public RubyBoolean public_p() {
        return RubyBoolean.newBoolean(this.runtime, Modifier.isPublic(this.javaClass.getModifiers()));
    }

    public RubyBoolean final_p() {
        return RubyBoolean.newBoolean(this.runtime, Modifier.isFinal(this.javaClass.getModifiers()));
    }

    public RubyBoolean interface_p() {
        return RubyBoolean.newBoolean(this.runtime, this.javaClass.isInterface());
    }

    public RubyBoolean array_p() {
        return RubyBoolean.newBoolean(this.runtime, this.javaClass.isArray());
    }

    public RubyString name() {
        return RubyString.newString(this.runtime, this.javaClass.getName());
    }

    public IRubyObject superclass() {
        Class superclass = this.javaClass.getSuperclass();
        if (superclass == null) {
            return this.runtime.getNil();
        }
        return new JavaClass(this.runtime, superclass.getName());
    }

    public RubyFixnum op_cmp(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw new TypeError(this.getRuntime(), "<=> requires JavaClass (" + other.getType() + " given)");
        }
        JavaClass otherClass = (JavaClass)other;
        if (this.javaClass == otherClass.javaClass) {
            return RubyFixnum.newFixnum(this.getRuntime(), 0L);
        }
        if (otherClass.javaClass.isAssignableFrom(this.javaClass)) {
            return RubyFixnum.newFixnum(this.getRuntime(), -1L);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), 1L);
    }

    public RubyArray java_instance_methods() {
        Method[] methods = this.javaClass.getMethods();
        RubyArray result = RubyArray.newArray(this.runtime, methods.length);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (!Modifier.isStatic(method.getModifiers())) {
                result.append(JavaMethod.create(this.runtime, method));
            }
            ++i;
        }
        return result;
    }

    public RubyArray java_class_methods() {
        Method[] methods = this.javaClass.getMethods();
        RubyArray result = RubyArray.newArray(this.runtime, methods.length);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers())) {
                result.append(JavaMethod.create(this.runtime, method));
            }
            ++i;
        }
        return result;
    }

    public JavaMethod java_method(IRubyObject[] args) {
        if (args.length < 1) {
            throw new ArgumentError(this.getRuntime(), args.length, 1);
        }
        String methodName = args[0].asSymbol();
        Class[] argumentTypes = new Class[args.length - 1];
        int i = 1;
        while (i < args.length) {
            JavaClass type = JavaClass.for_name(this, args[i]);
            argumentTypes[i - 1] = type.javaClass;
            ++i;
        }
        return JavaMethod.create(this.runtime, this.javaClass, methodName, argumentTypes);
    }

    public RubyArray constructors() {
        Constructor<?>[] constructors = this.javaClass.getConstructors();
        RubyArray result = RubyArray.newArray(this.getRuntime(), constructors.length);
        int i = 0;
        while (i < constructors.length) {
            result.append(new JavaConstructor(this.getRuntime(), constructors[i]));
            ++i;
        }
        return result;
    }

    public JavaConstructor constructor(IRubyObject[] args) {
        Constructor constructor;
        Class[] parameterTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            String name = args[i].asSymbol();
            parameterTypes[i] = this.getRuntime().getJavaSupport().loadJavaClass(name);
            ++i;
        }
        try {
            constructor = this.javaClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new NameError(this.getRuntime(), "no matching java constructor");
        }
        return new JavaConstructor(this.getRuntime(), constructor);
    }

    public JavaClass array_class() {
        return new JavaClass(this.getRuntime(), Array.newInstance(this.javaClass, 0).getClass());
    }

    public JavaObject new_array(IRubyObject lengthArgument) {
        if (!(lengthArgument instanceof RubyInteger)) {
            throw new TypeError(this.getRuntime(), lengthArgument, this.getRuntime().getClasses().getIntegerClass());
        }
        int length = (int)((RubyInteger)lengthArgument).getLongValue();
        return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass, length));
    }

    public RubyArray fields() {
        Field[] fields = this.javaClass.getFields();
        RubyArray result = RubyArray.newArray(this.getRuntime(), fields.length);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            result.append(RubyString.newString(this.getRuntime(), field.getName()));
            ++i;
        }
        return result;
    }

    public JavaField field(IRubyObject name) {
        Field field;
        String stringName = name.asSymbol();
        try {
            field = this.javaClass.getField(stringName);
        }
        catch (NoSuchFieldException nsfe) {
            throw new NameError(this.getRuntime(), "undefined field '" + stringName + "' for class '" + this.javaClass.getName() + "'");
        }
        return new JavaField(this.getRuntime(), field);
    }

    public RubyArray interfaces() {
        Class<?>[] interfaces = this.javaClass.getInterfaces();
        RubyArray result = RubyArray.newArray(this.getRuntime(), interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            result.append(RubyString.newString(this.getRuntime(), interfaces[i].getName()));
            ++i;
        }
        return result;
    }

    public RubyBoolean primitive_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isPrimitive());
    }

    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw new TypeError(this.getRuntime(), "assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).getValue();
        if (!this.javaClass.isPrimitive() && otherClass == Void.TYPE || this.javaClass.isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        Class thisJavaClass = JavaUtil.primitiveToWrapper(this.javaClass);
        if (thisJavaClass.isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = JavaClass.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(thisJavaClass)) {
            if ((class$java$lang$Number == null ? (class$java$lang$Number = JavaClass.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(otherClass)) {
                return this.getRuntime().getTrue();
            }
            if (otherClass.equals(class$java$lang$Character == null ? (class$java$lang$Character = JavaClass.class$("java.lang.Character")) : class$java$lang$Character)) {
                return this.getRuntime().getTrue();
            }
        }
        if (thisJavaClass.equals(class$java$lang$Character == null ? (class$java$lang$Character = JavaClass.class$("java.lang.Character")) : class$java$lang$Character) && (class$java$lang$Number == null ? (class$java$lang$Number = JavaClass.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(otherClass)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private boolean isPrimitive() {
        return this.javaClass.isPrimitive();
    }

    public JavaClass component_type() {
        if (!this.javaClass.isArray()) {
            throw new TypeError(this.getRuntime(), "not a java array-class");
        }
        return new JavaClass(this.getRuntime(), this.javaClass.getComponentType());
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.public_p();
            }
            case 2: {
                return this.final_p();
            }
            case 3: {
                return this.interface_p();
            }
            case 4: {
                return this.array_p();
            }
            case 5: {
                return this.name();
            }
            case 7: {
                return this.superclass();
            }
            case 8: {
                return this.op_cmp(args[0]);
            }
            case 11: {
                return this.java_instance_methods();
            }
            case 12: {
                return this.java_class_methods();
            }
            case 14: {
                return this.java_method(args);
            }
            case 15: {
                return this.constructors();
            }
            case 16: {
                return this.constructor(args);
            }
            case 17: {
                return this.array_class();
            }
            case 18: {
                return this.new_array(args[0]);
            }
            case 20: {
                return this.fields();
            }
            case 21: {
                return this.field(args[0]);
            }
            case 22: {
                return this.interfaces();
            }
            case 23: {
                return this.primitive_p();
            }
            case 24: {
                return this.assignable_from_p(args[0]);
            }
            case 25: {
                return this.component_type();
            }
        }
        return super.callIndexed(index, args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

