/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaSupport {
    private Ruby runtime;
    private Map exceptionHandlers = new HashMap();
    private ClassLoader javaClassLoader = ClassLoader.getSystemClassLoader();
    private Map javaObjectMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Exception;

    public JavaSupport(Ruby ruby) {
        this.runtime = ruby;
    }

    public Class loadJavaClass(String className) {
        try {
            Class result = JavaSupport.primitiveClass(className);
            if (result == null) {
                return this.javaClassLoader.loadClass(className);
            }
            return result;
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw new NameError(this.runtime, "cannot load Java class " + className);
        }
    }

    public void addToClasspath(URL url) {
        this.javaClassLoader = new URLClassLoader(new URL[]{url}, this.javaClassLoader);
    }

    public void defineExceptionHandler(String exceptionClass, RubyProc handler) {
        this.exceptionHandlers.put(exceptionClass, handler);
    }

    public void handleNativeException(Exception exception) {
        Class<?> excptnClass = exception.getClass();
        RubyProc handler = (RubyProc)this.exceptionHandlers.get(excptnClass.getName());
        while (handler == null && excptnClass != (class$java$lang$Exception == null ? JavaSupport.class$("java.lang.Exception") : class$java$lang$Exception)) {
            excptnClass = excptnClass.getSuperclass();
        }
        if (handler == null) {
            throw this.createRaiseException(exception);
        }
        handler.call(new IRubyObject[]{JavaUtil.convertJavaToRuby(this.runtime, exception)});
    }

    private RaiseException createRaiseException(Exception exception) {
        StringWriter stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        StringBuffer sb = new StringBuffer();
        sb.append("Native Exception: '");
        sb.append(exception.getClass()).append("'; Message: ");
        sb.append(exception.getMessage());
        sb.append("; StackTrace: ");
        sb.append(stackTrace.getBuffer().toString());
        RaiseException result = new RaiseException(this.runtime, "RuntimeError", sb.toString());
        result.initCause(exception);
        return result;
    }

    private static Class primitiveClass(String name) {
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public ClassLoader getJavaClassLoader() {
        return this.javaClassLoader;
    }

    public JavaObject getJavaObjectFromCache(Object object) {
        Integer hash = this.getHashFromObject(object);
        List cached = (List)this.javaObjectMap.get(hash);
        if (cached == null) {
            return null;
        }
        Iterator iter = cached.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            JavaObject javaObject = (JavaObject)ref.get();
            if (javaObject == null) {
                iter.remove();
                continue;
            }
            if (javaObject.getValue() != object) continue;
            return javaObject;
        }
        return null;
    }

    public void putJavaObjectIntoCache(JavaObject object) {
        Integer hash = this.getHashFromObject(object.getValue());
        LinkedList<SoftReference<JavaObject>> cached = (LinkedList<SoftReference<JavaObject>>)this.javaObjectMap.get(hash);
        if (cached == null) {
            cached = new LinkedList<SoftReference<JavaObject>>();
            this.javaObjectMap.put(hash, cached);
        }
        cached.add(new SoftReference<JavaObject>(object));
    }

    private Integer getHashFromObject(Object value) {
        if (value == null) {
            return new Integer(0);
        }
        if (value instanceof Proxy) {
            return new Integer(value.getClass().hashCode());
        }
        return new Integer(value.hashCode());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

