/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.bsf;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.BSFFunctions;
import java.util.Vector;
import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ReturnJump;
import org.jruby.exceptions.ThrowJump;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyEngine
extends BSFEngineImpl {
    private Ruby runtime;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$ibm$bsf$util$BSFFunctions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(String file, int line, int col, Object funcBody, Vector paramNames, Vector args) {
        try {
            this.runtime.getFrameStack().push();
            this.runtime.pushDynamicVars();
            this.runtime.getScope().push(paramNames);
            int i = 0;
            int size = args.size();
            while (i < size) {
                this.runtime.currentScope().setValue(i, this.convertToRuby(args.get(i)));
                ++i;
            }
            this.runtime.setPosition(file, line);
            INode node = this.runtime.getParser().parse(file, funcBody.toString());
            Object object = this.convertToJava(this.runtime.getTopSelf().eval(node), class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
            return object;
        }
        finally {
            this.runtime.getScope().pop();
            this.runtime.popDynamicVars();
            this.runtime.getFrameStack().pop();
        }
    }

    public Object eval(String file, int line, int col, Object expr) throws BSFException {
        try {
            this.runtime.setPosition(file, line);
            IRubyObject result = this.runtime.evalScript(expr.toString());
            return this.convertToJava(result, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file, int line, int col, Object expr) throws BSFException {
        try {
            this.runtime.setPosition(file, line);
            this.runtime.evalScript(expr.toString());
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv, String method, Object[] args) throws BSFException {
        try {
            IRubyObject rubyRecv = recv != null ? JavaUtil.convertJavaToRuby(this.runtime, recv) : this.runtime.getTopSelf();
            IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(this.runtime, args);
            IRubyObject result = rubyRecv.callMethod(method, rubyArgs);
            return this.convertToJava(result, class$java$lang$Object == null ? (class$java$lang$Object = JRubyEngine.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception excptn) {
            JRubyEngine.printException(this.runtime, excptn);
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, excptn.getMessage(), (Throwable)excptn);
        }
    }

    private IRubyObject convertToRuby(Object value) {
        IRubyObject result = JavaUtil.convertJavaToRuby(this.runtime, value);
        if (result instanceof JavaObject) {
            this.runtime.getLoadService().require("java");
            result = this.runtime.getClasses().getObjectClass().getConstant("JavaUtilities").callMethod("wrap", new IRubyObject[]{result, RubyString.newString(this.runtime, value.getClass().getName())});
        }
        return result;
    }

    private Object convertToJava(IRubyObject value, Class type) {
        this.runtime.getLoadService().require("java");
        if (value.isKindOf(this.runtime.getClasses().getClass("JavaProxy"))) {
            value = value.getInstanceVariable("java_object");
        }
        value = Java.primitive_to_java(value, value);
        return JavaUtil.convertArgument(value, type);
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.runtime = Ruby.getDefaultInstance();
        int i = 0;
        int size = declaredBeans.size();
        while (i < size) {
            BSFDeclaredBean bean = (BSFDeclaredBean)declaredBeans.elementAt(i);
            this.runtime.getGlobalVariables().define(GlobalVariable.variableName(bean.name), new BeanGlobalVariable(this.runtime, bean));
            ++i;
        }
        this.runtime.getGlobalVariables().defineReadonly("$bsf", new FunctionsGlobalVariable(this.runtime, new BSFFunctions(mgr, (BSFEngine)this)));
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.runtime.getGlobalVariables().define(GlobalVariable.variableName(bean.name), new BeanGlobalVariable(this.runtime, bean));
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.runtime.getGlobalVariables().set(GlobalVariable.variableName(bean.name), this.runtime.getNil());
    }

    public void handleException(BSFException bsfExcptn) {
        JRubyEngine.printException(this.runtime, (Exception)bsfExcptn.getTargetException());
    }

    private static void printException(Ruby ruby, Exception exception) {
        if (exception instanceof RaiseException) {
            ruby.printError(((RaiseException)exception).getException());
        } else if (exception instanceof ThrowJump) {
            ruby.printError(((ThrowJump)exception).getNameError());
        } else if (exception instanceof BreakJump) {
            ruby.getErrorStream().println("break without block.");
        } else if (exception instanceof ReturnJump) {
            ruby.getErrorStream().println("return without block.");
        }
    }

    public void terminate() {
        this.runtime.dispose();
        this.runtime = null;
        super.terminate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FunctionsGlobalVariable
    implements IAccessor {
        private Ruby runtime;
        private BSFFunctions functions;

        public FunctionsGlobalVariable(Ruby runtime, BSFFunctions functions) {
            this.runtime = runtime;
            this.functions = functions;
        }

        public IRubyObject getValue() {
            IRubyObject result = JavaUtil.convertJavaToRuby(this.runtime, this.functions, class$com$ibm$bsf$util$BSFFunctions == null ? (class$com$ibm$bsf$util$BSFFunctions = JRubyEngine.class$("com.ibm.bsf.util.BSFFunctions")) : class$com$ibm$bsf$util$BSFFunctions);
            if (result instanceof JavaObject) {
                this.runtime.getLoadService().require("java");
                result = this.runtime.getClasses().getObjectClass().getConstant("JavaUtilities").callMethod("wrap", new IRubyObject[]{result, RubyString.newString(this.runtime, (class$com$ibm$bsf$util$BSFFunctions == null ? (class$com$ibm$bsf$util$BSFFunctions = JRubyEngine.class$("com.ibm.bsf.util.BSFFunctions")) : class$com$ibm$bsf$util$BSFFunctions).getName())});
            }
            return result;
        }

        public IRubyObject setValue(IRubyObject value) {
            return value;
        }
    }

    private static class BeanGlobalVariable
    implements IAccessor {
        private Ruby runtime;
        private BSFDeclaredBean bean;

        public BeanGlobalVariable(Ruby runtime, BSFDeclaredBean bean) {
            this.runtime = runtime;
            this.bean = bean;
        }

        public IRubyObject getValue() {
            IRubyObject result = JavaUtil.convertJavaToRuby(this.runtime, this.bean.bean, this.bean.type);
            if (result instanceof JavaObject) {
                this.runtime.getLoadService().require("java");
                result = this.runtime.getClasses().getObjectClass().getConstant("JavaUtilities").callMethod("wrap", new IRubyObject[]{result, RubyString.newString(this.runtime, this.bean.type.getName())});
            }
            return result;
        }

        public IRubyObject setValue(IRubyObject value) {
            this.runtime.getLoadService().require("java");
            if (value.isKindOf(this.runtime.getClasses().getClass("JavaProxy"))) {
                value = value.getInstanceVariable("java_object");
            }
            value = Java.primitive_to_java(value, value);
            this.bean.bean = JavaUtil.convertArgument(value, this.bean.type);
            return value;
        }
    }
}

