/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;

public class Mutex
extends RubyObject
implements IndexCallable {
    private boolean isLocked = false;
    private static final int LOCK = 1;
    private static final int UNLOCK = 2;
    private static final int LOCKED_P = 3;
    private static final int NEW = 260;

    private Mutex(Ruby runtime) {
        super(runtime, (RubyClass)runtime.getClasses().getClass("Mutex"));
    }

    public static void createMutexClass(Ruby runtime) {
        RubyClass mutexClass = runtime.defineClass("Mutex", runtime.getClasses().getObjectClass());
        mutexClass.defineMethod("lock", IndexedCallback.create(1, 0));
        mutexClass.defineMethod("unlock", IndexedCallback.create(2, 0));
        mutexClass.defineMethod("locked?", IndexedCallback.create(3, 0));
    }

    public Mutex lock() {
        this.isLocked = true;
        return this;
    }

    public Mutex unlock() {
        this.isLocked = false;
        return this;
    }

    public RubyBoolean locked_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isLocked);
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.lock();
            }
            case 2: {
                return this.unlock();
            }
            case 3: {
                return this.locked_p();
            }
        }
        return super.callIndexed(index, args);
    }
}

